/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.PlayerUnlocks;
import draylar.identity.api.platform.IdentityConfig;
import draylar.identity.api.platform.IdentityPlatform;
import draylar.identity.api.variant.IdentityType;
import draylar.identity.screen.widget.EntityWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2179;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2321;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class IdentityCommand {
    private static final Map<String, Consumer<Boolean>> BOOLEAN_SETTERS = new LinkedHashMap<String, Consumer<Boolean>>();
    private static final Map<String, IntConsumer> INT_SETTERS = new LinkedHashMap<String, IntConsumer>();
    private static final Map<String, Consumer<Float>> FLOAT_SETTERS = new LinkedHashMap<String, Consumer<Float>>();
    private static final List<String> STRING_OPTIONS = new ArrayList<String>();
    private static final SuggestionProvider<class_2168> BOOLEAN_OPTION_SUGGESTIONS = (context, builder) -> class_2172.method_9265(BOOLEAN_SETTERS.keySet(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<class_2168> INT_OPTION_SUGGESTIONS = (context, builder) -> class_2172.method_9265(INT_SETTERS.keySet(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<class_2168> FLOAT_OPTION_SUGGESTIONS = (context, builder) -> class_2172.method_9265(FLOAT_SETTERS.keySet(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<class_2168> STRING_OPTION_SUGGESTIONS = (context, builder) -> class_2172.method_9265(STRING_OPTIONS, (SuggestionsBuilder)builder);
    private static final SuggestionProvider<class_2168> FORCED_IDENTITY_SUGGESTIONS = (context, builder) -> {
        ArrayList<String> suggestions = new ArrayList<String>();
        suggestions.add("none");
        class_7923.field_41177.method_10235().forEach(id -> suggestions.add(id.toString()));
        return class_2172.method_9265(suggestions, (SuggestionsBuilder)builder);
    };

    private static LiteralArgumentBuilder<class_2168> createListCommand(class_7157 registryAccess) {
        LiteralArgumentBuilder listBuilder = class_2170.method_9247((String)"list");
        listBuilder.then(IdentityCommand.createStringListNode("allowed_swappers", () -> IdentityConfig.getInstance().allowedSwappers(), true, "player"));
        listBuilder.then(IdentityCommand.createStringListNode("advancements_required_for_flight", () -> IdentityConfig.getInstance().advancementsRequiredForFlight(), false, "advancement"));
        listBuilder.then(IdentityCommand.createEntityListNode("extra_aquatic_entities", () -> IdentityConfig.getInstance().extraAquaticEntities(), registryAccess));
        listBuilder.then(IdentityCommand.createEntityListNode("removed_aquatic_entities", () -> IdentityConfig.getInstance().removedAquaticEntities(), registryAccess));
        listBuilder.then(IdentityCommand.createEntityListNode("extra_flying_entities", () -> IdentityConfig.getInstance().extraFlyingEntities(), registryAccess));
        listBuilder.then(IdentityCommand.createEntityListNode("removed_flying_entities", () -> IdentityConfig.getInstance().removedFlyingEntities(), registryAccess));
        return listBuilder;
    }

    private static LiteralArgumentBuilder<class_2168> createMapCommand(class_7157 registryAccess) {
        LiteralArgumentBuilder mapBuilder = class_2170.method_9247((String)"map");
        mapBuilder.then(IdentityCommand.createAbilityCooldownCommands(registryAccess));
        mapBuilder.then(IdentityCommand.createRequiredKillCommands(registryAccess));
        return mapBuilder;
    }

    private static LiteralArgumentBuilder<class_2168> createStringListNode(String literal, Supplier<List<String>> listSupplier, boolean caseInsensitive, String valueArgumentName) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)literal).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)valueArgumentName, (ArgumentType)StringArgumentType.string()).executes(ctx -> IdentityCommand.addToList((class_2168)ctx.getSource(), listSupplier, caseInsensitive, literal, StringArgumentType.getString((CommandContext)ctx, (String)valueArgumentName)))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)valueArgumentName, (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9265(new ArrayList((Collection)listSupplier.get()), (SuggestionsBuilder)builder)).executes(ctx -> IdentityCommand.removeFromList((class_2168)ctx.getSource(), listSupplier, caseInsensitive, literal, StringArgumentType.getString((CommandContext)ctx, (String)valueArgumentName)))))).then(class_2170.method_9247((String)"clear").executes(ctx -> IdentityCommand.clearList((class_2168)ctx.getSource(), listSupplier, literal)));
    }

    private static LiteralArgumentBuilder<class_2168> createEntityListNode(String literal, Supplier<List<String>> listSupplier, class_7157 registryAccess) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)literal).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"entity", (ArgumentType)class_7733.method_45603((class_7157)registryAccess, (class_5321)class_7924.field_41266)).suggests(class_2321.field_10935).executes(ctx -> {
            class_2960 id = class_7733.method_45610((CommandContext)ctx, (String)"entity").method_40237().method_29177();
            return IdentityCommand.addToList((class_2168)ctx.getSource(), listSupplier, false, literal, id.toString());
        })))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"entity", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9265(new ArrayList((Collection)listSupplier.get()), (SuggestionsBuilder)builder)).executes(ctx -> IdentityCommand.removeFromList((class_2168)ctx.getSource(), listSupplier, false, literal, StringArgumentType.getString((CommandContext)ctx, (String)"entity")))))).then(class_2170.method_9247((String)"clear").executes(ctx -> IdentityCommand.clearList((class_2168)ctx.getSource(), listSupplier, literal)));
    }

    private static LiteralArgumentBuilder<class_2168> createAbilityCooldownCommands(class_7157 registryAccess) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ability_cooldowns").then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"entity", (ArgumentType)class_7733.method_45603((class_7157)registryAccess, (class_5321)class_7924.field_41266)).suggests(class_2321.field_10935).then(class_2170.method_9244((String)"cooldown", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            class_2960 id = class_7733.method_45610((CommandContext)ctx, (String)"entity").method_40237().method_29177();
            int cooldown = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"cooldown");
            return IdentityCommand.setAbilityCooldown((class_2168)ctx.getSource(), id.toString(), cooldown);
        }))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"entity", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9265(IdentityConfig.getInstance().getAbilityCooldownMap().keySet(), (SuggestionsBuilder)builder)).executes(ctx -> IdentityCommand.removeAbilityCooldown((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"entity")))))).then(class_2170.method_9247((String)"clear").executes(ctx -> IdentityCommand.clearAbilityCooldowns((class_2168)ctx.getSource())));
    }

    private static LiteralArgumentBuilder<class_2168> createRequiredKillCommands(class_7157 registryAccess) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"required_kills").then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"entity", (ArgumentType)class_7733.method_45603((class_7157)registryAccess, (class_5321)class_7924.field_41266)).suggests(class_2321.field_10935).then(class_2170.method_9244((String)"kills", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            class_2960 id = class_7733.method_45610((CommandContext)ctx, (String)"entity").method_40237().method_29177();
            int kills = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"kills");
            return IdentityCommand.setRequiredKillOverride((class_2168)ctx.getSource(), id.toString(), kills);
        }))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"entity", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9265(IdentityConfig.getInstance().getRequiredKillsByType().keySet(), (SuggestionsBuilder)builder)).executes(ctx -> IdentityCommand.removeRequiredKillOverride((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"entity")))))).then(class_2170.method_9247((String)"clear").executes(ctx -> IdentityCommand.clearRequiredKillOverrides((class_2168)ctx.getSource())));
    }

    private static int addToList(class_2168 source, Supplier<List<String>> supplier, boolean caseInsensitive, String listName, String value) {
        boolean exists;
        List<String> list = supplier.get();
        boolean bl = exists = caseInsensitive ? list.stream().anyMatch(entry -> entry.equalsIgnoreCase(value)) : list.contains(value);
        if (exists) {
            source.method_9213((class_2561)class_2561.method_43470((String)(value + " is already present in " + IdentityCommand.formatKey(listName))));
            return 0;
        }
        list.add(value);
        IdentityCommand.persistConfig(source, (class_2561)class_2561.method_43470((String)("Added " + value + " to " + IdentityCommand.formatKey(listName))));
        return 1;
    }

    private static int removeFromList(class_2168 source, Supplier<List<String>> supplier, boolean caseInsensitive, String listName, String value) {
        List<String> list = supplier.get();
        boolean removed = caseInsensitive ? list.removeIf(entry -> entry.equalsIgnoreCase(value)) : list.remove(value);
        if (!removed) {
            source.method_9213((class_2561)class_2561.method_43470((String)(value + " is not present in " + IdentityCommand.formatKey(listName))));
            return 0;
        }
        IdentityCommand.persistConfig(source, (class_2561)class_2561.method_43470((String)("Removed " + value + " from " + IdentityCommand.formatKey(listName))));
        return 1;
    }

    private static int clearList(class_2168 source, Supplier<List<String>> supplier, String listName) {
        List<String> list = supplier.get();
        if (list.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)(IdentityCommand.formatKey(listName) + " is already empty")), false);
            return 0;
        }
        list.clear();
        IdentityCommand.persistConfig(source, (class_2561)class_2561.method_43470((String)("Cleared " + IdentityCommand.formatKey(listName))));
        return 1;
    }

    private static int setAbilityCooldown(class_2168 source, String entityId, int cooldown) {
        IdentityConfig.getInstance().getAbilityCooldownMap().put(entityId, cooldown);
        IdentityCommand.persistConfig(source, (class_2561)class_2561.method_43470((String)("Set ability cooldown for " + entityId + " to " + cooldown)));
        return 1;
    }

    private static int removeAbilityCooldown(class_2168 source, String entityId) {
        Integer removed = IdentityConfig.getInstance().getAbilityCooldownMap().remove(entityId);
        if (removed == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("No ability cooldown override exists for " + entityId)));
            return 0;
        }
        IdentityCommand.persistConfig(source, (class_2561)class_2561.method_43470((String)("Removed ability cooldown override for " + entityId)));
        return 1;
    }

    private static int clearAbilityCooldowns(class_2168 source) {
        Map<String, Integer> map = IdentityConfig.getInstance().getAbilityCooldownMap();
        if (map.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"Ability cooldown overrides are already empty"), false);
            return 0;
        }
        map.clear();
        IdentityCommand.persistConfig(source, (class_2561)class_2561.method_43470((String)"Cleared all ability cooldown overrides"));
        return 1;
    }

    private static int setRequiredKillOverride(class_2168 source, String entityId, int kills) {
        IdentityConfig.getInstance().getRequiredKillsByType().put(entityId, kills);
        IdentityCommand.persistConfig(source, (class_2561)class_2561.method_43470((String)("Set required kills for " + entityId + " to " + kills)));
        return 1;
    }

    private static int removeRequiredKillOverride(class_2168 source, String entityId) {
        Integer removed = IdentityConfig.getInstance().getRequiredKillsByType().remove(entityId);
        if (removed == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("No required kill override exists for " + entityId)));
            return 0;
        }
        IdentityCommand.persistConfig(source, (class_2561)class_2561.method_43470((String)("Removed required kill override for " + entityId)));
        return 1;
    }

    private static int clearRequiredKillOverrides(class_2168 source) {
        Map<String, Integer> map = IdentityConfig.getInstance().getRequiredKillsByType();
        if (map.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"Required kill overrides are already empty"), false);
            return 0;
        }
        map.clear();
        IdentityCommand.persistConfig(source, (class_2561)class_2561.method_43470((String)"Cleared all required kill overrides"));
        return 1;
    }

    private static int setBooleanOption(class_2168 source, String option, boolean value) {
        String key = option.toLowerCase(Locale.ROOT);
        Consumer<Boolean> setter = BOOLEAN_SETTERS.get(key);
        if (setter == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Unknown boolean option: " + option)));
            return 0;
        }
        setter.accept(value);
        IdentityCommand.persistConfig(source, (class_2561)class_2561.method_43470((String)("Set " + IdentityCommand.formatKey(key) + " to " + value)));
        return 1;
    }

    private static int setIntegerOption(class_2168 source, String option, int value) {
        String key = option.toLowerCase(Locale.ROOT);
        IntConsumer setter = INT_SETTERS.get(key);
        if (setter == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Unknown integer option: " + option)));
            return 0;
        }
        if ("max_health".equals(key) && value < 1) {
            source.method_9213((class_2561)class_2561.method_43470((String)"max health must be at least 1"));
            return 0;
        }
        setter.accept(value);
        IdentityCommand.persistConfig(source, (class_2561)class_2561.method_43470((String)("Set " + IdentityCommand.formatKey(key) + " to " + value)));
        return 1;
    }

    private static int setFloatOption(class_2168 source, String option, float value) {
        String key = option.toLowerCase(Locale.ROOT);
        Consumer<Float> setter = FLOAT_SETTERS.get(key);
        if (setter == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Unknown float option: " + option)));
            return 0;
        }
        if (value <= 0.0f) {
            source.method_9213((class_2561)class_2561.method_43470((String)"fly speed must be greater than 0"));
            return 0;
        }
        setter.accept(Float.valueOf(value));
        IdentityCommand.persistConfig(source, (class_2561)class_2561.method_43470((String)("Set " + IdentityCommand.formatKey(key) + " to " + value)));
        return 1;
    }

    private static int setStringOption(class_2168 source, String option, String rawValue) {
        String key = option.toLowerCase(Locale.ROOT);
        if (!STRING_OPTIONS.contains(key)) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Unknown string option: " + option)));
            return 0;
        }
        if ("forced_identity".equals(key)) {
            if (rawValue.equalsIgnoreCase("none") || rawValue.equalsIgnoreCase("null")) {
                IdentityConfig.getInstance().setForcedIdentity(null);
                IdentityCommand.persistConfig(source, (class_2561)class_2561.method_43470((String)"Cleared forced identity"));
                return 1;
            }
            class_2960 identifier = class_2960.method_12829((String)rawValue);
            if (identifier == null || !class_7923.field_41177.method_10250(identifier)) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Unknown entity: " + rawValue)));
                return 0;
            }
            IdentityConfig.getInstance().setForcedIdentity(identifier.toString());
            IdentityCommand.persistConfig(source, (class_2561)class_2561.method_43470((String)("Set forced identity to " + String.valueOf(identifier))));
            return 1;
        }
        return 0;
    }

    private static int reloadConfig(class_2168 source) {
        if (IdentityPlatform.getReloader() == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"No config reloader is registered"));
            return 0;
        }
        IdentityPlatform.getReloader().reloadConfig();
        source.method_9226(() -> class_2561.method_43470((String)"Reloaded Identity config"), true);
        return 1;
    }

    private static void persistConfig(class_2168 source, class_2561 message) {
        source.method_9226(() -> message, true);
        if (IdentityPlatform.getReloader() != null) {
            IdentityPlatform.getReloader().saveConfig();
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)"Unable to save config changes because no reloader is registered"));
        }
    }

    private static String formatKey(String key) {
        return key.replace('_', ' ');
    }

    public static void register() {
        CommandRegistrationEvent.EVENT.register((dispatcher, registryAccess, b) -> {
            LiteralCommandNode rootNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"identity").requires(source -> source.method_9259(2))).build();
            LiteralCommandNode grantNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"grant").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"everything").executes(context -> {
                class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
                for (IdentityType<?> type : IdentityType.getAllTypes(player.method_37908())) {
                    if (PlayerUnlocks.has((class_1657)player, type)) continue;
                    PlayerUnlocks.unlock(player, type);
                }
                return 1;
            }))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"identity", (ArgumentType)class_2232.method_9441()).executes(context -> {
                IdentityCommand.grant(((class_2168)context.getSource()).method_44023(), class_2186.method_9315((CommandContext)context, (String)"player"), class_2232.method_9443((CommandContext)context, (String)"identity"), null);
                return 1;
            })).then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(context -> {
                class_2487 nbt = class_2179.method_9285((CommandContext)context, (String)"nbt");
                IdentityCommand.grant(((class_2168)context.getSource()).method_44023(), class_2186.method_9315((CommandContext)context, (String)"player"), class_2232.method_9443((CommandContext)context, (String)"identity"), nbt);
                return 1;
            }))))).build();
            LiteralCommandNode revokeNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"revoke").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"everything").executes(context -> {
                class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
                for (IdentityType<?> type : IdentityType.getAllTypes(player.method_37908())) {
                    if (!PlayerUnlocks.has((class_1657)player, type)) continue;
                    PlayerUnlocks.revoke(player, type);
                }
                return 1;
            }))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"identity", (ArgumentType)class_2232.method_9441()).executes(context -> {
                IdentityCommand.revoke(((class_2168)context.getSource()).method_44023(), class_2186.method_9315((CommandContext)context, (String)"player"), class_2232.method_9443((CommandContext)context, (String)"identity"), null);
                return 1;
            })).then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(context -> {
                class_2487 nbt = class_2179.method_9285((CommandContext)context, (String)"nbt");
                IdentityCommand.revoke(((class_2168)context.getSource()).method_44023(), class_2186.method_9315((CommandContext)context, (String)"player"), class_2232.method_9443((CommandContext)context, (String)"identity"), nbt);
                return 1;
            }))))).build();
            LiteralCommandNode equip = ((LiteralArgumentBuilder)class_2170.method_9247((String)"equip").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"identity", (ArgumentType)class_2232.method_9441()).executes(context -> {
                IdentityCommand.equip(((class_2168)context.getSource()).method_44023(), class_2186.method_9315((CommandContext)context, (String)"player"), class_2232.method_9443((CommandContext)context, (String)"identity"), null);
                return 1;
            })).then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(context -> {
                class_2487 nbt = class_2179.method_9285((CommandContext)context, (String)"nbt");
                IdentityCommand.equip(((class_2168)context.getSource()).method_44023(), class_2186.method_9315((CommandContext)context, (String)"player"), class_2232.method_9443((CommandContext)context, (String)"identity"), nbt);
                return 1;
            }))))).build();
            LiteralCommandNode unequip = ((LiteralArgumentBuilder)class_2170.method_9247((String)"unequip").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> {
                IdentityCommand.unequip(((class_2168)context.getSource()).method_44023(), class_2186.method_9315((CommandContext)context, (String)"player"));
                return 1;
            }))).build();
            LiteralCommandNode test = ((LiteralArgumentBuilder)class_2170.method_9247((String)"test").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9247((String)"not").then(class_2170.method_9244((String)"identity", (ArgumentType)class_2232.method_9441()).executes(context -> IdentityCommand.testNot(((class_2168)context.getSource()).method_44023(), class_2186.method_9315((CommandContext)context, (String)"player"), class_2232.method_9443((CommandContext)context, (String)"identity")))))).then(class_2170.method_9244((String)"identity", (ArgumentType)class_2232.method_9441()).executes(context -> IdentityCommand.test(((class_2168)context.getSource()).method_44023(), class_2186.method_9315((CommandContext)context, (String)"player"), class_2232.method_9443((CommandContext)context, (String)"identity")))))).build();
            LiteralCommandNode offsetNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"offset").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
                int v;
                EntityWidget.VERTICAL_OFFSET = v = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value");
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Entity\u2011grid Y\u2011offset set to \u00a7e" + v + "\u00a7r")), false);
                return 1;
            }))).build();
            LiteralCommandNode whitelistNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"whitelist").then(class_2170.method_9247((String)"enable").executes(ctx -> {
                IdentityConfig.getInstance().setEnableSwaps(false);
                if (IdentityConfig.getInstance().logCommands()) {
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Enabled identity whitelist"), true);
                }
                return 1;
            }))).then(class_2170.method_9247((String)"disable").executes(ctx -> {
                IdentityConfig.getInstance().setEnableSwaps(true);
                if (IdentityConfig.getInstance().logCommands()) {
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Disabled identity whitelist"), true);
                }
                return 1;
            }))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
                String name = StringArgumentType.getString((CommandContext)ctx, (String)"player");
                IdentityConfig.getInstance().allowedSwappers().add(name);
                if (IdentityConfig.getInstance().logCommands()) {
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Added " + name + " to identity whitelist")), true);
                }
                return 1;
            })))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
                String name = StringArgumentType.getString((CommandContext)ctx, (String)"player");
                IdentityConfig.getInstance().allowedSwappers().removeIf(n -> n.equalsIgnoreCase(name));
                if (IdentityConfig.getInstance().logCommands()) {
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Removed " + name + " from identity whitelist")), true);
                }
                return 1;
            })))).build();
            LiteralCommandNode professionNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"identity_villager").requires(src -> true)).then(class_2170.method_9247((String)"list").executes(ctx -> {
                class_3222 player = ((class_2168)ctx.getSource()).method_44023();
                Map<String, class_2487> map = PlayerIdentity.getVillagerIdentities((class_1657)player);
                if (map.isEmpty()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"You have no saved villager professions."), false);
                    return 1;
                }
                player.method_7353((class_2561)class_2561.method_43470((String)"Saved villager professions:"), false);
                map.forEach((name, tag) -> {
                    String prof = tag.method_10558("ProfessionId");
                    String dim = tag.method_10558("WorkstationDim");
                    long posLong = tag.method_10545("WorkstationPos") ? tag.method_10537("WorkstationPos") : Long.MIN_VALUE;
                    class_2338 blockPos = posLong == Long.MIN_VALUE ? null : class_2338.method_10092((long)posLong);
                    String location = blockPos == null ? "?" : blockPos.method_10263() + ", " + blockPos.method_10264() + ", " + blockPos.method_10260();
                    player.method_7353((class_2561)class_2561.method_43470((String)("- " + name + " -> " + prof + " @ " + dim + " " + location)), false);
                });
                return 1;
            }))).then(class_2170.method_9247((String)"show").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
                class_3222 player = ((class_2168)ctx.getSource()).method_44023();
                String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
                Map<String, class_2487> map = PlayerIdentity.getVillagerIdentities((class_1657)player);
                if (!map.containsKey(name)) {
                    player.method_7353((class_2561)class_2561.method_43470((String)("No villager saved under name: " + name)), false);
                    return 0;
                }
                class_2487 tag = map.get(name);
                String prof = tag.method_10558("ProfessionId");
                String dim = tag.method_10558("WorkstationDim");
                long posLong = tag.method_10545("WorkstationPos") ? tag.method_10537("WorkstationPos") : Long.MIN_VALUE;
                class_2338 blockPos = posLong == Long.MIN_VALUE ? null : class_2338.method_10092((long)posLong);
                String location = blockPos == null ? "?" : blockPos.method_10263() + ", " + blockPos.method_10264() + ", " + blockPos.method_10260();
                player.method_7353((class_2561)class_2561.method_43470((String)("Villager '" + name + "' profession: " + prof + " @ " + dim + " " + location)), false);
                return 1;
            })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"trade").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"myself").executes(ctx -> {
                class_3222 player = ((class_2168)ctx.getSource()).method_44023();
                if (!IdentityConfig.getInstance().allowSelfTrading()) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"identity.profession.trade.self_disabled"), false);
                    return 0;
                }
                class_1309 identity = PlayerIdentity.getIdentity((class_1657)player);
                if (!(identity instanceof class_1646)) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"identity.profession.trade.require_villager"), false);
                    return 0;
                }
                class_1646 villager = (class_1646)identity;
                villager.method_5992((class_1657)player, class_1268.field_5808);
                return 1;
            })))).build();
            LiteralArgumentBuilder configBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"config").then(class_2170.method_9247((String)"boolean").then(class_2170.method_9244((String)"option", (ArgumentType)StringArgumentType.word()).suggests(BOOLEAN_OPTION_SUGGESTIONS).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> IdentityCommand.setBooleanOption((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"option"), BoolArgumentType.getBool((CommandContext)ctx, (String)"value"))))))).then(class_2170.method_9247((String)"integer").then(class_2170.method_9244((String)"option", (ArgumentType)StringArgumentType.word()).suggests(INT_OPTION_SUGGESTIONS).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> IdentityCommand.setIntegerOption((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"option"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value"))))))).then(class_2170.method_9247((String)"float").then(class_2170.method_9244((String)"option", (ArgumentType)StringArgumentType.word()).suggests(FLOAT_OPTION_SUGGESTIONS).then(class_2170.method_9244((String)"value", (ArgumentType)FloatArgumentType.floatArg()).executes(ctx -> IdentityCommand.setFloatOption((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"option"), FloatArgumentType.getFloat((CommandContext)ctx, (String)"value"))))))).then(class_2170.method_9247((String)"string").then(class_2170.method_9244((String)"option", (ArgumentType)StringArgumentType.word()).suggests(STRING_OPTION_SUGGESTIONS).then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).suggests(FORCED_IDENTITY_SUGGESTIONS).executes(ctx -> IdentityCommand.setStringOption((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"option"), StringArgumentType.getString((CommandContext)ctx, (String)"value"))))))).then(IdentityCommand.createListCommand(registryAccess))).then(IdentityCommand.createMapCommand(registryAccess))).then(class_2170.method_9247((String)"reload").executes(ctx -> IdentityCommand.reloadConfig((class_2168)ctx.getSource())));
            rootNode.addChild((CommandNode)grantNode);
            rootNode.addChild((CommandNode)revokeNode);
            rootNode.addChild((CommandNode)equip);
            rootNode.addChild((CommandNode)unequip);
            rootNode.addChild((CommandNode)test);
            rootNode.addChild((CommandNode)offsetNode);
            rootNode.addChild((CommandNode)whitelistNode);
            rootNode.addChild((CommandNode)professionNode);
            rootNode.addChild((CommandNode)configBuilder.build());
            dispatcher.getRoot().addChild((CommandNode)rootNode);
        });
    }

    private static int test(class_3222 source, class_3222 player, class_2960 identity) {
        class_1299 type = (class_1299)class_7923.field_41177.method_10223(identity);
        if (PlayerIdentity.getIdentity((class_1657)player) != null && PlayerIdentity.getIdentity((class_1657)player).method_5864().equals(type)) {
            if (IdentityConfig.getInstance().logCommands()) {
                source.method_7353((class_2561)class_2561.method_43469((String)"identity.test_positive", (Object[])new Object[]{player.method_5476(), class_2561.method_43471((String)type.method_5882())}), true);
            }
            return 1;
        }
        if (IdentityConfig.getInstance().logCommands()) {
            source.method_7353((class_2561)class_2561.method_43469((String)"identity.test_failed", (Object[])new Object[]{player.method_5476(), class_2561.method_43471((String)type.method_5882())}), true);
        }
        return 0;
    }

    private static int testNot(class_3222 source, class_3222 player, class_2960 identity) {
        class_1299 type = (class_1299)class_7923.field_41177.method_10223(identity);
        if (PlayerIdentity.getIdentity((class_1657)player) != null && !PlayerIdentity.getIdentity((class_1657)player).method_5864().equals(type)) {
            if (IdentityConfig.getInstance().logCommands()) {
                source.method_7353((class_2561)class_2561.method_43469((String)"identity.test_failed", (Object[])new Object[]{player.method_5476(), class_2561.method_43471((String)type.method_5882())}), true);
            }
            return 1;
        }
        if (IdentityConfig.getInstance().logCommands()) {
            source.method_7353((class_2561)class_2561.method_43469((String)"identity.test_positive", (Object[])new Object[]{player.method_5476(), class_2561.method_43471((String)type.method_5882())}), true);
        }
        return 0;
    }

    private static void grant(class_3222 source, class_3222 player, class_2960 id, @Nullable class_2487 nbt) {
        IdentityType<class_1299> type = new IdentityType<class_1299>((class_1299)class_7923.field_41177.method_10223(id));
        class_5250 name = class_2561.method_43471((String)type.getEntityType().method_5882());
        if (nbt != null) {
            class_2487 copy = nbt.method_10553();
            copy.method_10582("id", id.toString());
            class_3218 serverWorld = source.method_51469();
            class_1297 loaded = class_1299.method_17842((class_2487)copy, (class_1937)serverWorld, it -> it);
            if (loaded instanceof class_1309) {
                class_1309 living = (class_1309)loaded;
                type = new IdentityType<class_1309>(living);
                name = type.createTooltipText((class_1299)living);
            }
        }
        if (!PlayerUnlocks.has((class_1657)player, type)) {
            boolean result = PlayerUnlocks.unlock(player, type);
            if (result && IdentityConfig.getInstance().logCommands()) {
                player.method_7353((class_2561)class_2561.method_43469((String)"identity.unlock_entity", (Object[])new Object[]{name}), true);
                source.method_7353((class_2561)class_2561.method_43469((String)"identity.grant_success", (Object[])new Object[]{name, player.method_5476()}), true);
            }
        } else if (IdentityConfig.getInstance().logCommands()) {
            source.method_7353((class_2561)class_2561.method_43469((String)"identity.already_has", (Object[])new Object[]{player.method_5476(), name}), true);
        }
    }

    private static void revoke(class_3222 source, class_3222 player, class_2960 id, @Nullable class_2487 nbt) {
        IdentityType<class_1299> type = new IdentityType<class_1299>((class_1299)class_7923.field_41177.method_10223(id));
        class_5250 name = class_2561.method_43471((String)type.getEntityType().method_5882());
        if (nbt != null) {
            class_2487 copy = nbt.method_10553();
            copy.method_10582("id", id.toString());
            class_3218 serverWorld = source.method_51469();
            class_1297 loaded = class_1299.method_17842((class_2487)copy, (class_1937)serverWorld, it -> it);
            if (loaded instanceof class_1309) {
                class_1309 living = (class_1309)loaded;
                type = new IdentityType<class_1309>(living);
                name = type.createTooltipText((class_1299)living);
            }
        }
        if (PlayerUnlocks.has((class_1657)player, type)) {
            PlayerUnlocks.revoke(player, type);
            if (IdentityConfig.getInstance().logCommands()) {
                player.method_7353((class_2561)class_2561.method_43469((String)"identity.revoke_entity", (Object[])new Object[]{name}), true);
                source.method_7353((class_2561)class_2561.method_43469((String)"identity.revoke_success", (Object[])new Object[]{name, player.method_5476()}), true);
            }
        } else if (IdentityConfig.getInstance().logCommands()) {
            source.method_7353((class_2561)class_2561.method_43469((String)"identity.does_not_have", (Object[])new Object[]{player.method_5476(), name}), true);
        }
    }

    private static void equip(class_3222 source, class_3222 player, class_2960 identity, @Nullable class_2487 nbt) {
        boolean result;
        class_1309 living;
        IdentityType<class_1309> defaultType;
        class_1297 created;
        if (nbt != null) {
            class_2487 copy = nbt.method_10553();
            copy.method_10582("id", identity.toString());
            class_3218 serverWorld = source.method_51469();
            created = class_1299.method_17842((class_2487)copy, (class_1937)serverWorld, it -> it);
        } else {
            class_1299 entity = (class_1299)class_7923.field_41177.method_10223(identity);
            created = entity.method_5883(player.method_37908());
        }
        if (created instanceof class_1309 && (defaultType = IdentityType.from(living = (class_1309)created)) != null && (result = PlayerIdentity.updateIdentity(player, defaultType, (class_1309)created)) && IdentityConfig.getInstance().logCommands()) {
            source.method_7353((class_2561)class_2561.method_43469((String)"identity.equip_success", (Object[])new Object[]{class_2561.method_43471((String)created.method_5864().method_5882()), player.method_5476()}), true);
        }
    }

    private static void unequip(class_3222 source, class_3222 player) {
        boolean result = PlayerIdentity.updateIdentity(player, null, null);
        if (result && IdentityConfig.getInstance().logCommands()) {
            source.method_7353((class_2561)class_2561.method_43469((String)"identity.unequip_success", (Object[])new Object[]{player.method_5476()}), false);
        }
    }

    static {
        BOOLEAN_SETTERS.put("overlay_identity_unlocks", value -> IdentityConfig.getInstance().setOverlayIdentityUnlocks((boolean)value));
        BOOLEAN_SETTERS.put("overlay_identity_revokes", value -> IdentityConfig.getInstance().setOverlayIdentityRevokes((boolean)value));
        BOOLEAN_SETTERS.put("revoke_identity_on_death", value -> IdentityConfig.getInstance().setRevokeIdentityOnDeath((boolean)value));
        BOOLEAN_SETTERS.put("identities_equip_items", value -> IdentityConfig.getInstance().setIdentitiesEquipItems((boolean)value));
        BOOLEAN_SETTERS.put("identities_equip_armor", value -> IdentityConfig.getInstance().setIdentitiesEquipArmor((boolean)value));
        BOOLEAN_SETTERS.put("show_player_nametag", value -> IdentityConfig.getInstance().setShowPlayerNametag((boolean)value));
        BOOLEAN_SETTERS.put("render_own_nametag", value -> IdentityConfig.getInstance().setRenderOwnNameTag((boolean)value));
        BOOLEAN_SETTERS.put("hostiles_ignore_hostile_identity_player", value -> IdentityConfig.getInstance().setHostilesIgnoreHostileIdentityPlayer((boolean)value));
        BOOLEAN_SETTERS.put("hostiles_forget_new_hostile_identity_player", value -> IdentityConfig.getInstance().setHostilesForgetNewHostileIdentityPlayer((boolean)value));
        BOOLEAN_SETTERS.put("wolves_attack_identity_prey", value -> IdentityConfig.getInstance().setWolvesAttackIdentityPrey((boolean)value));
        BOOLEAN_SETTERS.put("owned_wolves_attack_identity_prey", value -> IdentityConfig.getInstance().setOwnedWolvesAttackIdentityPrey((boolean)value));
        BOOLEAN_SETTERS.put("villagers_run_from_identities", value -> IdentityConfig.getInstance().setVillagersRunFromIdentities((boolean)value));
        BOOLEAN_SETTERS.put("foxes_attack_identity_prey", value -> IdentityConfig.getInstance().setFoxesAttackIdentityPrey((boolean)value));
        BOOLEAN_SETTERS.put("use_identity_sounds", value -> IdentityConfig.getInstance().setUseIdentitySounds((boolean)value));
        BOOLEAN_SETTERS.put("play_ambient_sounds", value -> IdentityConfig.getInstance().setPlayAmbientSounds((boolean)value));
        BOOLEAN_SETTERS.put("hear_self_ambient", value -> IdentityConfig.getInstance().setHearSelfAmbient((boolean)value));
        BOOLEAN_SETTERS.put("enable_flight", value -> IdentityConfig.getInstance().setEnableFlight((boolean)value));
        BOOLEAN_SETTERS.put("enable_client_swap_menu", value -> IdentityConfig.getInstance().setEnableClientSwapMenu((boolean)value));
        BOOLEAN_SETTERS.put("enable_swaps", value -> IdentityConfig.getInstance().setEnableSwaps((boolean)value));
        BOOLEAN_SETTERS.put("allow_self_trading", value -> IdentityConfig.getInstance().setAllowSelfTrading((boolean)value));
        BOOLEAN_SETTERS.put("force_change_new", value -> IdentityConfig.getInstance().setForceChangeNew((boolean)value));
        BOOLEAN_SETTERS.put("force_change_always", value -> IdentityConfig.getInstance().setForceChangeAlways((boolean)value));
        BOOLEAN_SETTERS.put("log_commands", value -> IdentityConfig.getInstance().setLogCommands((boolean)value));
        BOOLEAN_SETTERS.put("kill_for_identity", value -> IdentityConfig.getInstance().setKillForIdentity((boolean)value));
        BOOLEAN_SETTERS.put("scaling_health", value -> IdentityConfig.getInstance().setScalingHealth((boolean)value));
        BOOLEAN_SETTERS.put("warden_is_blinded", value -> IdentityConfig.getInstance().setWardenIsBlinded((boolean)value));
        BOOLEAN_SETTERS.put("warden_blinds_nearby", value -> IdentityConfig.getInstance().setWardenBlindsNearby((boolean)value));
        INT_SETTERS.put("hostility_time", value -> IdentityConfig.getInstance().setHostilityTime(value));
        INT_SETTERS.put("max_health", value -> IdentityConfig.getInstance().setMaxHealth(value));
        INT_SETTERS.put("enderman_ability_teleport_distance", value -> IdentityConfig.getInstance().setEndermanAbilityTeleportDistance(value));
        INT_SETTERS.put("required_kills_for_identity", value -> IdentityConfig.getInstance().setRequiredKillsForIdentity(value));
        FLOAT_SETTERS.put("fly_speed", value -> IdentityConfig.getInstance().setFlySpeed(value.floatValue()));
        STRING_OPTIONS.add("forced_identity");
    }
}

