/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.mixin;

import draylar.identity.Identity;
import draylar.identity.api.IdentityGranting;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.SafeTagManager;
import draylar.identity.api.variant.IdentityType;
import draylar.identity.compat.LivingEntityCompatAccessor;
import draylar.identity.impl.NearbySongAccessor;
import draylar.identity.registry.IdentityEntityTags;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1420;
import net.minecraft.class_1628;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements NearbySongAccessor {
    @Unique
    private boolean nearbySongPlaying = false;

    @Shadow
    protected abstract int method_6064(int var1);

    @Shadow
    public abstract boolean method_6059(class_6880<class_1291> var1);

    protected LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"onDeath"}, at={@At(value="RETURN")})
    private void onDeath(class_1282 source, CallbackInfo ci) {
        class_1297 attacker = source.method_5529();
        @Nullable IdentityType<class_1309> thisType = IdentityType.from((class_1309)this);
        if (attacker instanceof class_1657 && thisType != null) {
            IdentityGranting.grantByAttack((class_1657)attacker, thisType);
        }
    }

    @Inject(method={"getStepHeight"}, at={@At(value="RETURN")}, cancellable=true)
    public void modifyStepHeight(CallbackInfoReturnable<Float> cir) {
        class_1657 player;
        class_1309 identity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && (identity = PlayerIdentity.getIdentity(player = (class_1657)livingEntityMixin)) != null) {
            cir.setReturnValue((Object)Float.valueOf(identity.method_49476()));
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    private void identity$preventAirRegenForAquatic(CallbackInfo ci) {
        class_1657 player;
        class_1309 identity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && Identity.identity$isAquatic(identity = PlayerIdentity.getIdentity(player = (class_1657)livingEntityMixin)) && !player.method_5869()) {
            player.method_5855(Math.min(player.method_5669(), player.method_5748()));
        }
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;hasStatusEffect(Lnet/minecraft/registry/entry/RegistryEntry;)Z", ordinal=0))
    private boolean slowFall(class_1309 livingEntity, class_6880<class_1291> effect) {
        class_1299 type;
        class_1657 player;
        class_1309 identity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && (identity = PlayerIdentity.getIdentity(player = (class_1657)livingEntityMixin)) != null && !this.method_5715() && ((type = identity.method_5864()).method_20210(IdentityEntityTags.SLOW_FALLING) || SafeTagManager.isCustomSlowFalling(type))) {
            return true;
        }
        return this.method_6059((class_6880<class_1291>)class_1294.field_5906);
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    private void identity$suffocateAquaticIdentities(CallbackInfo ci) {
        class_1657 player;
        class_1309 identity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && Identity.identity$isAquatic(identity = PlayerIdentity.getIdentity(player = (class_1657)livingEntityMixin))) {
            boolean inWater = player.method_5799();
            boolean inBubbleColumn = player.method_37908().method_8320(player.method_24515()).method_27852(class_2246.field_10422);
            int air = player.method_5669();
            if (!inWater && !inBubbleColumn) {
                if (player.field_6012 % 40 == 0) {
                    if (air > 0) {
                        player.method_5855(Math.max(air - 15, 0));
                    } else {
                        player.method_5855(-1);
                        player.method_5643(player.method_48923().method_48824(), 2.0f);
                    }
                }
            } else if (air < player.method_5748()) {
                player.method_5855(player.method_5748());
            }
        }
    }

    @Redirect(method={"baseTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getNextAirOnLand(I)I"))
    private int identity$cancelAirRegenOnLand(class_1309 instance, int air) {
        class_1657 player;
        class_1309 identity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && Identity.identity$isAquatic(identity = PlayerIdentity.getIdentity(player = (class_1657)livingEntityMixin)) && !player.method_5799() && !player.method_37908().method_8320(player.method_24515()).method_27852(class_2246.field_10422)) {
            return air;
        }
        return ((LivingEntityCompatAccessor)instance).identity$getNextAirOnLand(air);
    }

    @Inject(method={"handleFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleFallDamage(float fallDistance, float damageMultiplier, class_1282 damageSource, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 identity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && (identity = PlayerIdentity.getIdentity(player = (class_1657)livingEntityMixin)) != null) {
            boolean takesFallDamage = identity.method_5747(fallDistance, damageMultiplier, damageSource);
            int damageAmount = ((LivingEntityCompatAccessor)identity).callComputeFallDamage(fallDistance, damageMultiplier);
            if (takesFallDamage && damageAmount > 0) {
                class_1309.class_6823 fallSounds = identity.method_39760();
                this.method_5783(damageAmount > 4 ? fallSounds.comp_302() : fallSounds.comp_301(), 1.0f, 1.0f);
                ((LivingEntityCompatAccessor)identity).callPlayBlockFallSound();
                this.method_5643(this.method_48923().method_48827(), damageAmount);
                cir.setReturnValue((Object)true);
            } else {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"hasStatusEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void returnHasNightVision(class_6880<class_1291> effect, CallbackInfoReturnable<Boolean> cir) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657) {
            class_1309 identity;
            class_1657 player = (class_1657)livingEntityMixin;
            if (effect.equals((Object)class_1294.field_5925) && (identity = PlayerIdentity.getIdentity(player)) instanceof class_1420) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"getStatusEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void returnNightVisionInstance(class_6880<class_1291> effect, CallbackInfoReturnable<class_1293> cir) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657) {
            class_1309 identity;
            class_1657 player = (class_1657)livingEntityMixin;
            if (effect.equals((Object)class_1294.field_5925) && (identity = PlayerIdentity.getIdentity(player)) instanceof class_1420) {
                cir.setReturnValue((Object)new class_1293(class_1294.field_5925, 100000, 0, false, false));
            }
        }
    }

    @Inject(method={"getBaseDimensions"}, at={@At(value="HEAD")}, cancellable=true)
    private void identity_getBaseDimensions(class_4050 pose, CallbackInfoReturnable<class_4048> cir) {
        class_1657 player;
        class_1309 identity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && (identity = PlayerIdentity.getIdentity(player = (class_1657)livingEntityMixin)) != null) {
            cir.setReturnValue((Object)identity.method_18377(pose));
        }
    }

    @Inject(method={"hurtByWater"}, at={@At(value="HEAD")}, cancellable=true)
    protected void identity_hurtByWater(CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 entity;
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657 && (entity = PlayerIdentity.getIdentity(player = (class_1657)class_13092)) != null) {
            cir.setReturnValue((Object)entity.method_29503());
        }
    }

    @Inject(method={"canBreatheInWater"}, at={@At(value="HEAD")}, cancellable=true)
    private void identity_canBreatheInWater(CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 identity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && (identity = PlayerIdentity.getIdentity(player = (class_1657)livingEntityMixin)) != null) {
            if (Identity.identity$isAquatic(identity)) {
                cir.setReturnValue((Object)true);
            } else if (identity.method_5864().method_20210(IdentityEntityTags.UNDROWNABLE) || SafeTagManager.isCustomUndrownable(identity.method_5864())) {
                cir.setReturnValue((Object)true);
            } else {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"setNearbySongPlaying"}, at={@At(value="RETURN")})
    @Environment(value=EnvType.CLIENT)
    protected void identity_setNearbySongPlaying(class_2338 songPosition, boolean playing, CallbackInfo ci) {
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            this.nearbySongPlaying = playing;
        }
    }

    @Override
    public boolean identity_isNearbySongPlaying() {
        return this.nearbySongPlaying;
    }

    @Inject(method={"canHaveStatusEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void identity_canHaveStatusEffect(class_1293 effect, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 identity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && (identity = PlayerIdentity.getIdentity(player = (class_1657)livingEntityMixin)) != null) {
            cir.setReturnValue((Object)identity.method_6049(effect));
        }
    }

    @Inject(method={"canWalkOnFluid"}, at={@At(value="HEAD")}, cancellable=true)
    protected void identity_canWalkOnFluid(class_3610 state, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 identity;
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657 && (identity = PlayerIdentity.getIdentity(player = (class_1657)class_13092)) != null && identity.method_5864().method_20210(IdentityEntityTags.LAVA_WALKING) && state.method_15767(class_3486.field_15518)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"isClimbing"}, at={@At(value="HEAD")}, cancellable=true)
    protected void identity_allowSpiderClimbing(CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 identity;
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657 && (identity = PlayerIdentity.getIdentity(player = (class_1657)class_13092)) instanceof class_1628) {
            cir.setReturnValue((Object)this.field_5976);
        }
    }
}

