/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.network;

import dev.architectury.networking.NetworkManager;
import draylar.identity.IdentityClient;
import draylar.identity.api.ApplicablePacket;
import draylar.identity.impl.DimensionsRefresher;
import draylar.identity.impl.PlayerDataProvider;
import draylar.identity.network.NetworkHandler;
import draylar.identity.network.client.VillagerProfessionClient;
import draylar.identity.network.impl.FavoritePackets;
import draylar.identity.network.impl.Payload;
import draylar.identity.network.impl.UnlockPackets;
import draylar.identity.network.impl.VillagerIdentitiesPackets;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2487;
import net.minecraft.class_5134;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class ClientNetworking
implements NetworkHandler {
    public static void registerPacketHandlers() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, Payload.IdentitySyncPayload.ID, Payload.IdentitySyncPayload.CODEC, ClientNetworking::handleIdentitySyncPacket);
        UnlockPackets.registerClientHandler();
        FavoritePackets.registerFavoriteSyncHandler();
        VillagerIdentitiesPackets.registerClientHandler();
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, Payload.AbilitySyncPayload.ID, Payload.AbilitySyncPayload.CODEC, ClientNetworking::handleAbilitySyncPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, Payload.ConfigSyncPayload.ID, Payload.ConfigSyncPayload.CODEC, ClientNetworking::handleConfigurationSyncPacket);
        VillagerProfessionClient.registerClientHandler();
    }

    public static void runOrQueue(NetworkManager.PacketContext context, ApplicablePacket packet) {
        if (context.getPlayer() == null) {
            IdentityClient.getSyncPacketQueue().add(packet);
        } else {
            context.queue(() -> packet.apply(context.getPlayer()));
        }
    }

    public static void sendAbilityRequest() {
        NetworkManager.sendToServer((class_8710)new Payload.UseAbilityPayload());
    }

    public static void handleIdentitySyncPacket(Payload.IdentitySyncPayload packet, NetworkManager.PacketContext context) {
        UUID uuid = packet.uuid();
        String id = packet.id();
        class_2487 entityNbt = packet.entityNbt();
        ClientNetworking.runOrQueue(context, player -> {
            @Nullable class_1657 syncTarget = player.method_5770().method_18470(uuid);
            if (syncTarget != null) {
                PlayerDataProvider data = (PlayerDataProvider)syncTarget;
                if (id.equals("minecraft:empty")) {
                    data.setIdentity(null);
                    ((DimensionsRefresher)syncTarget).identity_refreshDimensions();
                    return;
                }
                if (entityNbt != null) {
                    entityNbt.method_10582("id", id);
                    Optional type = class_1299.method_17684((class_2487)entityNbt);
                    if (type.isPresent()) {
                        class_1309 identity = data.getIdentity();
                        if (identity == null || !((class_1299)type.get()).equals(identity.method_5864())) {
                            identity = (class_1309)((class_1299)type.get()).method_5883(syncTarget.method_37908());
                            data.setIdentity(identity);
                            ((DimensionsRefresher)syncTarget).identity_refreshDimensions();
                            syncTarget.method_5996(class_5134.field_47761).method_6192(identity.method_45325(class_5134.field_47761));
                            syncTarget.method_18799(syncTarget.method_18798().method_18805(1.0, 0.0, 1.0));
                            syncTarget.field_6017 = 0.0f;
                            syncTarget.field_6014 = syncTarget.method_23317();
                            syncTarget.field_6036 = syncTarget.method_23318();
                            syncTarget.field_5969 = syncTarget.method_23321();
                            syncTarget.field_6007 = true;
                            ClientNetworking.ensureSafePosition(syncTarget);
                            syncTarget.method_18382();
                        }
                        if (identity != null) {
                            identity.method_5651(entityNbt);
                        }
                    }
                }
            }
        });
    }

    private static void ensureSafePosition(class_1657 player) {
        if (player.method_5757()) {
            double safeY = player.method_23318();
            for (int i = 1; i <= 2; ++i) {
                if (player.method_37908().method_8320(player.method_24515().method_10086(i)).method_26212((class_1922)player.method_37908(), player.method_24515().method_10086(i))) continue;
                safeY = player.method_23318() + (double)i;
                break;
            }
            player.method_5814(player.method_23317(), safeY, player.method_23321());
        }
    }

    public static void handleAbilitySyncPacket(Payload.AbilitySyncPayload payload, NetworkManager.PacketContext context) {
        int cooldown = payload.cooldown();
        ClientNetworking.runOrQueue(context, player -> ((PlayerDataProvider)player).setAbilityCooldown(cooldown));
    }

    public static void handleConfigurationSyncPacket(Payload.ConfigSyncPayload payload, NetworkManager.PacketContext context) {
        boolean enableClientSwapMenu = payload.enableClientSwapMenu();
        boolean showPlayerNametag = payload.showPlayerNametag();
    }

    private ClientNetworking() {
    }
}

