/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import draylar.identity.ability.AbilityRegistry;
import draylar.identity.api.PlayerAbilities;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.network.NetworkHandler;
import draylar.identity.network.impl.FavoritePackets;
import draylar.identity.network.impl.Payload;
import draylar.identity.network.impl.SwapPackets;
import draylar.identity.network.impl.VillagerProfessionPackets;
import draylar.identity.network.impl.VillagerTradePackets;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public class ServerNetworking
implements NetworkHandler {
    private static boolean s2cPayloadsRegistered = false;

    public static void initialize() {
        ServerNetworking.registerS2CPayloadTypes();
        FavoritePackets.registerFavoriteRequestHandler();
        SwapPackets.registerIdentityRequestPacketHandler();
        VillagerProfessionPackets.registerServerHandler();
        VillagerTradePackets.registerTradeRequestHandler();
    }

    private static void registerS2CPayloadTypes() {
        if (s2cPayloadsRegistered || Platform.getEnv().equals((Object)EnvType.CLIENT)) {
            return;
        }
        NetworkManager.registerS2CPayloadType(Payload.IdentitySyncPayload.ID, Payload.IdentitySyncPayload.CODEC);
        NetworkManager.registerS2CPayloadType(Payload.AbilitySyncPayload.ID, Payload.AbilitySyncPayload.CODEC);
        NetworkManager.registerS2CPayloadType(Payload.FavoriteSyncPayload.ID, Payload.FavoriteSyncPayload.CODEC);
        NetworkManager.registerS2CPayloadType(Payload.UnlockSyncPayload.ID, Payload.UnlockSyncPayload.CODEC);
        NetworkManager.registerS2CPayloadType(Payload.VillagerIdentitiesSyncPayload.ID, Payload.VillagerIdentitiesSyncPayload.CODEC);
        NetworkManager.registerS2CPayloadType(Payload.OpenProfessionScreenPayload.ID, Payload.OpenProfessionScreenPayload.CODEC);
        NetworkManager.registerS2CPayloadType(Payload.ConfigSyncPayload.ID, Payload.ConfigSyncPayload.CODEC);
        s2cPayloadsRegistered = true;
    }

    public static void registerUseAbilityPacketHandler() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, Payload.UseAbilityPayload.ID, Payload.UseAbilityPayload.CODEC, (payload, context) -> {
            class_1657 player = context.getPlayer();
            context.queue(() -> {
                class_1299 identityType;
                class_1309 identity = PlayerIdentity.getIdentity(player);
                if (identity != null && AbilityRegistry.has(identityType = identity.method_5864()) && PlayerAbilities.canUseAbility(player)) {
                    AbilityRegistry.get(identityType).onUse(player, identity, player.method_37908());
                    PlayerAbilities.setCooldown(player, AbilityRegistry.get(identityType).getCooldown(identity));
                    PlayerAbilities.sync((class_3222)player);
                }
            });
        });
    }
}

