/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.screen.widget;

import draylar.identity.Identity;
import draylar.identity.api.variant.IdentityType;
import draylar.identity.network.impl.FavoritePackets;
import draylar.identity.network.impl.SwapPackets;
import draylar.identity.screen.IdentityScreen;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_490;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class EntityWidget<T extends class_1309>
extends class_4264 {
    public static int VERTICAL_OFFSET = 30;
    private static int BASE_Y_OFFSET = 10;
    private IdentityType<T> type;
    private T entity;
    private int size;
    private boolean active;
    private boolean starred;
    private IdentityScreen parent;

    public EntityWidget(int x, int y, int width, int height, IdentityType<T> type, T entity, IdentityScreen parent, boolean starred, boolean current) {
        super(x, y, width, height, class_2561.method_30163((String)""));
        this.type = type;
        this.entity = entity;
        this.parent = parent;
        this.starred = starred;
        this.active = current;
        float baseSizeFactor = 25.0f / Math.max(entity.method_17681(), entity.method_17682());
        double scaleFactor = parent.getScaleFactor();
        int guiScale = parent.getGuiScale();
        double finalScale = scaleFactor / (double)(guiScale == 0 ? 1 : guiScale);
        this.size = Math.max(1, (int)((double)baseSizeFactor * finalScale));
        entity.method_5834(true);
        this.method_47400(class_7919.method_47407((class_2561)entity.method_5476()));
    }

    protected void method_47399(class_6382 builder) {
    }

    public boolean method_25402(double mx, double my, int button) {
        boolean hit;
        boolean bl = hit = mx >= (double)this.method_46426() && mx < (double)(this.method_46426() + this.method_25368()) && my >= (double)this.method_46427() && my < (double)(this.method_46427() + this.method_25364());
        if (hit) {
            if (button == 0) {
                SwapPackets.sendSwapRequest(this.type);
                this.parent.disableAll();
                this.active = true;
            } else if (button == 1) {
                this.starred = !this.starred;
                FavoritePackets.sendFavoriteRequest(this.type, this.starred);
            }
        }
        return super.method_25402(mx, my, button);
    }

    public class_2561 getHoverName() {
        return this.entity.method_5476();
    }

    protected void method_48579(class_332 ctx, int mouseX, int mouseY, float delta) {
        int rawGui = this.parent.getGuiScale();
        int clampedGui = rawGui == 0 ? 3 : Math.min(rawGui, 5);
        float baseSizePerBlock = 25.0f / Math.max(this.entity.method_17681(), this.entity.method_17682());
        double windowScale = this.parent.getScaleFactor();
        double effectiveScale = windowScale / (double)clampedGui;
        int scale = Math.max(1, (int)((double)baseSizePerBlock * effectiveScale));
        int pixelHeight = (int)(this.entity.method_17682() * (float)scale);
        int slotCX = this.method_46426() + this.method_25368() / 2;
        int slotCY = this.method_46427() + this.method_25364() / 2;
        int bottomY = slotCY + pixelHeight / 2;
        float relMouseX = mouseX - slotCX;
        float relMouseY = mouseY - bottomY;
        try {
            EntityWidget.drawEntityCompat(ctx, slotCX, bottomY, scale, relMouseX, relMouseY, this.entity);
        }
        catch (Exception e) {
            Identity.LOGGER.warn("Failed to render " + this.type.getEntityType().method_5882(), (Throwable)e);
        }
        if (this.starred) {
            ctx.method_25290(Identity.id("textures/gui/star.png"), this.method_46426(), this.method_46427(), 0.0f, 0.0f, 15, 15, 15, 15);
        }
        if (this.active) {
            ctx.method_25293(Identity.id("textures/gui/selected.png"), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), 0.0f, 0.0f, 48, 32, 48, 32);
        }
    }

    public static void drawEntityCompat(class_332 context, int slotCX, int bottomY, int scale, float relMouseX, float relMouseY, class_1309 entity) {
        float f = (float)Math.atan(-relMouseX / 40.0f);
        float g = (float)Math.atan(-relMouseY / 40.0f);
        Quaternionf q1 = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf q2 = new Quaternionf().rotateX(g * 20.0f * ((float)Math.PI / 180));
        q1.mul((Quaternionfc)q2);
        float prevBodyYaw = entity.field_6283;
        float prevYaw = entity.method_36454();
        float prevPitch = entity.method_36455();
        float prevHeadYaw = entity.field_6259;
        float prevHeadYaw2 = entity.field_6241;
        entity.field_6283 = 180.0f + f * 20.0f;
        entity.method_36456(180.0f + f * 40.0f);
        entity.method_36457(-g * 20.0f);
        entity.field_6241 = entity.method_36454();
        entity.field_6259 = entity.method_36454();
        float p = entity.method_55693();
        Vector3f anchor = new Vector3f(0.0f, entity.method_17682() / 2.0f, 0.0f);
        float normalizedScale = (float)scale / p;
        class_490.method_48472((class_332)context, (float)slotCX, (float)bottomY, (float)normalizedScale, (Vector3f)anchor, (Quaternionf)q1, (Quaternionf)q2, (class_1309)entity);
        entity.field_6283 = prevBodyYaw;
        entity.method_36456(prevYaw);
        entity.method_36457(prevPitch);
        entity.field_6259 = prevHeadYaw;
        entity.field_6241 = prevHeadYaw2;
    }

    private int getSize() {
        int cell = Math.max(1, Math.min(this.method_25368(), this.method_25364()));
        float unit = Math.max(0.6f, Math.max(this.entity.method_17681(), this.entity.method_17682()));
        float target = (float)cell * 0.7f;
        int size = Math.max(8, Math.round(target / unit));
        return size;
    }

    public void method_25306() {
    }

    public void setActive(boolean a) {
        this.active = a;
    }

    public void dispose() {
        if (this.entity != null) {
            try {
                this.entity.method_31472();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.entity = null;
        }
        this.type = null;
        this.parent = null;
    }
}

