/*
 * Decompiled with CFR 0.152.
 */
package org.plugin.bantools;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import java.util.Arrays;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.plugin.bantools.BanManager;
import org.plugin.bantools.ConfigManager;

public class BanToolsCommand
implements SimpleCommand {
    private final BanManager banManager;
    private final ConfigManager configManager;

    public BanToolsCommand(BanManager banManager, ConfigManager configManager) {
        this.banManager = banManager;
        this.configManager = configManager;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        String[] args = (String[])invocation.arguments();
        CommandSource source = invocation.source();
        if (args.length < 1) {
            this.sendHelpMessage(source);
            return;
        }
        switch (args[0].toLowerCase()) {
            case "ban": {
                this.handleBanCommand(args, source);
                break;
            }
            case "kick": {
                this.handleKickCommand(args, source);
                break;
            }
            case "reload": {
                this.banManager.loadBans();
                source.sendMessage((Component)Component.text((String)"\u914d\u7f6e\u5df2\u91cd\u65b0\u52a0\u8f7d", (TextColor)NamedTextColor.GREEN));
                break;
            }
            default: {
                this.sendHelpMessage(source);
            }
        }
    }

    private void handleBanCommand(String[] args, CommandSource source) {
        if (args.length < 2) {
            this.sendBanUsage(source);
            return;
        }
        String target = args[1];
        String reason = this.configManager.getDefaultBanReason();
        String duration = null;
        if (args.length >= 3) {
            reason = args[2];
        }
        if (args.length >= 4) {
            duration = args[3];
        }
        this.banManager.banPlayer(target, reason, duration);
        source.sendMessage((Component)Component.text((String)("\u6210\u529f\u5c01\u7981\u73a9\u5bb6: " + target), (TextColor)NamedTextColor.GREEN));
    }

    private void handleKickCommand(String[] args, CommandSource source) {
        if (args.length < 2) {
            this.sendKickUsage(source);
            return;
        }
        String target = args[1];
        String reason = this.configManager.getDefaultKickReason();
        if (args.length >= 3) {
            reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
        }
        this.banManager.kickPlayer(target, reason);
        source.sendMessage((Component)Component.text((String)("\u5df2\u8e22\u51fa\u73a9\u5bb6: " + target), (TextColor)NamedTextColor.GREEN));
    }

    private void sendHelpMessage(CommandSource source) {
        source.sendMessage((Component)Component.text((String)"BanTools \u4f7f\u7528\u8bf4\u660e", (TextColor)NamedTextColor.YELLOW));
        this.sendBanUsage(source);
        this.sendKickUsage(source);
        source.sendMessage((Component)Component.text((String)"/bt reload - \u91cd\u65b0\u52a0\u8f7d\u914d\u7f6e", (TextColor)NamedTextColor.GOLD));
    }

    private void sendBanUsage(CommandSource source) {
        source.sendMessage((Component)Component.text((String)"\u5c01\u7981\u7528\u6cd5: /bt ban <\u73a9\u5bb6> [\u539f\u56e0] [\u65f6\u957f]", (TextColor)NamedTextColor.RED));
    }

    private void sendKickUsage(CommandSource source) {
        source.sendMessage((Component)Component.text((String)"\u8e22\u51fa\u7528\u6cd5: /bt kick <\u73a9\u5bb6> [\u539f\u56e0]", (TextColor)NamedTextColor.RED));
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        String[] args = (String[])invocation.arguments();
        if (args.length < 1) {
            return invocation.source().hasPermission("bantools.command.ban") || invocation.source().hasPermission("bantools.command.kick") || invocation.source().hasPermission("bantools.command.reload");
        }
        switch (args[0].toLowerCase()) {
            case "ban": {
                return invocation.source().hasPermission("bantools.command.ban");
            }
            case "kick": {
                return invocation.source().hasPermission("bantools.command.kick");
            }
            case "reload": {
                return invocation.source().hasPermission("bantools.command.reload");
            }
        }
        return false;
    }
}

