/*
 * Decompiled with CFR 0.152.
 */
package org.plugin.bantools;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import org.plugin.bantools.BanEntry;
import org.plugin.bantools.ConfigManager;
import org.slf4j.Logger;

public class BanManager {
    private final ProxyServer server;
    private final Logger logger;
    private final ConfigManager configManager;
    private final Map<String, BanEntry> banEntries = new HashMap<String, BanEntry>();

    public BanManager(ProxyServer server, Logger logger, ConfigManager configManager) {
        this.server = server;
        this.logger = logger;
        this.configManager = configManager;
        this.loadBans();
    }

    public void loadBans() {
        this.banEntries.clear();
        this.configManager.getBans().forEach((key, entry) -> {
            if (entry.getState() && !this.isExpired((BanEntry)entry)) {
                this.banEntries.put((String)key, (BanEntry)entry);
            }
        });
        this.logger.info("\u52a0\u8f7d\u4e86 " + this.banEntries.size() + " \u4e2a\u6709\u6548\u5c01\u7981\u8bb0\u5f55");
    }

    public boolean isBanned(String uuid, String ip, String username) {
        return this.banEntries.values().stream().filter(entry -> !this.isExpired((BanEntry)entry)).anyMatch(entry -> entry.getUuid().equals(uuid) || entry.getIp().equals(ip) || entry.getName().equalsIgnoreCase(username));
    }

    public String getBanMessage(String uuid, String ip, String username) {
        BanEntry entry = this.findBanEntry(uuid, ip, username);
        if (entry == null) {
            return "";
        }
        String reason = entry.getReason();
        if (entry.isPermanent()) {
            return "\u00a7c\u4f60\u5df2\u88ab\u6c38\u4e45\u5c01\u7981\uff01\n\u539f\u56e0\uff1a" + reason;
        }
        return String.format("\u00a7c\u4f60\u5df2\u88ab\u5c01\u7981\u81f3 %s\n\u539f\u56e0\uff1a%s", entry.getEndTimeFormatted(), reason);
    }

    public void banPlayer(String target, String reason, String duration) {
        Player player = this.server.getPlayer(target).orElse(null);
        BanEntry entry = new BanEntry();
        entry.setName(target);
        entry.setUuid(player != null ? player.getUniqueId().toString() : "unknown");
        entry.setIp(player != null ? player.getRemoteAddress().getAddress().getHostAddress() : "unknown");
        entry.setReason(reason.isEmpty() ? this.configManager.getDefaultBanReason() : reason);
        if (duration == null || duration.isEmpty() || duration.equalsIgnoreCase("permanent")) {
            entry.setEndTime(null);
        } else {
            entry.setStartTime(System.currentTimeMillis());
            entry.setEndTime(this.parseDuration(duration));
        }
        this.configManager.addBan(entry);
        this.loadBans();
        this.kickPlayer(target, entry.getReason());
    }

    private long parseDuration(String duration) {
        if (duration.endsWith("d")) {
            return System.currentTimeMillis() + TimeUnit.DAYS.toMillis(Integer.parseInt(duration.replace("d", "")));
        }
        if (duration.contains("-")) {
            String[] dates = duration.split("-");
            return this.parseAbsoluteDate(dates[1]);
        }
        return System.currentTimeMillis();
    }

    private long parseAbsoluteDate(String dateStr) {
        return Instant.from(DateTimeFormatter.ofPattern("yyyy/MM/dd").parse(dateStr)).toEpochMilli();
    }

    public void unbanPlayer(String target) {
        this.configManager.setBanState(target, false);
        this.loadBans();
    }

    public void kickPlayer(String target, String reason) {
        this.server.getAllPlayers().stream().filter(p -> p.getUsername().equalsIgnoreCase(target)).forEach(p -> p.disconnect((Component)Component.text((String)("\u00a7c" + reason))));
    }

    private BanEntry findBanEntry(String uuid, String ip, String username) {
        return this.banEntries.values().stream().filter(entry -> !this.isExpired((BanEntry)entry)).filter(entry -> entry.getUuid().equals(uuid) || entry.getIp().equals(ip) || entry.getName().equalsIgnoreCase(username)).findFirst().orElse(null);
    }

    private boolean isExpired(BanEntry entry) {
        return !entry.isPermanent() && entry.getEndTime() < System.currentTimeMillis();
    }
}

