/*
 * Decompiled with CFR 0.152.
 */
package org.plugin.bantools;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.proxy.ProxyServer;
import org.plugin.bantools.BanManager;
import org.plugin.bantools.BanToolsCommand;
import org.plugin.bantools.ConfigManager;
import org.plugin.bantools.LoginListener;
import org.plugin.bantools.UnbanCommand;
import org.slf4j.Logger;

@Plugin(id="bantools", name="BanTools", version="1.2", description="Advanced banning system for Velocity")
public class BanToolsPlugin {
    @Inject
    private ProxyServer server;
    @Inject
    private Logger logger;
    private BanManager banManager;
    private ConfigManager configManager;

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.configManager = new ConfigManager();
        this.banManager = new BanManager(this.server, this.logger, this.configManager);
        this.server.getEventManager().register((Object)this, (Object)new LoginListener(this.banManager));
        this.registerCommands();
        this.logger.info("===================================");
        this.logger.info("BanTools v1.2 \u5df2\u52a0\u8f7d");
        this.logger.info("\u4f5c\u8005\uff1aNSrank & Qwen2.5-Max");
        this.logger.info("===================================");
    }

    private void registerCommands() {
        CommandManager commandManager = this.server.getCommandManager();
        CommandMeta meta = commandManager.metaBuilder("bantools").aliases(new String[]{"bt"}).build();
        commandManager.register(meta, (Command)new BanToolsCommand(this.banManager, this.configManager));
        CommandMeta unbanMeta = commandManager.metaBuilder("unban").build();
        commandManager.register(unbanMeta, (Command)new UnbanCommand(this.banManager));
    }
}

