/*
 * Decompiled with CFR 0.152.
 */
package org.plugin.bantools;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import org.plugin.bantools.BanEntry;

public class ConfigManager {
    private Config config;
    private final File configFile;
    private final Map<String, BanEntry> bans = new HashMap<String, BanEntry>();

    public ConfigManager() {
        this.configFile = new File("plugins/BanTools/config.conf");
        this.loadConfig();
    }

    public void loadConfig() {
        if (!this.configFile.exists()) {
            this.createDefaultConfig();
        }
        this.config = ConfigFactory.parseFile((File)this.configFile);
        this.loadBans();
    }

    private void createDefaultConfig() {
        this.configFile.getParentFile().mkdirs();
        String defaultConfig = "defaults {\n  ban_reason = \"\u8fdd\u53cd\u670d\u52a1\u5668\u89c4\u5219\"\n  kick_reason = \"\u7ba1\u7406\u5458\u5f3a\u5236\u8e22\u51fa\"\n}\n\nbans = {}";
        try {
            Files.write(this.configFile.toPath(), defaultConfig.getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<String, BanEntry> getBans() {
        return new HashMap<String, BanEntry>(this.bans);
    }

    public String getDefaultBanReason() {
        return this.config.getString("defaults.ban_reason");
    }

    public String getDefaultKickReason() {
        return this.config.getString("defaults.kick_reason");
    }

    public void addBan(BanEntry entry) {
        Config updatedConfig = this.config.withValue("bans." + entry.getName(), (ConfigValue)ConfigValueFactory.fromMap(this.entryToMap(entry)));
        this.saveConfig(updatedConfig);
    }

    public void setBanState(String target, boolean state) {
        Config updatedConfig = this.config.withValue("bans." + target + ".state", ConfigValueFactory.fromAnyRef((Object)state));
        this.saveConfig(updatedConfig);
    }

    private Map<String, Object> entryToMap(BanEntry entry) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", entry.getName());
        map.put("uuid", entry.getUuid());
        map.put("ip", entry.getIp());
        map.put("reason", entry.getReason());
        map.put("start_time", entry.getStartTime());
        map.put("end_time", entry.getEndTime());
        map.put("state", entry.getState());
        return map;
    }

    private void saveConfig(Config updatedConfig) {
        try {
            Files.write(this.configFile.toPath(), updatedConfig.root().render().getBytes(), new OpenOption[0]);
            this.config = updatedConfig;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadBans() {
        this.bans.clear();
        if (!this.config.hasPath("bans") || !this.config.getObject("bans").isEmpty()) {
            return;
        }
        Config bansConfig = this.config.getConfig("bans");
        for (Map.Entry entry : bansConfig.entrySet()) {
            String playerName = (String)entry.getKey();
            ConfigValue value = (ConfigValue)entry.getValue();
            if (!(value instanceof ConfigObject)) {
                System.err.println("Invalid data type for player '" + playerName + "'. Skipping...");
                continue;
            }
            Config playerConfig = ((ConfigObject)value).toConfig();
            BanEntry banEntry = new BanEntry();
            banEntry.setName(playerName);
            banEntry.setUuid(playerConfig.getString("uuid"));
            banEntry.setIp(playerConfig.getString("ip"));
            banEntry.setReason(playerConfig.getString("reason"));
            banEntry.setStartTime(playerConfig.getLong("start_time"));
            if (playerConfig.hasPath("end_time") && !playerConfig.getIsNull("end_time")) {
                banEntry.setEndTime(playerConfig.getLong("end_time"));
            } else {
                banEntry.setEndTime(null);
            }
            banEntry.setState(playerConfig.getBoolean("state"));
            this.bans.put(playerName, banEntry);
        }
    }
}

