/*
 * Decompiled with CFR 0.152.
 */
package org.plugin.bantools;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.plugin.bantools.BanEntry;
import org.plugin.bantools.ConfigManager;
import org.plugin.bantools.FakeBanEntry;
import org.plugin.bantools.FakeBanManager;
import org.plugin.bantools.WhitelistManager;
import org.slf4j.Logger;

public class BanManager {
    private final ProxyServer server;
    private final Logger logger;
    private final ConfigManager configManager;
    private final WhitelistManager whitelistManager;
    private FakeBanManager fakeBanManager;
    private final Map<String, BanEntry> banEntries = new HashMap<String, BanEntry>();

    public BanManager(ProxyServer server, Logger logger, ConfigManager configManager, WhitelistManager whitelistManager) {
        this.server = server;
        this.logger = logger;
        this.configManager = configManager;
        this.whitelistManager = whitelistManager;
        this.loadBans();
    }

    public void setFakeBanManager(FakeBanManager fakeBanManager) {
        this.fakeBanManager = fakeBanManager;
    }

    public List<String> getBannedPlayers() {
        return this.banEntries.values().stream().filter(entry -> entry.getState() && !this.isExpired((BanEntry)entry)).map(BanEntry::getName).collect(Collectors.toList());
    }

    public boolean isWhitelisted(String playerName) {
        return this.whitelistManager.isWhitelisted(playerName);
    }

    public void loadBans() {
        this.banEntries.clear();
        Map<String, BanEntry> allBans = this.configManager.getBans();
        allBans.forEach((key, entry) -> {
            if (entry.getState() && !this.isExpired((BanEntry)entry)) {
                this.banEntries.put((String)key, (BanEntry)entry);
            }
        });
        this.logger.info("\u52a0\u8f7d\u4e86 " + this.banEntries.size() + " \u4e2a\u6709\u6548\u5c01\u7981\u8bb0\u5f55");
    }

    public boolean isBanned(String uuid, String ip, String username) {
        boolean normalBan = this.banEntries.values().stream().filter(entry -> !this.isExpired((BanEntry)entry)).anyMatch(entry -> {
            if (entry.getName().equalsIgnoreCase(username)) {
                if (!(entry.getUuid() != null && entry.getIp() != null || uuid == null || uuid.isEmpty() || ip == null || ip.isEmpty())) {
                    this.updateBanEntryInfo((BanEntry)entry, uuid, ip);
                }
                return true;
            }
            return entry.getUuid() != null && entry.getUuid().equals(uuid) || entry.getIp() != null && entry.getIp().equals(ip);
        });
        boolean fakeBan = this.fakeBanManager != null && this.fakeBanManager.isFakeBanned(uuid, ip, username);
        return normalBan || fakeBan;
    }

    private void updateBanEntryInfo(BanEntry entry, String uuid, String ip) {
        try {
            entry.setUuid(uuid);
            entry.setIp(ip);
            this.configManager.updateBanEntry(entry);
            this.logger.info("\u66f4\u65b0\u4e86\u73a9\u5bb6 " + entry.getName() + " \u7684\u5c01\u7981\u4fe1\u606f");
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u5c01\u7981\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public String getBanMessage(String uuid, String ip, String username) {
        FakeBanEntry fakeBanEntry;
        BanEntry entry = this.findBanEntry(uuid, ip, username);
        if (entry != null) {
            String reason = entry.getReason();
            if (entry.isPermanent()) {
                return "\u00a7c\u4f60\u5df2\u88ab\u6c38\u4e45\u5c01\u7981\uff01\n\u539f\u56e0\uff1a" + reason;
            }
            return String.format("\u00a7c\u4f60\u5df2\u88ab\u5c01\u7981\u81f3 %s\n\u539f\u56e0\uff1a%s", entry.getEndTimeFormatted(), reason);
        }
        if (this.fakeBanManager != null && (fakeBanEntry = this.fakeBanManager.getFakeBanInfo(uuid, ip, username)) != null) {
            return String.format("\u00a7c\u4f60\u5df2\u88ab\u4e34\u65f6\u5c01\u7981\uff01\n\u539f\u56e0\uff1a%s\n\u5269\u4f59\u65f6\u95f4\uff1a%s", fakeBanEntry.getReason(), fakeBanEntry.getRemainingTimeFormatted());
        }
        return "";
    }

    public String banPlayer(String target, String reason, String duration) {
        if (target == null || target.trim().isEmpty()) {
            this.logger.warn("\u5c1d\u8bd5\u5c01\u7981\u7a7a\u7684\u73a9\u5bb6\u540d");
            return "\u73a9\u5bb6\u540d\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (target.length() > 16 || !target.matches("^[a-zA-Z0-9_]{1,16}$")) {
            this.logger.warn("\u65e0\u6548\u7684\u73a9\u5bb6\u540d\u683c\u5f0f: " + target);
            return "\u65e0\u6548\u7684\u73a9\u5bb6\u540d\u683c\u5f0f";
        }
        String protectionCheck = this.whitelistManager.checkProtection(target);
        if (protectionCheck != null) {
            this.logger.warn("\u5c1d\u8bd5\u5c01\u7981\u53d7\u4fdd\u62a4\u7684\u73a9\u5bb6: " + target);
            return protectionCheck;
        }
        BanEntry existingBan = this.findExistingBan(target);
        if (existingBan != null) {
            String banInfo = this.formatExistingBanInfo(existingBan);
            this.logger.info("\u5c1d\u8bd5\u91cd\u590d\u5c01\u7981\u73a9\u5bb6: " + target + "\uff0c\u5df2\u5b58\u5728\u5c01\u7981\u8bb0\u5f55");
            return "\u8be5\u73a9\u5bb6\u5df2\u88ab\u5c01\u7981\uff01" + banInfo;
        }
        Player player = this.server.getPlayer(target).orElse(null);
        BanEntry entry = new BanEntry();
        entry.setName(target);
        if (player != null) {
            entry.setUuid(player.getUniqueId().toString());
            entry.setIp(player.getRemoteAddress().getAddress().getHostAddress());
        } else {
            entry.setUuid(null);
            entry.setIp(null);
            this.logger.info("\u5c01\u7981\u79bb\u7ebf\u73a9\u5bb6: " + target + "\uff0cUUID\u548cIP\u5c06\u5728\u73a9\u5bb6\u4e0b\u6b21\u767b\u5f55\u65f6\u66f4\u65b0");
        }
        entry.setReason(reason == null || reason.trim().isEmpty() ? this.configManager.getDefaultBanReason() : reason.trim());
        entry.setStartTime(System.currentTimeMillis());
        entry.setState(true);
        if (duration == null || duration.isEmpty() || duration.equalsIgnoreCase("permanent")) {
            entry.setEndTime(null);
        } else {
            entry.setEndTime(this.parseDuration(duration));
        }
        this.configManager.addBan(entry);
        this.loadBans();
        this.kickPlayer(target, entry.getReason());
        return null;
    }

    private long parseDuration(String duration) {
        try {
            if (duration.endsWith("d")) {
                String dayStr = duration.replace("d", "");
                int days = Integer.parseInt(dayStr);
                if (days <= 0 || days > 3650) {
                    this.logger.warn("\u65e0\u6548\u7684\u5c01\u7981\u5929\u6570: " + days);
                    return System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L);
                }
                return System.currentTimeMillis() + TimeUnit.DAYS.toMillis(days);
            }
            if (duration.contains("-")) {
                String[] dates = duration.split("-");
                if (dates.length != 2) {
                    this.logger.warn("\u65e0\u6548\u7684\u65e5\u671f\u8303\u56f4\u683c\u5f0f: " + duration);
                    return System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L);
                }
                return this.parseAbsoluteDate(dates[1]);
            }
        }
        catch (NumberFormatException e) {
            this.logger.warn("\u89e3\u6790\u5c01\u7981\u65f6\u957f\u5931\u8d25: " + duration, (Throwable)e);
        }
        return System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L);
    }

    private long parseAbsoluteDate(String dateStr) {
        try {
            return Instant.from(DateTimeFormatter.ofPattern("yyyy/MM/dd").parse(dateStr)).toEpochMilli();
        }
        catch (Exception e) {
            this.logger.warn("\u89e3\u6790\u65e5\u671f\u5931\u8d25: " + dateStr, (Throwable)e);
            return System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L);
        }
    }

    public String unbanPlayer(String target) {
        if (target == null || target.trim().isEmpty()) {
            this.logger.warn("\u5c1d\u8bd5\u89e3\u5c01\u7a7a\u7684\u73a9\u5bb6\u540d");
            return "\u73a9\u5bb6\u540d\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (target.length() > 16 || !target.matches("^[a-zA-Z0-9_]{1,16}$")) {
            this.logger.warn("\u65e0\u6548\u7684\u73a9\u5bb6\u540d\u683c\u5f0f: " + target);
            return "\u65e0\u6548\u7684\u73a9\u5bb6\u540d\u683c\u5f0f";
        }
        BanEntry existingBan = this.findExistingBan(target);
        if (existingBan == null) {
            BanEntry inactiveBan = this.findInactiveBan(target);
            if (inactiveBan != null) {
                this.logger.info("\u5c1d\u8bd5\u91cd\u590d\u89e3\u5c01\u73a9\u5bb6: " + target + "\uff0c\u8be5\u73a9\u5bb6\u5df2\u5904\u4e8e\u89e3\u5c01\u72b6\u6001");
                return "\u8be5\u73a9\u5bb6\u672a\u88ab\u5c01\u7981\u6216\u5df2\u88ab\u89e3\u5c01\uff01";
            }
            this.logger.info("\u5c1d\u8bd5\u89e3\u5c01\u4e0d\u5b58\u5728\u7684\u73a9\u5bb6: " + target);
            return "\u8be5\u73a9\u5bb6\u6ca1\u6709\u5c01\u7981\u8bb0\u5f55\uff01";
        }
        this.configManager.setBanState(target, false);
        this.loadBans();
        this.logger.info("\u6210\u529f\u89e3\u5c01\u73a9\u5bb6: " + target);
        return null;
    }

    public String kickPlayer(String target, String reason) {
        if (target == null || target.trim().isEmpty()) {
            this.logger.warn("\u5c1d\u8bd5\u8e22\u51fa\u7a7a\u7684\u73a9\u5bb6\u540d");
            return "\u73a9\u5bb6\u540d\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (target.length() > 16 || !target.matches("^[a-zA-Z0-9_]{1,16}$")) {
            this.logger.warn("\u65e0\u6548\u7684\u73a9\u5bb6\u540d\u683c\u5f0f: " + target);
            return "\u65e0\u6548\u7684\u73a9\u5bb6\u540d\u683c\u5f0f";
        }
        String protectionCheck = this.whitelistManager.checkProtection(target);
        if (protectionCheck != null) {
            this.logger.warn("\u5c1d\u8bd5\u8e22\u51fa\u53d7\u4fdd\u62a4\u7684\u73a9\u5bb6: " + target);
            return protectionCheck;
        }
        this.server.getAllPlayers().stream().filter(p -> p.getUsername().equalsIgnoreCase(target)).forEach(p -> p.disconnect((Component)Component.text((String)("\u00a7c" + reason))));
        this.logger.info("\u5df2\u8e22\u51fa\u73a9\u5bb6: " + target + "\uff0c\u539f\u56e0: " + reason);
        return null;
    }

    private BanEntry findBanEntry(String uuid, String ip, String username) {
        return this.banEntries.values().stream().filter(entry -> !this.isExpired((BanEntry)entry)).filter(entry -> entry.getUuid().equals(uuid) || entry.getIp().equals(ip) || entry.getName().equalsIgnoreCase(username)).findFirst().orElse(null);
    }

    private boolean isExpired(BanEntry entry) {
        return !entry.isPermanent() && entry.getEndTime() < System.currentTimeMillis();
    }

    private BanEntry findExistingBan(String target) {
        for (BanEntry entry : this.banEntries.values()) {
            if (!entry.getName().equalsIgnoreCase(target) || this.isExpired(entry)) continue;
            return entry;
        }
        Map<String, BanEntry> allBans = this.configManager.getBans();
        for (BanEntry entry : allBans.values()) {
            if (!entry.getName().equalsIgnoreCase(target) || !entry.getState() || this.isExpired(entry)) continue;
            return entry;
        }
        return null;
    }

    private BanEntry findInactiveBan(String target) {
        Map<String, BanEntry> allBans = this.configManager.getBans();
        for (BanEntry entry : allBans.values()) {
            if (!entry.getName().equalsIgnoreCase(target) || entry.getState()) continue;
            return entry;
        }
        return null;
    }

    private String formatExistingBanInfo(BanEntry banEntry) {
        StringBuilder info = new StringBuilder();
        info.append("\u7406\u7531\uff1a").append(banEntry.getReason());
        if (banEntry.isPermanent()) {
            info.append("\uff0c\u65f6\u957f\uff1a\u6c38\u4e45\u5c01\u7981");
        } else {
            info.append("\uff0c\u65f6\u957f\uff1a\u81f3 ").append(banEntry.getEndTimeFormatted());
        }
        return info.toString();
    }
}

