/*
 * Decompiled with CFR 0.152.
 */
package org.plugin.bantools;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.plugin.bantools.BanManager;
import org.plugin.bantools.ConfigManager;
import org.plugin.bantools.FakeBanManager;

public class BanToolsCommand
implements SimpleCommand {
    private final BanManager banManager;
    private final ConfigManager configManager;
    private final FakeBanManager fakeBanManager;
    private final ProxyServer server;

    public BanToolsCommand(BanManager banManager, ConfigManager configManager, FakeBanManager fakeBanManager, ProxyServer server) {
        this.banManager = banManager;
        this.configManager = configManager;
        this.fakeBanManager = fakeBanManager;
        this.server = server;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        String[] args = (String[])invocation.arguments();
        CommandSource source = invocation.source();
        if (args.length < 1) {
            this.sendHelpMessage(source);
            return;
        }
        switch (args[0].toLowerCase()) {
            case "ban": {
                this.handleBanCommand(args, source);
                break;
            }
            case "unban": {
                this.handleUnbanCommand(args, source);
                break;
            }
            case "fakeban": {
                this.handleFakeBanCommand(args, source);
                break;
            }
            case "unfakeban": {
                this.handleUnFakeBanCommand(args, source);
                break;
            }
            case "kick": {
                this.handleKickCommand(args, source);
                break;
            }
            case "reload": {
                this.banManager.loadBans();
                source.sendMessage((Component)Component.text((String)"\u914d\u7f6e\u5df2\u91cd\u65b0\u52a0\u8f7d", (TextColor)NamedTextColor.GREEN));
                break;
            }
            default: {
                this.sendHelpMessage(source);
            }
        }
    }

    private void handleBanCommand(String[] args, CommandSource source) {
        String result;
        if (args.length < 2) {
            this.sendBanUsage(source);
            return;
        }
        String target = args[1];
        String reason = this.configManager.getDefaultBanReason();
        String duration = null;
        if (args.length >= 3) {
            reason = args[2];
        }
        if (args.length >= 4) {
            duration = args[3];
        }
        if ((result = this.banManager.banPlayer(target, reason, duration)) != null) {
            source.sendMessage((Component)Component.text((String)result, (TextColor)NamedTextColor.RED));
        } else {
            source.sendMessage((Component)Component.text((String)("\u6210\u529f\u5c01\u7981\u73a9\u5bb6: " + target), (TextColor)NamedTextColor.GREEN));
        }
    }

    private void handleUnbanCommand(String[] args, CommandSource source) {
        if (args.length != 2) {
            this.sendUnbanUsage(source);
            return;
        }
        String target = args[1].trim();
        if (target.isEmpty()) {
            source.sendMessage((Component)Component.text((String)"\u73a9\u5bb6\u540d\u4e0d\u80fd\u4e3a\u7a7a", (TextColor)NamedTextColor.RED));
            return;
        }
        if (target.length() > 16 || !target.matches("^[a-zA-Z0-9_]{1,16}$")) {
            source.sendMessage((Component)Component.text((String)"\u65e0\u6548\u7684\u73a9\u5bb6\u540d\u683c\u5f0f", (TextColor)NamedTextColor.RED));
            return;
        }
        String result = this.banManager.unbanPlayer(target);
        if (result != null) {
            source.sendMessage((Component)Component.text((String)result, (TextColor)NamedTextColor.RED));
        } else {
            source.sendMessage((Component)Component.text((String)("\u5df2\u89e3\u5c01\u73a9\u5bb6: " + target), (TextColor)NamedTextColor.GREEN));
        }
    }

    private void handleFakeBanCommand(String[] args, CommandSource source) {
        String adminName;
        String result;
        if (args.length < 2) {
            this.sendFakeBanUsage(source);
            return;
        }
        String target = args[1].trim();
        String reason = null;
        if (args.length >= 3) {
            reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
        }
        if ((result = this.fakeBanManager.confirmFakeBan(adminName = source instanceof Player ? ((Player)source).getUsername() : "Console", target, reason)) != null) {
            source.sendMessage((Component)Component.text((String)result, (TextColor)NamedTextColor.YELLOW));
        }
    }

    private void handleUnFakeBanCommand(String[] args, CommandSource source) {
        if (args.length != 2) {
            this.sendUnFakeBanUsage(source);
            return;
        }
        String target = args[1].trim();
        String result = this.fakeBanManager.unFakeBan(target);
        if (result != null) {
            if (result.startsWith("\u6210\u529f")) {
                source.sendMessage((Component)Component.text((String)result, (TextColor)NamedTextColor.GREEN));
            } else {
                source.sendMessage((Component)Component.text((String)result, (TextColor)NamedTextColor.RED));
            }
        }
    }

    private void handleKickCommand(String[] args, CommandSource source) {
        String result;
        if (args.length < 2) {
            this.sendKickUsage(source);
            return;
        }
        String target = args[1];
        String reason = this.configManager.getDefaultKickReason();
        if (args.length >= 3) {
            reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
        }
        if ((result = this.banManager.kickPlayer(target, reason)) != null) {
            source.sendMessage((Component)Component.text((String)result, (TextColor)NamedTextColor.RED));
        } else {
            source.sendMessage((Component)Component.text((String)("\u5df2\u8e22\u51fa\u73a9\u5bb6: " + target), (TextColor)NamedTextColor.GREEN));
        }
    }

    private void sendHelpMessage(CommandSource source) {
        source.sendMessage((Component)Component.text((String)"BanTools \u4f7f\u7528\u8bf4\u660e", (TextColor)NamedTextColor.YELLOW));
        this.sendBanUsage(source);
        this.sendUnbanUsage(source);
        this.sendFakeBanUsage(source);
        this.sendUnFakeBanUsage(source);
        this.sendKickUsage(source);
        source.sendMessage((Component)Component.text((String)"/bt reload - \u91cd\u65b0\u52a0\u8f7d\u914d\u7f6e", (TextColor)NamedTextColor.GOLD));
    }

    private void sendBanUsage(CommandSource source) {
        source.sendMessage((Component)Component.text((String)"\u5c01\u7981\u7528\u6cd5: /bt ban <\u73a9\u5bb6> [\u539f\u56e0] [\u65f6\u957f]", (TextColor)NamedTextColor.RED));
    }

    private void sendUnbanUsage(CommandSource source) {
        source.sendMessage((Component)Component.text((String)"\u89e3\u5c01\u7528\u6cd5: /bt unban <\u73a9\u5bb6>", (TextColor)NamedTextColor.RED));
    }

    private void sendFakeBanUsage(CommandSource source) {
        source.sendMessage((Component)Component.text((String)"\u4e34\u65f6\u5c01\u7981\u7528\u6cd5: /bt fakeban <\u73a9\u5bb6> [\u539f\u56e0]", (TextColor)NamedTextColor.RED));
    }

    private void sendUnFakeBanUsage(CommandSource source) {
        source.sendMessage((Component)Component.text((String)"\u89e3\u9664\u4e34\u65f6\u5c01\u7981\u7528\u6cd5: /bt unfakeban <\u73a9\u5bb6>", (TextColor)NamedTextColor.RED));
    }

    private void sendKickUsage(CommandSource source) {
        source.sendMessage((Component)Component.text((String)"\u8e22\u51fa\u7528\u6cd5: /bt kick <\u73a9\u5bb6> [\u539f\u56e0]", (TextColor)NamedTextColor.RED));
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        String[] args = (String[])invocation.arguments();
        if (args.length < 1) {
            return invocation.source().hasPermission("bantools.command.ban") || invocation.source().hasPermission("bantools.command.kick") || invocation.source().hasPermission("bantools.command.reload");
        }
        switch (args[0].toLowerCase()) {
            case "ban": {
                return invocation.source().hasPermission("bantools.command.ban");
            }
            case "unban": {
                return invocation.source().hasPermission("bantools.command.unban");
            }
            case "fakeban": {
                return invocation.source().hasPermission("bantools.command.fakeban");
            }
            case "unfakeban": {
                return invocation.source().hasPermission("bantools.command.unfakeban");
            }
            case "kick": {
                return invocation.source().hasPermission("bantools.command.kick");
            }
            case "reload": {
                return invocation.source().hasPermission("bantools.command.reload");
            }
        }
        return false;
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        String subCommand;
        String[] args = (String[])invocation.arguments();
        CommandSource source = invocation.source();
        if (args.length <= 1) {
            String input;
            ArrayList<String> suggestions = new ArrayList<String>();
            String string = input = args.length == 0 ? "" : args[0].toLowerCase();
            if (source.hasPermission("bantools.command.ban") && "ban".startsWith(input)) {
                suggestions.add("ban");
            }
            if (source.hasPermission("bantools.command.unban") && "unban".startsWith(input)) {
                suggestions.add("unban");
            }
            if (source.hasPermission("bantools.command.fakeban") && "fakeban".startsWith(input)) {
                suggestions.add("fakeban");
            }
            if (source.hasPermission("bantools.command.unfakeban") && "unfakeban".startsWith(input)) {
                suggestions.add("unfakeban");
            }
            if (source.hasPermission("bantools.command.kick") && "kick".startsWith(input)) {
                suggestions.add("kick");
            }
            if (source.hasPermission("bantools.command.reload") && "reload".startsWith(input)) {
                suggestions.add("reload");
            }
            return suggestions;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "ban": 
            case "fakeban": 
            case "kick": {
                return this.suggestPlayersForBan(args);
            }
            case "unban": {
                return this.suggestPlayersForUnban(args);
            }
            case "unfakeban": {
                return this.suggestPlayersForUnfakeban(args);
            }
        }
        return Collections.emptyList();
    }

    private List<String> suggestPlayersForBan(String[] args) {
        if (args.length == 2) {
            String input = args[1].toLowerCase();
            return this.server.getAllPlayers().stream().map(Player::getUsername).filter(name -> name.toLowerCase().startsWith(input)).filter(name -> !this.banManager.isWhitelisted((String)name)).collect(Collectors.toList());
        }
        if (args.length == 3) {
            return Arrays.asList("\u8fdd\u53cd\u670d\u52a1\u5668\u89c4\u5219", "\u4f5c\u5f0a\u884c\u4e3a", "\u6076\u610f\u7834\u574f", "\u6302\u673a\u884c\u4e3a", "\u4e0d\u5f53\u8a00\u8bba");
        }
        if (args.length == 4 && "ban".equals(args[0].toLowerCase())) {
            return Arrays.asList("1h", "6h", "1d", "3d", "7d", "30d", "\u6c38\u4e45");
        }
        return Collections.emptyList();
    }

    private List<String> suggestPlayersForUnban(String[] args) {
        if (args.length == 2) {
            String input = args[1].toLowerCase();
            return this.banManager.getBannedPlayers().stream().filter(name -> name.toLowerCase().startsWith(input)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<String> suggestPlayersForUnfakeban(String[] args) {
        if (args.length == 2) {
            String input = args[1].toLowerCase();
            return this.fakeBanManager.getFakeBannedPlayers().stream().filter(name -> name.toLowerCase().startsWith(input)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

