/*
 * Decompiled with CFR 0.152.
 */
package org.plugin.bantools;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Path;
import org.plugin.bantools.BanManager;
import org.plugin.bantools.BanToolsCommand;
import org.plugin.bantools.ConfigManager;
import org.plugin.bantools.FakeBanManager;
import org.plugin.bantools.LoginListener;
import org.plugin.bantools.WhitelistManager;
import org.slf4j.Logger;

@Plugin(id="bantools", name="BanTools", version="1.4.0", description="Advanced banning system for Velocity")
public class BanToolsPlugin {
    @Inject
    private ProxyServer server;
    @Inject
    private Logger logger;
    @Inject
    @DataDirectory
    private Path dataDirectory;
    private ConfigManager configManager;
    private WhitelistManager whitelistManager;
    private BanManager banManager;
    private FakeBanManager fakeBanManager;

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.configManager = new ConfigManager();
        this.whitelistManager = new WhitelistManager(this.configManager, this.logger);
        this.banManager = new BanManager(this.server, this.logger, this.configManager, this.whitelistManager);
        this.fakeBanManager = new FakeBanManager(this.configManager, this.whitelistManager, this.server, this.logger);
        this.banManager.setFakeBanManager(this.fakeBanManager);
        this.server.getEventManager().register((Object)this, (Object)new LoginListener(this.banManager));
        this.registerCommands();
        this.logger.info("===================================");
        this.logger.info("BanTools v1.4.0 \u5df2\u52a0\u8f7d");
        this.logger.info("\u4f5c\u8005\uff1aNSrank & Qwen2.5-Max & Augment");
        this.logger.info("===================================");
    }

    private void registerCommands() {
        CommandManager commandManager = this.server.getCommandManager();
        CommandMeta meta = commandManager.metaBuilder("bantools").aliases(new String[]{"bt"}).build();
        commandManager.register(meta, (Command)new BanToolsCommand(this.banManager, this.configManager, this.fakeBanManager, this.server));
    }
}

