/*
 * Decompiled with CFR 0.152.
 */
package org.plugin.bantools;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import com.typesafe.config.ConfigValueType;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.plugin.bantools.BanEntry;
import org.plugin.bantools.FakeBanEntry;

public class ConfigManager {
    private Config config;
    private final File configFile;
    private final Map<String, BanEntry> bans = new HashMap<String, BanEntry>();
    private final Map<String, FakeBanEntry> fakeBans = new HashMap<String, FakeBanEntry>();

    public ConfigManager() {
        this.configFile = new File("plugins/BanTools/config.conf");
        this.loadConfig();
    }

    public void loadConfig() {
        if (!this.configFile.exists()) {
            this.createDefaultConfig();
        }
        try {
            this.config = ConfigFactory.parseFile((File)this.configFile);
            this.loadBans();
            this.loadFakeBans();
        }
        catch (Exception e) {
            System.err.println("\u914d\u7f6e\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff0c\u5c1d\u8bd5\u4fee\u590d...");
            e.printStackTrace();
            this.backupAndRecreateConfig();
        }
    }

    private void createDefaultConfig() {
        this.configFile.getParentFile().mkdirs();
        String defaultConfig = "defaults {\n  ban_reason = \"\u8fdd\u53cd\u670d\u52a1\u5668\u89c4\u5219\"\n  kick_reason = \"\u7ba1\u7406\u5458\u5f3a\u5236\u8e22\u51fa\"\n  fakeban_reason = \"\u6682\u65f6\u8e22\u51fa\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\"\n}\n\nfakeban {\n  duration_minutes = 30\n  confirmation_message = \"\u6b64\u64cd\u4f5c\u5c06\u4f1a\u6682\u65f6\u8e22\u51fa\u73a9\u5bb6\u76f4\u5230\u4e09\u5341\u5206\u949f\u540e\u624d\u53ef\u4ee5\u91cd\u65b0\u52a0\u5165\uff0c\u5efa\u8bae\u68c0\u67e5\u6302\u673a\u73a9\u5bb6\u5468\u906d\u60c5\u51b5\uff0c\u786e\u8ba4\u6267\u884c\u8bf7\u518d\u6b21\u8f93\u5165\u6307\u4ee4\"\n  confirmation_timeout_minutes = 3\n}\n\nwhitelist {\n  enabled = true\n  players = [\"Admin\", \"Owner\"]\n  protection_message = \"\u8be5\u73a9\u5bb6\u53d7\u5230\u767d\u540d\u5355\u4fdd\u62a4\uff0c\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c\uff01\"\n}\n\nbans = {}\nfakebans = {}";
        try {
            Files.write(this.configFile.toPath(), defaultConfig.getBytes("UTF-8"), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void backupAndRecreateConfig() {
        try {
            File backupFile = new File(this.configFile.getParent(), "config.conf.backup." + System.currentTimeMillis());
            if (this.configFile.exists()) {
                Files.copy(this.configFile.toPath(), backupFile.toPath(), new CopyOption[0]);
                System.out.println("\u5df2\u5907\u4efd\u635f\u574f\u7684\u914d\u7f6e\u6587\u4ef6\u5230: " + backupFile.getName());
            }
            this.createDefaultConfig();
            this.config = ConfigFactory.parseFile((File)this.configFile);
            this.loadBans();
        }
        catch (Exception e) {
            System.err.println("\u4fee\u590d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public Map<String, BanEntry> getBans() {
        return new HashMap<String, BanEntry>(this.bans);
    }

    public Map<String, FakeBanEntry> getFakeBans() {
        return new HashMap<String, FakeBanEntry>(this.fakeBans);
    }

    public String getDefaultBanReason() {
        return this.config.getString("defaults.ban_reason");
    }

    public String getDefaultKickReason() {
        return this.config.getString("defaults.kick_reason");
    }

    public String getDefaultFakeBanReason() {
        return this.config.getString("defaults.fakeban_reason");
    }

    public int getFakeBanDurationMinutes() {
        return this.config.getInt("fakeban.duration_minutes");
    }

    public String getFakeBanConfirmationMessage() {
        return this.config.getString("fakeban.confirmation_message");
    }

    public int getFakeBanConfirmationTimeoutMinutes() {
        return this.config.getInt("fakeban.confirmation_timeout_minutes");
    }

    public boolean isWhitelistEnabled() {
        return this.config.getBoolean("whitelist.enabled");
    }

    public List<String> getWhitelistPlayers() {
        return this.config.getStringList("whitelist.players");
    }

    public String getWhitelistProtectionMessage() {
        return this.config.getString("whitelist.protection_message");
    }

    public void addBan(BanEntry entry) {
        Config updatedConfig = this.config.withValue("bans." + entry.getName(), (ConfigValue)ConfigValueFactory.fromMap(this.entryToMap(entry)));
        this.saveConfig(updatedConfig);
        this.loadBans();
    }

    public void setBanState(String target, boolean state) {
        Config updatedConfig = this.config.withValue("bans." + target + ".state", ConfigValueFactory.fromAnyRef((Object)state));
        this.saveConfig(updatedConfig);
        this.loadBans();
    }

    public void updateBanEntry(BanEntry entry) {
        Config updatedConfig = this.config.withValue("bans." + entry.getName(), (ConfigValue)ConfigValueFactory.fromMap(this.entryToMap(entry)));
        this.saveConfig(updatedConfig);
        this.loadBans();
    }

    private Map<String, Object> entryToMap(BanEntry entry) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", entry.getName());
        map.put("uuid", entry.getUuid());
        map.put("ip", entry.getIp());
        map.put("reason", entry.getReason());
        map.put("start_time", entry.getStartTime());
        map.put("end_time", entry.getEndTime());
        map.put("state", entry.getState());
        return map;
    }

    private void saveConfig(Config updatedConfig) {
        try {
            ConfigRenderOptions options = ConfigRenderOptions.defaults().setOriginComments(false).setComments(false).setFormatted(true);
            String configContent = updatedConfig.root().render(options);
            Files.write(this.configFile.toPath(), configContent.getBytes("UTF-8"), new OpenOption[0]);
            this.config = updatedConfig;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadBans() {
        this.bans.clear();
        if (!this.config.hasPath("bans")) {
            return;
        }
        try {
            if (this.detectFlattenedConfig()) {
                System.out.println("\u68c0\u6d4b\u5230\u6241\u5e73\u5316\u7684\u914d\u7f6e\u6587\u4ef6\uff0c\u5c1d\u8bd5\u4fee\u590d...");
                this.fixFlattenedConfig();
                return;
            }
            ConfigObject bansObject = this.config.getObject("bans");
            if (bansObject.isEmpty()) {
                return;
            }
            for (Map.Entry entry : bansObject.entrySet()) {
                String playerName = (String)entry.getKey();
                ConfigValue value = (ConfigValue)entry.getValue();
                if (!(value instanceof ConfigObject)) {
                    System.err.println("Invalid data type for player '" + playerName + "'. Expected ConfigObject, got " + value.getClass().getSimpleName() + ". Skipping...");
                    continue;
                }
                try {
                    ConfigObject playerObject = (ConfigObject)value;
                    BanEntry banEntry = new BanEntry();
                    banEntry.setName(playerName);
                    ConfigValue uuidValue = playerObject.get((Object)"uuid");
                    if (uuidValue != null && uuidValue.valueType() == ConfigValueType.STRING) {
                        banEntry.setUuid((String)uuidValue.unwrapped());
                    } else {
                        banEntry.setUuid(null);
                    }
                    ConfigValue ipValue = playerObject.get((Object)"ip");
                    if (ipValue != null && ipValue.valueType() == ConfigValueType.STRING) {
                        banEntry.setIp((String)ipValue.unwrapped());
                    } else {
                        banEntry.setIp(null);
                    }
                    ConfigValue reasonValue = playerObject.get((Object)"reason");
                    if (reasonValue == null || reasonValue.valueType() != ConfigValueType.STRING) {
                        System.err.println("Missing or invalid reason for player '" + playerName + "'. Skipping...");
                        continue;
                    }
                    banEntry.setReason((String)reasonValue.unwrapped());
                    ConfigValue startTimeValue = playerObject.get((Object)"start_time");
                    if (startTimeValue == null || startTimeValue.valueType() != ConfigValueType.NUMBER) {
                        System.err.println("Missing or invalid start_time for player '" + playerName + "'. Skipping...");
                        continue;
                    }
                    banEntry.setStartTime(((Number)startTimeValue.unwrapped()).longValue());
                    ConfigValue stateValue = playerObject.get((Object)"state");
                    if (stateValue == null || stateValue.valueType() != ConfigValueType.BOOLEAN) {
                        System.err.println("Missing or invalid state for player '" + playerName + "'. Skipping...");
                        continue;
                    }
                    banEntry.setState((Boolean)stateValue.unwrapped());
                    ConfigValue endTimeValue = playerObject.get((Object)"end_time");
                    if (endTimeValue != null && endTimeValue.valueType() == ConfigValueType.NUMBER) {
                        banEntry.setEndTime(((Number)endTimeValue.unwrapped()).longValue());
                    } else {
                        banEntry.setEndTime(null);
                    }
                    this.bans.put(playerName, banEntry);
                }
                catch (Exception e) {
                    System.err.println("Error loading ban data for player '" + playerName + "': " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error loading bans configuration: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private boolean detectFlattenedConfig() {
        for (String key : this.config.root().keySet()) {
            if (!key.contains(".") || !key.endsWith(".name") && !key.endsWith(".uuid") && !key.endsWith(".ip") && !key.endsWith(".reason") && !key.endsWith(".start_time") && !key.endsWith(".end_time") && !key.endsWith(".state")) continue;
            return true;
        }
        return false;
    }

    private void fixFlattenedConfig() {
        try {
            HashMap<String, Map> playerData = new HashMap<String, Map>();
            for (Map.Entry entry : this.config.root().entrySet()) {
                String[] parts;
                String key = (String)entry.getKey();
                if (!key.contains(".") || (parts = key.split("\\.", 2)).length != 2) continue;
                String playerName = parts[0];
                String fieldName = parts[1];
                playerData.computeIfAbsent(playerName, k -> new HashMap()).put(fieldName, ((ConfigValue)entry.getValue()).unwrapped());
            }
            HashMap<String, Map<String, Object>> newConfig = new HashMap<String, Map<String, Object>>();
            newConfig.put("defaults", Map.of("ban_reason", "\u8fdd\u53cd\u670d\u52a1\u5668\u89c4\u5219", "kick_reason", "\u7ba1\u7406\u5458\u5f3a\u5236\u8e22\u51fa"));
            newConfig.put("bans", playerData);
            Config fixedConfig = ConfigFactory.parseMap(newConfig);
            this.saveConfig(fixedConfig);
            this.config = fixedConfig;
            this.loadBans();
            System.out.println("\u914d\u7f6e\u6587\u4ef6\u4fee\u590d\u5b8c\u6210\uff0c\u91cd\u65b0\u52a0\u8f7d\u4e86 " + playerData.size() + " \u4e2a\u73a9\u5bb6\u7684\u5c01\u7981\u8bb0\u5f55");
        }
        catch (Exception e) {
            System.err.println("\u4fee\u590d\u6241\u5e73\u5316\u914d\u7f6e\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void loadFakeBans() {
        this.fakeBans.clear();
        try {
            if (!this.config.hasPath("fakebans")) {
                return;
            }
            ConfigObject fakeBansObject = this.config.getObject("fakebans");
            for (Map.Entry entry : fakeBansObject.entrySet()) {
                String playerName = (String)entry.getKey();
                try {
                    ConfigValue stateValue;
                    ConfigValue endTimeValue;
                    ConfigValue startTimeValue;
                    ConfigValue reasonValue;
                    ConfigValue ipValue;
                    ConfigObject playerObject = (ConfigObject)entry.getValue();
                    FakeBanEntry fakeBanEntry = new FakeBanEntry();
                    fakeBanEntry.setName(playerName);
                    ConfigValue uuidValue = playerObject.get((Object)"uuid");
                    if (uuidValue != null && uuidValue.valueType() != ConfigValueType.NULL) {
                        fakeBanEntry.setUuid((String)uuidValue.unwrapped());
                    }
                    if ((ipValue = playerObject.get((Object)"ip")) != null && ipValue.valueType() != ConfigValueType.NULL) {
                        fakeBanEntry.setIp((String)ipValue.unwrapped());
                    }
                    if ((reasonValue = playerObject.get((Object)"reason")) != null && reasonValue.valueType() == ConfigValueType.STRING) {
                        fakeBanEntry.setReason((String)reasonValue.unwrapped());
                    }
                    if ((startTimeValue = playerObject.get((Object)"start_time")) != null && startTimeValue.valueType() == ConfigValueType.NUMBER) {
                        fakeBanEntry.setStartTime(((Number)startTimeValue.unwrapped()).longValue());
                    }
                    if ((endTimeValue = playerObject.get((Object)"end_time")) != null && endTimeValue.valueType() == ConfigValueType.NUMBER) {
                        fakeBanEntry.setEndTime(((Number)endTimeValue.unwrapped()).longValue());
                    }
                    if ((stateValue = playerObject.get((Object)"state")) != null && stateValue.valueType() == ConfigValueType.BOOLEAN) {
                        fakeBanEntry.setState((Boolean)stateValue.unwrapped());
                    }
                    if (!fakeBanEntry.getState() || fakeBanEntry.isExpired()) continue;
                    this.fakeBans.put(playerName, fakeBanEntry);
                }
                catch (Exception e) {
                    System.err.println("Error loading fakeban data for player '" + playerName + "': " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error loading fakebans configuration: " + e.getMessage());
        }
    }

    public void addFakeBan(FakeBanEntry entry) {
        Config updatedConfig = this.config.withValue("fakebans." + entry.getName(), (ConfigValue)ConfigValueFactory.fromMap(this.fakeBanEntryToMap(entry)));
        this.saveConfig(updatedConfig);
        this.loadFakeBans();
    }

    public void setFakeBanState(String playerName, boolean state) {
        if (this.config.hasPath("fakebans." + playerName)) {
            Config updatedConfig = this.config.withValue("fakebans." + playerName + ".state", ConfigValueFactory.fromAnyRef((Object)state));
            this.saveConfig(updatedConfig);
            this.loadFakeBans();
        }
    }

    private Map<String, Object> fakeBanEntryToMap(FakeBanEntry entry) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", entry.getName());
        map.put("uuid", entry.getUuid());
        map.put("ip", entry.getIp());
        map.put("reason", entry.getReason());
        map.put("start_time", entry.getStartTime());
        map.put("end_time", entry.getEndTime());
        map.put("state", entry.getState());
        return map;
    }

    public void cleanupExpiredFakeBans() {
        boolean hasChanges = false;
        Config updatedConfig = this.config;
        for (Map.Entry<String, FakeBanEntry> entry : new HashMap<String, FakeBanEntry>(this.fakeBans).entrySet()) {
            if (!entry.getValue().isExpired()) continue;
            updatedConfig = updatedConfig.withValue("fakebans." + entry.getKey() + ".state", ConfigValueFactory.fromAnyRef((Object)false));
            hasChanges = true;
        }
        if (hasChanges) {
            this.saveConfig(updatedConfig);
            this.loadFakeBans();
        }
    }
}

