/*
 * Decompiled with CFR 0.152.
 */
package org.plugin.bantools;

import java.time.Instant;
import java.time.format.DateTimeFormatter;

public class FakeBanEntry {
    private String name;
    private String uuid;
    private String ip;
    private String reason;
    private long startTime = System.currentTimeMillis();
    private long endTime;
    private boolean state = true;

    public FakeBanEntry() {
    }

    public FakeBanEntry(String name, String reason, long duration) {
        this();
        this.name = name;
        this.reason = reason;
        this.endTime = this.startTime + duration;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public boolean getState() {
        return this.state;
    }

    public void setState(boolean state) {
        this.state = state;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.endTime;
    }

    public long getRemainingMinutes() {
        long remaining = this.endTime - System.currentTimeMillis();
        return Math.max(0L, remaining / 60000L);
    }

    public String getEndTimeFormatted() {
        return DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm").format(Instant.ofEpochMilli(this.endTime));
    }

    public String getRemainingTimeFormatted() {
        long remaining = this.endTime - System.currentTimeMillis();
        if (remaining <= 0L) {
            return "\u5df2\u8fc7\u671f";
        }
        long minutes = remaining / 60000L;
        long hours = minutes / 60L;
        minutes %= 60L;
        if (hours > 0L) {
            return String.format("%d\u5c0f\u65f6%d\u5206\u949f", hours, minutes);
        }
        return String.format("%d\u5206\u949f", minutes);
    }
}

