/*
 * Decompiled with CFR 0.152.
 */
package org.plugin.bantools;

import com.velocitypowered.api.proxy.ProxyServer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.plugin.bantools.ConfigManager;
import org.plugin.bantools.FakeBanEntry;
import org.plugin.bantools.WhitelistManager;
import org.slf4j.Logger;

public class FakeBanManager {
    private final ConfigManager configManager;
    private final WhitelistManager whitelistManager;
    private final ProxyServer server;
    private final Logger logger;
    private final ScheduledExecutorService scheduler;
    private final Map<String, PendingFakeBan> pendingFakeBans = new ConcurrentHashMap<String, PendingFakeBan>();
    private final Map<String, FakeBanEntry> activeFakeBans = new ConcurrentHashMap<String, FakeBanEntry>();

    public FakeBanManager(ConfigManager configManager, WhitelistManager whitelistManager, ProxyServer server, Logger logger) {
        this.configManager = configManager;
        this.whitelistManager = whitelistManager;
        this.server = server;
        this.logger = logger;
        this.scheduler = Executors.newScheduledThreadPool(2);
        this.loadActiveFakeBans();
        this.startCleanupTask();
    }

    public String initiateFakeBan(String adminName, String targetPlayer, String reason) {
        if (targetPlayer == null || targetPlayer.trim().isEmpty()) {
            return "\u73a9\u5bb6\u540d\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (targetPlayer.length() > 16 || !targetPlayer.matches("^[a-zA-Z0-9_]{1,16}$")) {
            return "\u65e0\u6548\u7684\u73a9\u5bb6\u540d\u683c\u5f0f";
        }
        String protectionCheck = this.whitelistManager.checkProtection(targetPlayer);
        if (protectionCheck != null) {
            return protectionCheck;
        }
        FakeBanEntry existingFakeBan = this.findActiveFakeBan(targetPlayer);
        if (existingFakeBan != null) {
            return "\u8be5\u73a9\u5bb6\u5df2\u88ab\u4e34\u65f6\u5c01\u7981\uff01\u5269\u4f59\u65f6\u95f4\uff1a" + existingFakeBan.getRemainingTimeFormatted();
        }
        String pendingKey = adminName + ":" + targetPlayer;
        long timeoutMinutes = this.configManager.getFakeBanConfirmationTimeoutMinutes();
        long expireTime = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(timeoutMinutes);
        String finalReason = reason == null || reason.trim().isEmpty() ? this.configManager.getDefaultFakeBanReason() : reason.trim();
        this.pendingFakeBans.put(pendingKey, new PendingFakeBan(adminName, targetPlayer, finalReason, expireTime));
        this.scheduler.schedule(() -> {
            this.pendingFakeBans.remove(pendingKey);
            this.logger.info("\u7ba1\u7406\u5458 " + adminName + " \u7684fakeban\u786e\u8ba4\u5df2\u8d85\u65f6\uff1a" + targetPlayer);
        }, timeoutMinutes, TimeUnit.MINUTES);
        return this.configManager.getFakeBanConfirmationMessage();
    }

    public String confirmFakeBan(String adminName, String targetPlayer, String reason) {
        String pendingKey = adminName + ":" + targetPlayer;
        PendingFakeBan pending = this.pendingFakeBans.get(pendingKey);
        if (pending == null) {
            return this.initiateFakeBan(adminName, targetPlayer, reason);
        }
        if (pending.isExpired()) {
            this.pendingFakeBans.remove(pendingKey);
            return this.initiateFakeBan(adminName, targetPlayer, reason);
        }
        this.pendingFakeBans.remove(pendingKey);
        return this.executeFakeBan(targetPlayer, pending.reason);
    }

    private String executeFakeBan(String targetPlayer, String reason) {
        try {
            long durationMinutes = this.configManager.getFakeBanDurationMinutes();
            long durationMs = TimeUnit.MINUTES.toMillis(durationMinutes);
            FakeBanEntry fakeBanEntry = new FakeBanEntry(targetPlayer, reason, durationMs);
            this.server.getPlayer(targetPlayer).ifPresent(player -> {
                fakeBanEntry.setUuid(player.getUniqueId().toString());
                fakeBanEntry.setIp(player.getRemoteAddress().getAddress().getHostAddress());
            });
            this.configManager.addFakeBan(fakeBanEntry);
            this.activeFakeBans.put(targetPlayer, fakeBanEntry);
            this.kickPlayer(targetPlayer, reason);
            this.logger.info("\u6210\u529f\u4e34\u65f6\u5c01\u7981\u73a9\u5bb6: " + targetPlayer + "\uff0c\u65f6\u957f: " + durationMinutes + "\u5206\u949f");
            return "\u6210\u529f\u4e34\u65f6\u5c01\u7981\u73a9\u5bb6: " + targetPlayer + "\uff0c\u65f6\u957f: " + durationMinutes + "\u5206\u949f";
        }
        catch (Exception e) {
            this.logger.error("\u6267\u884c\u4e34\u65f6\u5c01\u7981\u5931\u8d25: " + targetPlayer, (Throwable)e);
            return "\u6267\u884c\u4e34\u65f6\u5c01\u7981\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7";
        }
    }

    public String unFakeBan(String targetPlayer) {
        if (targetPlayer == null || targetPlayer.trim().isEmpty()) {
            return "\u73a9\u5bb6\u540d\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (targetPlayer.length() > 16 || !targetPlayer.matches("^[a-zA-Z0-9_]{1,16}$")) {
            return "\u65e0\u6548\u7684\u73a9\u5bb6\u540d\u683c\u5f0f";
        }
        FakeBanEntry fakeBan = this.findActiveFakeBan(targetPlayer);
        if (fakeBan == null) {
            return "\u8be5\u73a9\u5bb6\u6ca1\u6709\u6709\u6548\u7684\u4e34\u65f6\u5c01\u7981\u8bb0\u5f55\uff01";
        }
        this.configManager.setFakeBanState(targetPlayer, false);
        this.activeFakeBans.remove(targetPlayer);
        this.logger.info("\u6210\u529f\u89e3\u9664\u4e34\u65f6\u5c01\u7981: " + targetPlayer);
        return "\u6210\u529f\u89e3\u9664\u4e34\u65f6\u5c01\u7981: " + targetPlayer;
    }

    public boolean isFakeBanned(String uuid, String ip, String username) {
        return this.activeFakeBans.values().stream().filter(entry -> !entry.isExpired()).anyMatch(entry -> {
            if (entry.getName().equalsIgnoreCase(username)) {
                return true;
            }
            return !entry.getUuid().isEmpty() && entry.getUuid().equals(uuid) || !entry.getIp().isEmpty() && entry.getIp().equals(ip);
        });
    }

    public FakeBanEntry getFakeBanInfo(String uuid, String ip, String username) {
        return this.activeFakeBans.values().stream().filter(entry -> !entry.isExpired()).filter(entry -> {
            if (entry.getName().equalsIgnoreCase(username)) {
                return true;
            }
            return !entry.getUuid().isEmpty() && entry.getUuid().equals(uuid) || !entry.getIp().isEmpty() && entry.getIp().equals(ip);
        }).findFirst().orElse(null);
    }

    private FakeBanEntry findActiveFakeBan(String targetPlayer) {
        return this.activeFakeBans.values().stream().filter(entry -> entry.getName().equalsIgnoreCase(targetPlayer)).filter(entry -> !entry.isExpired()).findFirst().orElse(null);
    }

    private void kickPlayer(String targetPlayer, String reason) {
        this.server.getPlayer(targetPlayer).ifPresent(player -> {
            TextComponent kickMessage = Component.text((String)reason);
            player.disconnect((Component)kickMessage);
            this.logger.info("\u5df2\u8e22\u51fa\u73a9\u5bb6: " + targetPlayer + "\uff0c\u539f\u56e0: " + reason);
        });
    }

    private void loadActiveFakeBans() {
        this.activeFakeBans.clear();
        Map<String, FakeBanEntry> fakeBans = this.configManager.getFakeBans();
        for (FakeBanEntry entry : fakeBans.values()) {
            if (!entry.getState() || entry.isExpired()) continue;
            this.activeFakeBans.put(entry.getName(), entry);
        }
        this.logger.info("\u52a0\u8f7d\u4e86 " + this.activeFakeBans.size() + " \u4e2a\u6d3b\u8dc3\u7684\u4e34\u65f6\u5c01\u7981\u8bb0\u5f55");
    }

    private void startCleanupTask() {
        this.scheduler.scheduleAtFixedRate(() -> {
            try {
                this.pendingFakeBans.entrySet().removeIf(entry -> ((PendingFakeBan)entry.getValue()).isExpired());
                this.configManager.cleanupExpiredFakeBans();
                this.loadActiveFakeBans();
            }
            catch (Exception e) {
                this.logger.error("\u6e05\u7406\u8fc7\u671f\u4e34\u65f6\u5c01\u7981\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    public void shutdown() {
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public List<String> getFakeBannedPlayers() {
        return this.activeFakeBans.values().stream().filter(entry -> !entry.isExpired()).map(FakeBanEntry::getName).collect(Collectors.toList());
    }

    private static class PendingFakeBan {
        final String adminName;
        final String targetPlayer;
        final String reason;
        final long expireTime;

        PendingFakeBan(String adminName, String targetPlayer, String reason, long expireTime) {
            this.adminName = adminName;
            this.targetPlayer = targetPlayer;
            this.reason = reason;
            this.expireTime = expireTime;
        }

        boolean isExpired() {
            return System.currentTimeMillis() > this.expireTime;
        }
    }
}

