/*
 * Decompiled with CFR 0.152.
 */
package org.plugin.bantools;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.plugin.bantools.ConfigManager;
import org.slf4j.Logger;

public class WhitelistManager {
    private final ConfigManager configManager;
    private final Logger logger;
    private boolean enabled;
    private Set<String> whitelist;
    private String protectionMessage;

    public WhitelistManager(ConfigManager configManager, Logger logger) {
        this.configManager = configManager;
        this.logger = logger;
        this.whitelist = new HashSet<String>();
        this.protectionMessage = "\u8be5\u73a9\u5bb6\u53d7\u5230\u767d\u540d\u5355\u4fdd\u62a4\uff0c\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c\uff01";
        this.loadWhitelist();
    }

    public void loadWhitelist() {
        try {
            this.enabled = this.configManager.isWhitelistEnabled();
            this.protectionMessage = this.configManager.getWhitelistProtectionMessage();
            List<String> whitelistPlayers = this.configManager.getWhitelistPlayers();
            this.whitelist.clear();
            if (whitelistPlayers != null) {
                this.whitelist.addAll(whitelistPlayers);
            }
            this.logger.info("\u767d\u540d\u5355\u914d\u7f6e\u5df2\u52a0\u8f7d\uff0c\u72b6\u6001: " + (this.enabled ? "\u542f\u7528" : "\u7981\u7528") + "\uff0c\u4fdd\u62a4\u73a9\u5bb6\u6570\u91cf: " + this.whitelist.size());
        }
        catch (Exception e) {
            this.logger.error("\u52a0\u8f7d\u767d\u540d\u5355\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            this.enabled = true;
            this.protectionMessage = "\u8be5\u73a9\u5bb6\u53d7\u5230\u767d\u540d\u5355\u4fdd\u62a4\uff0c\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c\uff01";
            this.whitelist.clear();
            this.whitelist.addAll(Arrays.asList("Admin", "Owner"));
        }
    }

    public boolean isWhitelisted(String playerName) {
        if (!this.enabled || playerName == null) {
            return false;
        }
        return this.whitelist.contains(playerName);
    }

    public String checkProtection(String playerName) {
        if (this.isWhitelisted(playerName)) {
            return this.protectionMessage;
        }
        return null;
    }

    public boolean addToWhitelist(String playerName) {
        if (playerName == null || playerName.trim().isEmpty()) {
            return false;
        }
        boolean added = this.whitelist.add(playerName.trim());
        if (added) {
            this.logger.info("\u73a9\u5bb6 " + playerName + " \u5df2\u6dfb\u52a0\u5230\u5185\u5b58\u767d\u540d\u5355\uff08\u9700\u8981\u624b\u52a8\u7f16\u8f91\u914d\u7f6e\u6587\u4ef6\u6765\u6c38\u4e45\u4fdd\u5b58\uff09");
        }
        return added;
    }

    public boolean removeFromWhitelist(String playerName) {
        boolean removed = this.whitelist.remove(playerName);
        if (removed) {
            this.logger.info("\u73a9\u5bb6 " + playerName + " \u5df2\u4ece\u5185\u5b58\u767d\u540d\u5355\u79fb\u9664\uff08\u9700\u8981\u624b\u52a8\u7f16\u8f91\u914d\u7f6e\u6587\u4ef6\u6765\u6c38\u4e45\u4fdd\u5b58\uff09");
        }
        return removed;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Set<String> getWhitelist() {
        return new HashSet<String>(this.whitelist);
    }

    public String getProtectionMessage() {
        return this.protectionMessage;
    }
}

