/*
 * Decompiled with CFR 0.152.
 */
package dev.codedsakura.blossom.warps;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import dev.codedsakura.blossom.lib.BlossomLib;
import dev.codedsakura.blossom.lib.config.BlossomConfig;
import dev.codedsakura.blossom.lib.permissions.Permissions;
import dev.codedsakura.blossom.lib.teleport.TeleportConfig;
import dev.codedsakura.blossom.lib.teleport.TeleportUtils;
import dev.codedsakura.blossom.lib.text.DimName;
import dev.codedsakura.blossom.lib.text.TextSuperJoiner;
import dev.codedsakura.blossom.lib.text.TextUtils;
import dev.codedsakura.blossom.lib.utils.CustomLogger;
import dev.codedsakura.blossom.warps.BlossomWarpsConfig;
import dev.codedsakura.blossom.warps.Warp;
import dev.codedsakura.blossom.warps.WarpController;
import java.io.File;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2270;
import net.minecraft.class_2277;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.core.Logger;

public class BlossomWarps
implements ModInitializer {
    static BlossomWarpsConfig CONFIG = (BlossomWarpsConfig)BlossomConfig.load(BlossomWarpsConfig.class, (String)"BlossomWarps.json");
    public static final Logger LOGGER = CustomLogger.createLogger((String)"BlossomWarps");
    static WarpController warpController;

    public void onInitialize() {
        warpController = new WarpController();
        BlossomLib.addCommand((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"warp").requires(Permissions.require((String)"blossom.warps.warp", (boolean)true))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)warpController).executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            return this.warpPlayer((CommandContext<class_2168>)ctx, player);
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"who", (ArgumentType)class_2186.method_9305()).requires(Permissions.require((String)"blossom.warps.warp.others", (int)2))).executes(ctx -> this.warpPlayer((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"who")))))));
        BlossomLib.addCommand((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"warps").requires(Permissions.require((String)"blossom.warps.warps", (boolean)true))).executes(this::listWarpsAll)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(this::listWarpsAll)).then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(this::listWarpsDim)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(Permissions.require((String)"blossom.warps.add", (int)2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(this::addWarpPlayerPos)).then(class_2170.method_9244((String)"position", (ArgumentType)class_2277.method_9735((boolean)true)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"rotation", (ArgumentType)class_2270.method_9717()).executes(this::addWarpPosRot)).then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(this::addWarpDimension))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add-global").requires(Permissions.require((String)"blossom.warps.add.global", (int)2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(this::addGlobalWarpPlayerPos)).then(class_2170.method_9244((String)"position", (ArgumentType)class_2277.method_9735((boolean)true)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"rotation", (ArgumentType)class_2270.method_9717()).executes(this::addGlobalWarpPosRot)).then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(this::addGlobalWarpDimension))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(Permissions.require((String)"blossom.warps.remove", (int)2))).then(class_2170.method_9244((String)"warp", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)warpController).executes(this::removeWarp)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"load-legacy").requires(Permissions.require((String)"blossom.warps.load-legacy", (int)4))).executes(this::loadLegacyDefault)).then(class_2170.method_9244((String)"overwrite", (ArgumentType)BoolArgumentType.bool()).executes(this::loadLegacyArgument)))));
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            CommandDispatcher dispatcher = server.method_3734().method_9235();
            LOGGER.debug(warpController.getWarps());
            Optional.ofNullable(warpController.getWarps()).orElse(List.of()).stream().filter(v -> v.global).map(v -> v.name).forEach(warpName -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)warpName).requires(Permissions.require((String)("blossom.warps.global." + warpName), (boolean)true))).executes(ctx -> this.warpToName((CommandContext<class_2168>)ctx, (String)warpName))));
        });
    }

    private int warpPlayerToName(CommandContext<class_2168> ctx, class_3222 player, String warpName) {
        Warp warp = warpController.findWarp(warpName);
        LOGGER.debug("warp player [{}] to global {}", (Object)player.method_5667(), (Object)warp);
        if (warp == null) {
            TextUtils.sendErr(ctx, (String)"blossom.warps.not-found", (Object[])new Object[]{warpName});
        } else {
            TeleportUtils.teleport((TeleportConfig)BlossomWarps.CONFIG.teleportation, (double)BlossomWarps.CONFIG.standStill, (long)BlossomWarps.CONFIG.cooldown, BlossomWarps.class, (class_3222)player, () -> warp.toDestination(((class_2168)ctx.getSource()).method_9211()));
        }
        return 1;
    }

    private int warpPlayer(CommandContext<class_2168> ctx, class_3222 player) {
        String warpName = StringArgumentType.getString(ctx, (String)"warp");
        return this.warpPlayerToName(ctx, player, warpName);
    }

    private int warpToName(CommandContext<class_2168> ctx, String warpName) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        return this.warpPlayerToName(ctx, player, warpName);
    }

    class_5250 listWarpsConcatenate(String world) {
        class_5250 result = (class_5250)warpController.getWarps().stream().filter(warp -> warp.world.equals(world)).map(warp -> TextUtils.translation((String)"blossom.warps.list.item", (Object[])new Object[]{warp.name}).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10610("/warp " + warp.name)).method_10949((class_2568)new class_2568.class_10613((class_2561)TextUtils.translation((String)"blossom.warps.list.item.description", (Object[])new Object[]{warp.name, warp.owner, warp.world, String.format("%.2f", warp.x), String.format("%.2f", warp.y), String.format("%.2f", warp.z), String.format("%.2f", Float.valueOf(warp.yaw)), String.format("%.2f", Float.valueOf(warp.pitch))}))))).collect(TextSuperJoiner.collector((class_2561)TextUtils.translation((String)"blossom.warps.list.item.before", (Object[])new Object[0]), (class_2561)TextUtils.translation((String)"blossom.warps.list.item.after", (Object[])new Object[0]), (class_2561)TextUtils.translation((String)"blossom.warps.list.item.join", (Object[])new Object[0])));
        class_5250 copy = TextUtils.translation((String)"blossom.warps.list.header", (Object[])new Object[]{DimName.get((String)world)}).method_27661();
        return copy.method_10852((class_2561)result);
    }

    private int listWarpsAll(CommandContext<class_2168> ctx) {
        List<Warp> warps = warpController.getWarps();
        if (warps.size() == 0) {
            TextUtils.sendErr(ctx, (String)"blossom.warps.list.all.empty", (Object[])new Object[0]);
            return 1;
        }
        class_5250 result = (class_5250)warps.stream().map(warp -> warp.world).distinct().map(this::listWarpsConcatenate).collect(TextSuperJoiner.joiner((class_2561)TextUtils.translation((String)"blossom.warps.list.all.join", (Object[])new Object[0])));
        ((class_2168)ctx.getSource()).method_9226(() -> TextUtils.translation((String)"blossom.warps.list.all.header", (Object[])new Object[0]).method_10852((class_2561)result), false);
        return 1;
    }

    private int listWarpsDim(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        String dimension = class_2181.method_9289(ctx, (String)"dimension").method_27983().method_29177().toString();
        if (warpController.getWarps().stream().noneMatch(warp -> warp.world.equals(dimension))) {
            TextUtils.sendErr(ctx, (String)"blossom.warps.list.dimension.empty", (Object[])new Object[]{dimension});
            return 1;
        }
        ((class_2168)ctx.getSource()).method_9226(() -> this.listWarpsConcatenate(dimension), false);
        return 1;
    }

    private int addWarp(CommandContext<class_2168> ctx, Warp warp) {
        LOGGER.info("adding warp {}", (Object)warp);
        boolean result = warpController.addWarp(warp);
        if (result) {
            TextUtils.sendSuccessOps(ctx, (String)"blossom.warps.add", (Object[])new Object[]{warp.name});
        } else {
            TextUtils.sendErr(ctx, (String)"blossom.warps.add.failed", (Object[])new Object[]{warp.name});
        }
        return 1;
    }

    private int addWarpPlayerPos(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        String name = StringArgumentType.getString(ctx, (String)"name");
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        return this.addWarp(ctx, new Warp(name, (class_1657)player, new TeleportUtils.TeleportDestination((class_1657)player)));
    }

    private int addWarpPosRotDim(CommandContext<class_2168> ctx, class_3218 dimension, boolean global) throws CommandSyntaxException {
        String name = StringArgumentType.getString(ctx, (String)"name");
        class_243 position = class_2277.method_9734(ctx, (String)"position").method_9708((class_2168)ctx.getSource());
        class_241 rotation = class_2270.method_9716(ctx, (String)"rotation").method_9709((class_2168)ctx.getSource());
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        return this.addWarp(ctx, new Warp(name, (class_1657)player, new TeleportUtils.TeleportDestination(dimension, position, rotation.field_1343, rotation.field_1342), global));
    }

    private int addWarpPosRot(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        return this.addWarpPosRotDim(ctx, ((class_2168)ctx.getSource()).method_9225(), false);
    }

    private int addWarpDimension(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3218 dimension = class_2181.method_9289(ctx, (String)"dimension");
        return this.addWarpPosRotDim(ctx, dimension, false);
    }

    private int addGlobalWarpPlayerPos(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        String name = StringArgumentType.getString(ctx, (String)"name");
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        return this.addWarp(ctx, new Warp(name, (class_1657)player, new TeleportUtils.TeleportDestination((class_1657)player), true));
    }

    private int addGlobalWarpPosRot(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        return this.addWarpPosRotDim(ctx, ((class_2168)ctx.getSource()).method_9225(), true);
    }

    private int addGlobalWarpDimension(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3218 dimension = class_2181.method_9289(ctx, (String)"dimension");
        return this.addWarpPosRotDim(ctx, dimension, true);
    }

    private int removeWarp(CommandContext<class_2168> ctx) {
        String warpName = StringArgumentType.getString(ctx, (String)"warp");
        LOGGER.info("removing warp {}", (Object)warpController.findWarp(warpName));
        boolean result = warpController.removeWarp(warpName);
        if (result) {
            TextUtils.sendWarnOps(ctx, (String)"blossom.warps.remove", (Object[])new Object[]{warpName});
        } else {
            TextUtils.sendErr(ctx, (String)"blossom.warps.remove.failed", (Object[])new Object[]{warpName});
        }
        return 1;
    }

    private int loadLegacy(CommandContext<class_2168> ctx, boolean overwrite) {
        TextUtils.sendOps(ctx, (String)"blossom.homes.load-legacy.info", (Object[])new Object[0]);
        if (overwrite) {
            TextUtils.sendOps(ctx, (String)"blossom.homes.load-legacy.overwrite", (Object[])new Object[0]);
        }
        MinecraftServer server = ((class_2168)ctx.getSource()).method_9211();
        File[] playerDataFiles = server.method_27050(class_5218.field_24184).toFile().listFiles();
        int totalHomes = 0;
        int totalPlayers = 0;
        TextUtils.sendOps(ctx, (String)"blossom.homes.load-legacy.done", (Object[])new Object[]{totalHomes, totalPlayers});
        return 1;
    }

    private int loadLegacyArgument(CommandContext<class_2168> ctx) {
        boolean overwrite = BoolArgumentType.getBool(ctx, (String)"overwrite");
        return this.loadLegacy(ctx, overwrite);
    }

    private int loadLegacyDefault(CommandContext<class_2168> ctx) {
        return this.loadLegacy(ctx, false);
    }
}

