/*
 * Decompiled with CFR 0.152.
 */
package xyz.lyki.friendguard;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import org.apache.logging.log4j.Logger;
import xyz.lyki.friendguard.FriendGuard;
import xyz.lyki.friendguard.KeyUtils.AddRemovePlayer;
import xyz.lyki.friendguard.KeyUtils.ClearList;

public class FriendGuardClient
implements ClientModInitializer {
    public static ArrayList<String> ProtectedPlayers = FriendGuard.ProtectedPlayers;
    private static final File configFile = new File("mods/FriendGuard/FriendGuardConfig.json");
    public static final Logger LOGGER = FriendGuard.LOGGER;
    public static Map<String, String> messages = new HashMap<String, String>();
    public static boolean isModEnabled;
    public static boolean isCompassEnabled;
    private String lastClientLanguage = "";
    private static final class_3414 DIDGERIDOO_SOUND_EVENT;
    private static final String[] COMPASS_DIRECTIONS;

    public void onInitializeClient() {
        isModEnabled = true;
        isCompassEnabled = true;
        AddRemovePlayer.register();
        ClearList.register();
        this.readConfigFile();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            String currentLanguage;
            if (client.field_1687 != null && client.field_1724 != null && class_310.method_1551().method_1526().method_4669() != null && !(currentLanguage = client.method_1526().method_4669()).equals(this.lastClientLanguage)) {
                this.lastClientLanguage = currentLanguage;
                this.loadLanguageMessages(currentLanguage);
            }
        });
        HudRenderCallback.EVENT.register((matrixStack, tickDelta) -> {
            class_310 client = class_310.method_1551();
            if (client.field_1687 != null && client.field_1724 != null && isModEnabled && isCompassEnabled) {
                class_1923 playerChunkPos = new class_1923(client.field_1724.method_24515());
                int chunkRenderDistance = 16;
                StringBuilder nonProtectedPlayers = new StringBuilder();
                int protectedCount = 0;
                class_1657 closestPlayer = null;
                double closestDistance = Double.MAX_VALUE;
                for (class_1657 player : client.field_1687.method_18456()) {
                    class_1923 playerChunk = new class_1923(player.method_24515());
                    class_2338 playerPos = player.method_24515();
                    int distance = Math.abs(playerChunk.field_9181 - playerChunkPos.field_9181) + Math.abs(playerChunk.field_9180 - playerChunkPos.field_9180);
                    if (distance > chunkRenderDistance || player == client.field_1724) continue;
                    player.method_6092(new class_1293(class_1294.field_5912, 2000, 0, false, false));
                    String playerName = player.method_5477().getString();
                    if (ProtectedPlayers.contains(playerName)) {
                        ++protectedCount;
                        continue;
                    }
                    double actualDistance = playerPos.method_19770((class_2374)client.field_1724.method_19538());
                    if (!(actualDistance < closestDistance)) continue;
                    closestDistance = actualDistance;
                    closestPlayer = player;
                }
                for (class_1657 player : client.field_1687.method_18456()) {
                    String playerName = player.method_5477().getString();
                    if (ProtectedPlayers.contains(playerName) || player == client.field_1724 || player == closestPlayer) continue;
                    nonProtectedPlayers.append(playerName).append(", ");
                }
                if (nonProtectedPlayers.length() > 0) {
                    nonProtectedPlayers.setLength(nonProtectedPlayers.length() - 2);
                }
                if (closestPlayer != null) {
                    String actionBarMessage = closestPlayer.method_5477().getString() + messages.get("isNearby") + this.getCompassSymbol((class_1657)client.field_1724, closestPlayer);
                    if (nonProtectedPlayers.length() > 0) {
                        String[] nonProtectedPlayersArray = nonProtectedPlayers.toString().split(", ");
                        actionBarMessage = nonProtectedPlayersArray.length <= 2 ? actionBarMessage + ", " + nonProtectedPlayers.toString() : closestPlayer.method_5477().getString() + messages.get("closest") + this.getCompassSymbol((class_1657)client.field_1724, closestPlayer) + " | " + nonProtectedPlayersArray.length + messages.get("morePlayersFound");
                    }
                    if (protectedCount > 0) {
                        String protectedPlayersCount = String.valueOf(class_124.field_1060) + "(" + protectedCount + ") ";
                        actionBarMessage = protectedPlayersCount + String.valueOf(class_124.field_1061) + actionBarMessage;
                    }
                    client.field_1705.method_1758((class_2561)class_2561.method_43470((String)actionBarMessage).method_27692(class_124.field_1061), false);
                }
            }
        });
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            class_1657 targetPlayer;
            if (entity instanceof class_1657 && ProtectedPlayers.contains((targetPlayer = (class_1657)entity).method_5477().getString()) && isModEnabled) {
                this.playDidgeridooSound(player);
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            this.loadLanguageMessages(class_310.method_1551().field_1690.field_1883);
            if (isModEnabled) {
                LOGGER.info(messages.get("friendguardActivated"));
            } else {
                LOGGER.error(messages.get("friendguardDeactiveError"));
            }
        });
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> FriendGuardClient.saveConfig());
    }

    private void loadLanguageMessages(String clientLanguage) {
        messages.clear();
        LOGGER.info("Language set to: " + clientLanguage);
        if ("tr_tr".equals(clientLanguage)) {
            messages.put("friendguardActivated", "No Friendly Fire is active!");
            messages.put("friendguardDeactiveError", "FriendGuard yap\u0131land\u0131rma ayarlar\u0131 nedeniyle devre d\u0131\u015f\u0131 b\u0131rak\u0131ld\u0131. Modu kullanmak i\u00e7in etkinle\u015ftirmeniz gerekiyor. ModMenu veya yap\u0131land\u0131rma dosyas\u0131 \u00fczerinden etkinle\u015ftirebilirsiniz! lykiaofficial taraf\u0131ndan (https://lyki.dev)");
            messages.put("isNearby", " yak\u0131nlarda! ");
            messages.put("closest", " en yak\u0131n! ");
            messages.put("morePlayersFound", " oyuncu daha bulundu!");
            messages.put("isNowAProtectedPlayer", " art\u0131k korunan bir oyuncu!");
            messages.put("isNoLongerAProtectedPlayer", " art\u0131k korunan bir oyuncu de\u011fil!");
            messages.put("notLookingAPlayer", "Bir oyuncuya bakm\u0131yorsunuz!");
            messages.put("notLookingAnything", "Hi\u00e7bir \u015feye bakm\u0131yorsunuz!");
            messages.put("listAlreadyEmpty", "Oyuncu listesi zaten bo\u015f!");
            messages.put("listCleared", "Oyuncu listesi temizlendi!");
            messages.put("FriendGuardDisabled", "FriendGuard aktif de\u011fil!");
            messages.put("compassSettingsLabel", "Pusula Ayarlar\u0131");
            messages.put("enableCompassButton", "G\u00f6ster");
            messages.put("disableCompassButton", "Gizle");
        } else if ("fr_fr".equals(clientLanguage)) {
            messages.put("friendguardActivated", "No Friendly Fire is active!");
            messages.put("friendguardDeactiveError", "FriendGuard est d\u00e9sactiv\u00e9 en raison des param\u00e8tres de configuration. Vous devez l'activer pour utiliser le mod. Vous pouvez l'activer via ModMenu ou le fichier de configuration! par lykiaofficial (https://lyki.dev)");
            messages.put("isNearby", " est \u00e0 proximit\u00e9! ");
            messages.put("closest", " le plus proche! ");
            messages.put("morePlayersFound", " joueurs trouv\u00e9s de plus!");
            messages.put("isNowAProtectedPlayer", " est maintenant un joueur prot\u00e9g\u00e9!");
            messages.put("isNoLongerAProtectedPlayer", " n'est plus un joueur prot\u00e9g\u00e9!");
            messages.put("notLookingAPlayer", "Vous ne regardez pas un joueur!");
            messages.put("notLookingAnything", "Vous ne regardez rien!");
            messages.put("listAlreadyEmpty", "La liste des joueurs est d\u00e9j\u00e0 vide!");
            messages.put("listCleared", "La liste des joueurs a \u00e9t\u00e9 effac\u00e9e!");
            messages.put("FriendGuardDisabled", "FriendGuard est d\u00e9sactiv\u00e9!");
            messages.put("compassSettingsLabel", "Param\u00e8tres de la Boussole");
            messages.put("enableCompassButton", "Afficher");
            messages.put("disableCompassButton", "Masquer");
        } else if ("es_es".equals(clientLanguage)) {
            messages.put("friendguardActivated", "No Friendly Fire is active!");
            messages.put("friendguardDeactiveError", "FriendGuard est\u00e1 desactivado debido a la configuraci\u00f3n. Necesitas activarlo para usar el mod. Puedes activarlo a trav\u00e9s de ModMenu o del archivo de configuraci\u00f3n! por lykiaofficial (https://lyki.dev)");
            messages.put("isNearby", " est\u00e1 cerca! ");
            messages.put("closest", " \u00a1m\u00e1s cercano! ");
            messages.put("morePlayersFound", " jugadores m\u00e1s encontrados!");
            messages.put("isNowAProtectedPlayer", " ahora es un jugador protegido!");
            messages.put("isNoLongerAProtectedPlayer", " ya no es un jugador protegido!");
            messages.put("notLookingAPlayer", "\u00a1No est\u00e1s mirando a un jugador!");
            messages.put("notLookingAnything", "\u00a1No est\u00e1s mirando nada!");
            messages.put("listAlreadyEmpty", "\u00a1La lista de jugadores ya est\u00e1 vac\u00eda!");
            messages.put("listCleared", "\u00a1La lista de jugadores ha sido limpiada!");
            messages.put("FriendGuardDisabled", "\u00a1FriendGuard est\u00e1 desactivado!");
            messages.put("compassSettingsLabel", "Ajustes de la Br\u00fajula");
            messages.put("enableCompassButton", "Mostrar");
            messages.put("disableCompassButton", "Ocultar");
        } else if ("de_de".equals(clientLanguage)) {
            messages.put("friendguardActivated", "No Friendly Fire is active!");
            messages.put("friendguardDeactiveError", "FriendGuard ist aufgrund der Konfigurationseinstellungen deaktiviert. Sie m\u00fcssen es aktivieren, um das Mod zu verwenden. Sie k\u00f6nnen es \u00fcber ModMenu oder die Konfigurationsdatei aktivieren! von lykiaofficial (https://lyki.dev)");
            messages.put("isNearby", " ist in der N\u00e4he! ");
            messages.put("closest", " am n\u00e4chsten! ");
            messages.put("morePlayersFound", " weitere Spieler gefunden!");
            messages.put("isNowAProtectedPlayer", " ist jetzt ein gesch\u00fctzter Spieler!");
            messages.put("isNoLongerAProtectedPlayer", " ist kein gesch\u00fctzter Spieler mehr!");
            messages.put("notLookingAPlayer", "Du schaust keinen Spieler an!");
            messages.put("notLookingAnything", "Du schaust nichts an!");
            messages.put("listAlreadyEmpty", "Spielerliste ist bereits leer!");
            messages.put("listCleared", "Spielerliste wurde geleert!");
            messages.put("FriendGuardDisabled", "FriendGuard ist deaktiviert!");
            messages.put("compassSettingsLabel", "Kompass-Einstellungen");
            messages.put("enableCompassButton", "Anzeigen");
            messages.put("disableCompassButton", "Verstecken");
        } else if ("pt_br".equals(clientLanguage)) {
            messages.put("friendguardActivated", "No Friendly Fire is active!");
            messages.put("friendguardDeactiveError", "FriendGuard est\u00e1 desativado devido \u00e0s configura\u00e7\u00f5es de configura\u00e7\u00e3o. Voc\u00ea precisa ativ\u00e1-lo para usar o mod. Voc\u00ea pode ativ\u00e1-lo atrav\u00e9s do ModMenu ou do arquivo de configura\u00e7\u00e3o! por lykiaofficial (https://lyki.dev)");
            messages.put("isNearby", " est\u00e1 por perto! ");
            messages.put("closest", " mais pr\u00f3ximo! ");
            messages.put("morePlayersFound", " mais jogadores encontrados!");
            messages.put("isNowAProtectedPlayer", " agora \u00e9 um jogador protegido!");
            messages.put("isNoLongerAProtectedPlayer", " n\u00e3o \u00e9 mais um jogador protegido!");
            messages.put("notLookingAPlayer", "Voc\u00ea n\u00e3o est\u00e1 olhando para um jogador!");
            messages.put("notLookingAnything", "Voc\u00ea n\u00e3o est\u00e1 olhando para nada!");
            messages.put("listAlreadyEmpty", "A lista de jogadores j\u00e1 est\u00e1 vazia!");
            messages.put("listCleared", "A lista de jogadores foi limpa!");
            messages.put("FriendGuardDisabled", "FriendGuard est\u00e1 desativado!");
            messages.put("compassSettingsLabel", "Configura\u00e7\u00f5es da B\u00fassola");
            messages.put("enableCompassButton", "Mostrar");
            messages.put("disableCompassButton", "Ocultar");
        } else if ("ru_ru".equals(clientLanguage)) {
            messages.put("friendguardActivated", "No Friendly Fire is active!");
            messages.put("friendguardDeactiveError", "FriendGuard \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d \u0438\u0437-\u0437\u0430 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438. \u0412\u0430\u043c \u043d\u0443\u0436\u043d\u043e \u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0435\u0433\u043e, \u0447\u0442\u043e\u0431\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043c\u043e\u0434. \u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0435\u0433\u043e \u0447\u0435\u0440\u0435\u0437 ModMenu \u0438\u043b\u0438 \u0444\u0430\u0439\u043b \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438! \u043e\u0442 lykiaofficial (https://lyki.dev)");
            messages.put("isNearby", " \u043f\u043e\u0431\u043b\u0438\u0437\u043e\u0441\u0442\u0438! ");
            messages.put("closest", " \u0431\u043b\u0438\u0436\u0435 \u0432\u0441\u0435\u0433\u043e! ");
            messages.put("morePlayersFound", " \u0438\u0433\u0440\u043e\u043a\u043e\u0432 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0435\u0449\u0435!");
            messages.put("isNowAProtectedPlayer", " \u0442\u0435\u043f\u0435\u0440\u044c \u0437\u0430\u0449\u0438\u0449\u0435\u043d\u043d\u044b\u0439 \u0438\u0433\u0440\u043e\u043a!");
            messages.put("isNoLongerAProtectedPlayer", " \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u0437\u0430\u0449\u0438\u0449\u0435\u043d\u043d\u044b\u0439 \u0438\u0433\u0440\u043e\u043a!");
            messages.put("notLookingAPlayer", "\u0412\u044b \u043d\u0435 \u0441\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u043d\u0430 \u0438\u0433\u0440\u043e\u043a\u0430!");
            messages.put("notLookingAnything", "\u0412\u044b \u043d\u0435 \u0441\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u043d\u0438 \u043d\u0430 \u0447\u0442\u043e!");
            messages.put("listAlreadyEmpty", "\u0421\u043f\u0438\u0441\u043e\u043a \u0438\u0433\u0440\u043e\u043a\u043e\u0432 \u0443\u0436\u0435 \u043f\u0443\u0441\u0442!");
            messages.put("listCleared", "\u0421\u043f\u0438\u0441\u043e\u043a \u0438\u0433\u0440\u043e\u043a\u043e\u0432 \u043e\u0447\u0438\u0449\u0435\u043d!");
            messages.put("FriendGuardDisabled", "FriendGuard \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d!");
            messages.put("compassSettingsLabel", "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u041a\u043e\u043c\u043f\u0430\u0441\u0430");
            messages.put("enableCompassButton", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c");
            messages.put("disableCompassButton", "\u0421\u043a\u0440\u044b\u0442\u044c");
        } else if ("zh_cn".equals(clientLanguage)) {
            messages.put("friendguardActivated", "No Friendly Fire is active!");
            messages.put("friendguardDeactiveError", "\u7531\u4e8e\u914d\u7f6e\u8bbe\u7f6e\uff0cFriendGuard \u5df2\u7981\u7528\u3002\u60a8\u9700\u8981\u542f\u7528\u5b83\u624d\u80fd\u4f7f\u7528\u8be5\u6a21\u7ec4\u3002\u60a8\u53ef\u4ee5\u901a\u8fc7 ModMenu \u6216\u914d\u7f6e\u6587\u4ef6\u542f\u7528\u5b83! \u4f5c\u8005\uff1alykiaofficial (https://lyki.dev)");
            messages.put("isNearby", " \u9644\u8fd1! ");
            messages.put("closest", " \u6700\u8fd1\u7684! ");
            messages.put("morePlayersFound", " \u66f4\u591a\u73a9\u5bb6\u627e\u5230!");
            messages.put("isNowAProtectedPlayer", " \u73b0\u5728\u662f\u53d7\u4fdd\u62a4\u7684\u73a9\u5bb6!");
            messages.put("isNoLongerAProtectedPlayer", " \u4e0d\u518d\u662f\u53d7\u4fdd\u62a4\u7684\u73a9\u5bb6!");
            messages.put("notLookingAPlayer", "\u4f60\u6ca1\u6709\u770b\u7740\u73a9\u5bb6!");
            messages.put("notLookingAnything", "\u4f60\u6ca1\u6709\u770b\u7740\u4efb\u4f55\u4e1c\u897f!");
            messages.put("listAlreadyEmpty", "\u73a9\u5bb6\u5217\u8868\u5df2\u7ecf\u4e3a\u7a7a!");
            messages.put("listCleared", "\u73a9\u5bb6\u5217\u8868\u5df2\u6e05\u7a7a!");
            messages.put("FriendGuardDisabled", "FriendGuard \u5df2\u7981\u7528!");
            messages.put("compassSettingsLabel", "\u6307\u5357\u9488\u8bbe\u7f6e");
            messages.put("enableCompassButton", "\u663e\u793a");
            messages.put("disableCompassButton", "\u9690\u85cf");
        } else {
            messages.put("friendguardActivated", "No Friendly Fire is active!");
            messages.put("friendguardDeactiveError", "FriendGuard is disabled due to configuration settings. You need to enable it to use the mod. You can activate it through ModMenu or the configuration file! by lykiaofficial (https://lyki.dev)");
            messages.put("isNearby", " is nearby! ");
            messages.put("closest", " closest! ");
            messages.put("morePlayersFound", " more players found!");
            messages.put("isNowAProtectedPlayer", " is now a protected player!");
            messages.put("isNoLongerAProtectedPlayer", " is no longer a protected player!");
            messages.put("notLookingAPlayer", "You are not looking at a player!");
            messages.put("notLookingAnything", "You are not looking at anything!");
            messages.put("listAlreadyEmpty", "Player list is already empty!");
            messages.put("listCleared", "Player list cleared!");
            messages.put("FriendGuardDisabled", "FriendGuard is disabled!");
            messages.put("compassSettingsLabel", "Compass Settings");
            messages.put("enableCompassButton", "Show");
            messages.put("disableCompassButton", "Hide");
        }
    }

    public void readConfigFile() {
        if (!configFile.exists()) {
            LOGGER.warn("Config file not found, it might not have been created yet.");
            isModEnabled = true;
            isCompassEnabled = true;
            AddRemovePlayer.isModEnabled = true;
            ClearList.isModEnabled = true;
            return;
        }
        if (configFile.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader("mods/FriendGuard/FriendGuardConfig.json"));
                JsonObject configObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                JsonArray playerNamesArray = configObject.getAsJsonArray("player_names");
                for (JsonElement element : playerNamesArray) {
                    String playerName = element.getAsString();
                    ProtectedPlayers.add(playerName);
                    LOGGER.info("Player added by config: " + playerName);
                }
                isModEnabled = configObject.get("is_mod_enabled").getAsBoolean();
                AddRemovePlayer.isModEnabled = configObject.get("is_mod_enabled").getAsBoolean();
                ClearList.isModEnabled = configObject.get("is_mod_enabled").getAsBoolean();
                isCompassEnabled = configObject.has("is_compass_enabled") ? configObject.get("is_compass_enabled").getAsBoolean() : true;
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveConfig() {
        JsonObject configObject = new JsonObject();
        JsonArray playerNamesArray = new JsonArray();
        for (String playerName : ProtectedPlayers) {
            playerNamesArray.add(playerName);
        }
        configObject.add("player_names", (JsonElement)playerNamesArray);
        configObject.addProperty("is_mod_enabled", Boolean.valueOf(isModEnabled));
        configObject.addProperty("is_compass_enabled", Boolean.valueOf(isCompassEnabled));
        try {
            if (!configFile.exists()) {
                configFile.getParentFile().mkdirs();
                configFile.createNewFile();
            }
            FileWriter writer = new FileWriter(configFile);
            writer.write(configObject.toString());
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void playDidgeridooSound(class_1657 player) {
        player.method_5783(DIDGERIDOO_SOUND_EVENT, 1.0f, 1.0f);
    }

    private String getCompassSymbol(class_1657 player, class_1657 closestPlayer) {
        float playerYaw = player.method_5705(1.0f);
        float closestPlayerYaw = this.getClosestPlayerYaw(player, closestPlayer);
        float yawDifference = class_3532.method_15393((float)(closestPlayerYaw - playerYaw));
        if ((double)yawDifference >= -22.5 && (double)yawDifference <= 22.5) {
            return COMPASS_DIRECTIONS[0];
        }
        if ((double)yawDifference > 22.5 && (double)yawDifference <= 67.5) {
            return COMPASS_DIRECTIONS[1];
        }
        if ((double)yawDifference > 67.5 && (double)yawDifference <= 112.5) {
            return COMPASS_DIRECTIONS[2];
        }
        if ((double)yawDifference > 112.5 && (double)yawDifference <= 157.5) {
            return COMPASS_DIRECTIONS[3];
        }
        if ((double)yawDifference > 157.5 || (double)yawDifference <= -157.5) {
            return COMPASS_DIRECTIONS[4];
        }
        if ((double)yawDifference > -157.5 && (double)yawDifference <= -112.5) {
            return COMPASS_DIRECTIONS[5];
        }
        if ((double)yawDifference > -112.5 && (double)yawDifference <= -67.5) {
            return COMPASS_DIRECTIONS[6];
        }
        return COMPASS_DIRECTIONS[7];
    }

    private float getClosestPlayerYaw(class_1657 player, class_1657 closestPlayer) {
        class_2338 playerPos = player.method_24515();
        class_2338 closestPlayerPos = closestPlayer.method_24515();
        return (float)class_3532.method_15338((double)(class_3532.method_15349((double)(closestPlayerPos.method_10260() - playerPos.method_10260()), (double)(closestPlayerPos.method_10263() - playerPos.method_10263())) * 57.29577951308232 - 90.0));
    }

    static {
        DIDGERIDOO_SOUND_EVENT = class_3414.method_47908((class_2960)class_2960.method_60655((String)"minecraft", (String)"block.note_block.didgeridoo"));
        COMPASS_DIRECTIONS = new String[]{"\u2191", "\u2197", "\u2192", "\u2198", "\u2193", "\u2199", "\u2190", "\u2196"};
    }
}

