/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.forge;

import com.seibel.distanthorizons.core.network.messages.AbstractNetworkMessage;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IServerPlayerWrapper;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import loaderCommon.forge.com.seibel.distanthorizons.common.AbstractPluginPacketSender;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.misc.ServerPlayerWrapper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;

public class ForgePluginPacketSender
extends AbstractPluginPacketSender {
    public static final SimpleChannel PLUGIN_CHANNEL = ChannelBuilder.named((ResourceLocation)AbstractPluginPacketSender.WRAPPER_PACKET_RESOURCE).networkProtocolVersion(1).serverAcceptedVersions((status, version) -> true).clientAcceptedVersions((status, version) -> true).simpleChannel();

    public ForgePluginPacketSender() {
        super(true);
    }

    public void setPacketHandler(Consumer<AbstractNetworkMessage> consumer) {
        this.setPacketHandler((IServerPlayerWrapper player, AbstractNetworkMessage message) -> consumer.accept((AbstractNetworkMessage)message));
    }

    public void setPacketHandler(BiConsumer<IServerPlayerWrapper, AbstractNetworkMessage> consumer) {
        PLUGIN_CHANNEL.messageBuilder(MessageWrapper.class, 0).encoder((wrapper, out) -> this.encodeMessage((FriendlyByteBuf)out, wrapper.message)).decoder(in -> new MessageWrapper(this.decodeMessage((FriendlyByteBuf)in))).consumerNetworkThread((wrapper, context) -> {
            if (wrapper.message != null) {
                if (context.getSender() != null) {
                    consumer.accept(ServerPlayerWrapper.getWrapper(context.getSender()), wrapper.message);
                } else {
                    consumer.accept(null, wrapper.message);
                }
            }
            context.setPacketHandled(true);
        }).add();
    }

    @Override
    public void sendToServer(AbstractNetworkMessage message) {
        PLUGIN_CHANNEL.send((Object)new MessageWrapper(message), PacketDistributor.SERVER.noArg());
    }

    @Override
    public void sendToClient(ServerPlayer serverPlayer, AbstractNetworkMessage message) {
        PLUGIN_CHANNEL.send((Object)new MessageWrapper(message), PacketDistributor.PLAYER.with((Object)serverPlayer));
    }

    public static class MessageWrapper {
        public final AbstractNetworkMessage message;

        public MessageWrapper(AbstractNetworkMessage message) {
            this.message = message;
        }
    }
}

