/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.block;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPosMutable;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.util.FullDataPointUtil;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.biome.Biome;

public abstract class AbstractDhTintGetter
implements BlockAndTintGetter {
    protected final BiomeWrapper biomeWrapper;
    protected final int smoothingRadiusInBlocks;
    protected final FullDataSourceV2 fullDataSource;

    public AbstractDhTintGetter(BiomeWrapper biomeWrapper, FullDataSourceV2 fullDataSource) {
        this.biomeWrapper = biomeWrapper;
        this.fullDataSource = fullDataSource;
        this.smoothingRadiusInBlocks = Config.Client.Advanced.Graphics.Quality.lodBiomeBlending.get();
    }

    public int m_6171_(BlockPos blockPos, ColorResolver colorResolver) {
        byte dataSourceDetailLevel = DhSectionPos.getDetailLevel(this.fullDataSource.getPos());
        dataSourceDetailLevel = (byte)(dataSourceDetailLevel - 6);
        int dataSourceLodWidthInBlocks = DhSectionPos.getDetailLevelWidthInBlocks(dataSourceDetailLevel);
        if (this.smoothingRadiusInBlocks == 0 || dataSourceLodWidthInBlocks > this.smoothingRadiusInBlocks) {
            return colorResolver.m_130045_(this.unwrapBiome(this.biomeWrapper.biome), (double)blockPos.m_123341_(), (double)blockPos.m_123343_());
        }
        int dataPointCount = 0;
        int rollingRed = 0;
        int rollingGreen = 0;
        int rollingBlue = 0;
        int xMin = blockPos.m_123341_() - this.smoothingRadiusInBlocks;
        int xMax = blockPos.m_123341_() + this.smoothingRadiusInBlocks;
        int zMin = blockPos.m_123343_() - this.smoothingRadiusInBlocks;
        int zMax = blockPos.m_123343_() + this.smoothingRadiusInBlocks;
        DhBlockPosMutable mutableBlockPos = new DhBlockPosMutable(0, blockPos.m_123342_(), 0);
        for (int x = xMin; x < xMax; ++x) {
            for (int z = zMin; z < zMax; ++z) {
                mutableBlockPos.setX(x);
                mutableBlockPos.setZ(z);
                long dataPoint = this.fullDataSource.getAtBlockPos(mutableBlockPos);
                if (dataPoint == 0L) continue;
                int id = FullDataPointUtil.getId(dataPoint);
                BiomeWrapper biomeWrapper = (BiomeWrapper)this.fullDataSource.mapping.getBiomeWrapper(id);
                int color = colorResolver.m_130045_(this.unwrapBiome(biomeWrapper.biome), (double)mutableBlockPos.getX(), (double)mutableBlockPos.getZ());
                rollingRed += ColorUtil.getRed(color);
                rollingGreen += ColorUtil.getGreen(color);
                rollingBlue += ColorUtil.getBlue(color);
                ++dataPointCount;
            }
        }
        if (dataPointCount == 0) {
            return colorResolver.m_130045_(this.unwrapBiome(this.biomeWrapper.biome), (double)blockPos.m_123341_(), (double)blockPos.m_123343_());
        }
        int colorInt = ColorUtil.argbToInt(255, rollingRed / dataPointCount, rollingGreen / dataPointCount, rollingBlue / dataPointCount);
        return colorInt;
    }

    protected Biome unwrapBiome(Holder<Biome> biome) {
        return (Biome)biome.m_203334_();
    }
}

