/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.gui.updater;

import com.seibel.distanthorizons.api.enums.config.EDhApiUpdateBranch;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.jar.ModJarInfo;
import com.seibel.distanthorizons.core.jar.installer.ModrinthGetter;
import com.seibel.distanthorizons.core.jar.updater.SelfUpdater;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.coreapi.ModInfo;
import java.util.Objects;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.gui.DhScreen;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.gui.GuiHelper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.gui.TexturedButtonWidget;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.gui.updater.ChangelogScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Logger;

public class UpdateModScreen
extends DhScreen {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private Screen parent;
    private String newVersionID;
    private String currentVer;
    private String nextVer;

    public UpdateModScreen(Screen parent, String newVersionID) throws IllegalArgumentException {
        super((Component)GuiHelper.Translatable("distanthorizons.updater.title", new Object[0]));
        this.parent = parent;
        this.newVersionID = newVersionID;
        EDhApiUpdateBranch updateBranch = EDhApiUpdateBranch.convertAutoToStableOrNightly(Config.Client.Advanced.AutoUpdater.updateBranch.get());
        if (updateBranch == EDhApiUpdateBranch.STABLE) {
            this.currentVer = "2.3.5-b";
            this.nextVer = ModrinthGetter.releaseNames.get(this.newVersionID);
        } else {
            this.currentVer = ModJarInfo.Git_Commit.substring(0, 7);
            this.nextVer = this.newVersionID.substring(0, 7);
        }
        if (this.nextVer == null) {
            throw new IllegalArgumentException("No new version found with the ID [" + newVersionID + "].");
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        try {
            this.addBtn(new TexturedButtonWidget(this.f_96543_ / 2 - 95, this.f_96544_ / 2 - 110, 195, 65, 0, 0, 0, new ResourceLocation("distanthorizons", "logo.png"), 195, 65, buttonWidget -> System.out.println("Nice, you found an easter egg :)"), (Component)GuiHelper.Translatable("distanthorizons.updater.title", new Object[0]), false));
        }
        catch (Exception e) {
            LOGGER.error("Failed to setup update mod screen, error: [" + e.getMessage() + "].", (Throwable)e);
        }
        if (!ModInfo.IS_DEV_BUILD) {
            this.addBtn(new TexturedButtonWidget(this.f_96543_ / 2 - 97, this.f_96544_ / 2 + 8, 20, 20, 0, 0, 0, new ResourceLocation("distanthorizons", "textures/gui/changelog.png"), 20, 20, buttonWidget -> Objects.requireNonNull(this.f_96541_).m_91152_((Screen)new ChangelogScreen(this, this.newVersionID)), (Component)GuiHelper.Translatable("distanthorizons.updater.title", new Object[0])));
        }
        this.addBtn(GuiHelper.MakeBtn((Component)GuiHelper.Translatable("distanthorizons.updater.update", new Object[0]), this.f_96543_ / 2 - 75, this.f_96544_ / 2 + 8, 150, 20, btn -> {
            SelfUpdater.updateMod();
            this.m_7379_();
        }));
        this.addBtn(GuiHelper.MakeBtn((Component)GuiHelper.Translatable("distanthorizons.updater.silent", new Object[0]), this.f_96543_ / 2 - 75, this.f_96544_ / 2 + 30, 150, 20, btn -> {
            Config.Client.Advanced.AutoUpdater.enableSilentUpdates.set(true);
            SelfUpdater.updateMod();
            this.m_7379_();
        }));
        this.addBtn(GuiHelper.MakeBtn((Component)GuiHelper.Translatable("distanthorizons.updater.later", new Object[0]), this.f_96543_ / 2 + 2, this.f_96544_ / 2 + 70, 100, 20, btn -> this.m_7379_()));
        this.addBtn(GuiHelper.MakeBtn((Component)GuiHelper.Translatable("distanthorizons.updater.never", new Object[0]), this.f_96543_ / 2 - 102, this.f_96544_ / 2 + 70, 100, 20, btn -> {
            Config.Client.Advanced.AutoUpdater.enableAutoUpdater.set(false);
            this.m_7379_();
        }));
    }

    public void m_88315_(GuiGraphics matrices, int mouseX, int mouseY, float delta) {
        this.m_280273_(matrices, mouseX, mouseY, delta);
        super.m_88315_(matrices, mouseX, mouseY, delta);
        this.DhDrawCenteredString(matrices, this.f_96547_, (Component)GuiHelper.Translatable("distanthorizons.updater.text1", new Object[0]), this.f_96543_ / 2, this.f_96544_ / 2 - 35, 0xFFFFFF);
        this.DhDrawCenteredString(matrices, this.f_96547_, (Component)GuiHelper.Translatable("distanthorizons.updater.text2", this.currentVer, this.nextVer), this.f_96543_ / 2, this.f_96544_ / 2 - 20, 5438802);
    }

    public void m_7379_() {
        Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
    }
}

