/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.config.types;

import com.seibel.distanthorizons.core.config.NumberUtil;
import com.seibel.distanthorizons.core.config.listeners.ConfigChangeListener;
import com.seibel.distanthorizons.core.config.listeners.IConfigListener;
import com.seibel.distanthorizons.core.config.types.AbstractConfigType;
import com.seibel.distanthorizons.core.config.types.enums.EConfigEntryAppearance;
import com.seibel.distanthorizons.core.config.types.enums.EConfigEntryPerformance;
import com.seibel.distanthorizons.coreapi.interfaces.config.IConfigEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class ConfigEntry<T>
extends AbstractConfigType<T, ConfigEntry<T>>
implements IConfigEntry<T> {
    private String comment;
    private T min;
    private T max;
    private final ArrayList<IConfigListener> listenerList;
    private final String chatCommandName;
    private final EConfigEntryPerformance performance;
    public final boolean allowApiOverride;
    @Nullable
    private T apiValue;

    private ConfigEntry(EConfigEntryAppearance appearance, T value, String comment, T min, T max, String chatCommandName, boolean allowApiOverride, EConfigEntryPerformance performance, ArrayList<IConfigListener> listenerList) {
        super(appearance, value);
        this.comment = comment;
        this.min = min;
        this.max = max;
        this.chatCommandName = chatCommandName;
        this.allowApiOverride = allowApiOverride;
        this.performance = performance;
        this.listenerList = listenerList;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setApiValue(T newApiValue) {
        this.apiValue = newApiValue;
        this.listenerList.forEach(IConfigListener::onConfigValueSet);
    }

    @Override
    public T getApiValue() {
        return this.apiValue;
    }

    @Override
    public boolean apiIsOverriding() {
        return this.allowApiOverride && this.apiValue != null;
    }

    @Override
    public boolean getAllowApiOverride() {
        return this.allowApiOverride;
    }

    public void pureSet(T newValue) {
        super.set(newValue);
    }

    @Override
    public void setWithoutSaving(T newValue) {
        super.set(newValue);
        this.listenerList.forEach(IConfigListener::onConfigValueSet);
    }

    @Override
    public void set(T newValue) {
        this.setWithoutSaving(newValue);
        this.save();
    }

    public void uiSetWithoutSaving(T newValue) {
        this.setWithoutSaving(newValue);
        this.listenerList.forEach(IConfigListener::onUiModify);
    }

    public void uiSet(T newValue) {
        this.set(newValue);
        this.listenerList.forEach(IConfigListener::onUiModify);
    }

    @Override
    public T get() {
        if (this.allowApiOverride && this.apiValue != null) {
            return this.apiValue;
        }
        return super.get();
    }

    @Override
    public T getTrueValue() {
        return super.get();
    }

    @Override
    public T getMin() {
        return this.min;
    }

    @Override
    public void setMin(T newMin) {
        this.min = newMin;
    }

    @Override
    public T getMax() {
        return this.max;
    }

    @Override
    public void setMax(T newMax) {
        this.max = newMax;
    }

    @Override
    public void setMinMax(T newMin, T newMax) {
        this.setMin(newMin);
        this.setMax(newMax);
    }

    public void clampWithinRange() {
        this.clampWithinRange(this.min, this.max);
    }

    public void clampWithinRange(T min, T max) {
        byte validness = this.isValid(min, max);
        if (validness == -1) {
            this.value = NumberUtil.getMinimum(this.value.getClass());
        }
        if (validness == 1) {
            this.value = NumberUtil.getMaximum(this.value.getClass());
        }
    }

    public String getChatCommandName() {
        return this.chatCommandName;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String newComment) {
        this.comment = newComment;
    }

    public EConfigEntryPerformance getPerformance() {
        return this.performance;
    }

    @Override
    public void addValueChangeListener(Consumer<T> onValueChangeFunc) {
        ConfigChangeListener<T> changeListener = new ConfigChangeListener<T>(this, onValueChangeFunc);
        this.addListener(changeListener);
    }

    public void addListener(IConfigListener newListener) {
        this.listenerList.add(newListener);
    }

    public void removeListener(IConfigListener oldListener) {
        this.listenerList.remove(oldListener);
    }

    public void clearListeners() {
        this.listenerList.clear();
    }

    public ArrayList<IConfigListener> getListeners() {
        return this.listenerList;
    }

    public void setListeners(ArrayList<IConfigListener> newListeners) {
        this.listenerList.clear();
        this.listenerList.addAll(newListeners);
    }

    public void setListeners(IConfigListener ... newListeners) {
        this.listenerList.addAll(Arrays.asList(newListeners));
    }

    @Override
    public byte isValid() {
        return this.isValid(this.value, this.min, this.max);
    }

    @Override
    public byte isValid(T value) {
        return this.isValid(value, this.min, this.max);
    }

    public byte isValid(T min, T max) {
        return this.isValid(this.value, min, max);
    }

    public byte isValid(T value, T min, T max) {
        if (this.configBase.disableMinMax) {
            return 0;
        }
        if (min == null && max == null) {
            return 0;
        }
        if (value == null || this.value == null || value.getClass() != this.value.getClass()) {
            return 2;
        }
        if (Number.class.isAssignableFrom(value.getClass())) {
            if (max != null && NumberUtil.greaterThan((Number)value, (Number)max)) {
                return 1;
            }
            if (min != null && NumberUtil.lessThan((Number)value, (Number)min)) {
                return -1;
            }
            return 0;
        }
        return 0;
    }

    public void save() {
        this.configBase.configFileHandler.saveEntry(this);
    }

    public void load() {
        this.configBase.configFileHandler.loadEntry(this);
    }

    @Override
    public boolean equals(IConfigEntry<?> obj) {
        return obj.getClass() == ConfigEntry.class && this.equals((ConfigEntry)obj);
    }

    @Override
    public boolean equals(ConfigEntry<?> obj) {
        if (Number.class.isAssignableFrom(this.value.getClass())) {
            return this.value == obj.value;
        }
        return this.value.equals(obj.value);
    }

    public static class Builder<T>
    extends AbstractConfigType.Builder<T, Builder<T>> {
        private String tmpComment = null;
        private T tmpMin = null;
        private T tmpMax = null;
        protected String tmpChatCommandName = null;
        private boolean tmpUseApiOverwrite = true;
        private EConfigEntryPerformance tmpPerformance = EConfigEntryPerformance.DONT_SHOW;
        protected ArrayList<IConfigListener> tmpIConfigListener = new ArrayList();

        public Builder<T> comment(String newComment) {
            this.tmpComment = newComment;
            return this;
        }

        public Builder<T> setMinDefaultMax(T newMin, T newDefault, T newMax) {
            this.set((Object)newDefault);
            this.setMinMax(newMin, newMax);
            return this;
        }

        public Builder<T> setMinMax(T newMin, T newMax) {
            this.tmpMin = newMin;
            this.tmpMax = newMax;
            return this;
        }

        public Builder<T> setMin(T newMin) {
            this.tmpMin = newMin;
            return this;
        }

        public Builder<T> setMax(T newMax) {
            this.tmpMax = newMax;
            return this;
        }

        public Builder<T> setChatCommandName(String name) {
            this.tmpChatCommandName = name;
            return this;
        }

        public Builder<T> setUseApiOverwrite(boolean newUseApiOverwrite) {
            this.tmpUseApiOverwrite = newUseApiOverwrite;
            return this;
        }

        public Builder<T> setPerformance(EConfigEntryPerformance newPerformance) {
            this.tmpPerformance = newPerformance;
            return this;
        }

        public Builder<T> replaceListeners(ArrayList<IConfigListener> newConfigListener) {
            this.tmpIConfigListener = newConfigListener;
            return this;
        }

        public Builder<T> addListeners(IConfigListener ... newConfigListener) {
            this.tmpIConfigListener.addAll(Arrays.asList(newConfigListener));
            return this;
        }

        public Builder<T> addListener(IConfigListener newConfigListener) {
            this.tmpIConfigListener.add(newConfigListener);
            return this;
        }

        public Builder<T> clearListeners() {
            this.tmpIConfigListener.clear();
            return this;
        }

        public ConfigEntry<T> build() {
            return new ConfigEntry(this.tmpAppearance, this.tmpValue, this.tmpComment, this.tmpMin, this.tmpMax, this.tmpChatCommandName, this.tmpUseApiOverwrite, this.tmpPerformance, this.tmpIConfigListener);
        }
    }
}

