/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.config.types;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.types.AbstractConfigType;
import com.seibel.distanthorizons.core.config.types.enums.EConfigCommentTextPosition;
import com.seibel.distanthorizons.core.config.types.enums.EConfigEntryAppearance;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigUIComment
extends AbstractConfigType<String, ConfigUIComment> {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public String parentConfigPath = null;
    @Nullable
    public EConfigCommentTextPosition textPosition = null;

    public ConfigUIComment() {
        this(null, null);
    }

    public ConfigUIComment(String parentConfigPath, EConfigCommentTextPosition textPosition) {
        super(EConfigEntryAppearance.ONLY_IN_GUI, "");
        this.parentConfigPath = parentConfigPath;
        this.textPosition = textPosition;
    }

    @Override
    public void setAppearance(EConfigEntryAppearance newAppearance) {
    }

    @Override
    public void set(String newValue) {
    }

    public static class Builder
    extends AbstractConfigType.Builder<String, Builder> {
        public String tempParentConfigPath = null;
        public EConfigCommentTextPosition tempTextPosition = null;

        @Override
        @Deprecated
        public Builder setAppearance(EConfigEntryAppearance newAppearance) {
            return this;
        }

        @Override
        @Deprecated
        public Builder set(String newValue) {
            return this;
        }

        public Builder setParentConfigClass(@NotNull Class<?> parentConfigClass) {
            String packageName = parentConfigClass.getPackage().getName();
            String fullName = parentConfigClass.getName();
            try {
                String configPath = fullName.substring(packageName.length() + 1 + Config.class.getSimpleName().length() + 1);
                this.tempParentConfigPath = Builder.convertPackageNameToLangPath(configPath);
            }
            catch (Exception e) {
                this.tempParentConfigPath = parentConfigClass.getSimpleName();
                LOGGER.warn("Failed to parse config class: [" + fullName + "], error: [" + e.getMessage() + "], defaulting to: [" + this.tempParentConfigPath + "].", (Throwable)e);
            }
            return this;
        }

        public static String convertPackageNameToLangPath(String input) {
            StringBuilder result = new StringBuilder(input.length());
            for (int i = 0; i < input.length(); ++i) {
                char ch = input.charAt(i);
                if (i == 0) {
                    result.append(Character.toLowerCase(ch));
                    continue;
                }
                if (ch == '$') {
                    result.append('.');
                    continue;
                }
                char lastCh = input.charAt(i - 1);
                if (lastCh == '$') {
                    result.append(Character.toLowerCase(ch));
                    continue;
                }
                result.append(ch);
            }
            return result.toString();
        }

        public Builder setTextPosition(EConfigCommentTextPosition textPosition) {
            this.tempTextPosition = textPosition;
            return this;
        }

        public ConfigUIComment build() {
            return new ConfigUIComment(this.tempParentConfigPath, this.tempTextPosition);
        }
    }
}

