/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file;

import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.file.IDataSource;
import com.seibel.distanthorizons.core.file.structure.ISaveStructure;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.sql.dto.IBaseDTO;
import com.seibel.distanthorizons.core.sql.repo.AbstractDhRepo;
import com.seibel.distanthorizons.core.util.objects.DataCorruptedException;
import com.seibel.distanthorizons.core.util.threading.PositionalLockProvider;
import com.seibel.distanthorizons.core.util.threading.PriorityTaskPicker;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDataSourceHandler<TDataSource extends IDataSource<TDhLevel>, TDTO extends IBaseDTO<Long>, TRepo extends AbstractDhRepo<Long, TDTO>, TDhLevel extends IDhLevel>
implements AutoCloseable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final Set<String> CORRUPT_DATA_ERRORS_LOGGED = Collections.newSetFromMap(new ConcurrentHashMap());
    public static final byte TOP_SECTION_DETAIL_LEVEL = 15;
    public static final byte MIN_SECTION_DETAIL_LEVEL = 6;
    protected final PositionalLockProvider updateLockProvider = new PositionalLockProvider();
    public final Set<Long> lockedPosSet = ConcurrentHashMap.newKeySet();
    public final ConcurrentHashMap<Long, AtomicInteger> queuedUpdateCountsByPos = new ConcurrentHashMap();
    protected final ReentrantLock closeLock = new ReentrantLock();
    protected volatile boolean isShutdown = false;
    protected final TDhLevel level;
    protected final File saveDir;
    public final TRepo repo;
    public final ArrayList<IDataSourceUpdateFunc<TDataSource>> dateSourceUpdateListeners = new ArrayList();

    public AbstractDataSourceHandler(TDhLevel level, ISaveStructure saveStructure) {
        this(level, saveStructure, null);
    }

    public AbstractDataSourceHandler(TDhLevel level, ISaveStructure saveStructure, @Nullable File saveDirOverride) {
        this.level = level;
        this.saveDir = saveDirOverride == null ? saveStructure.getSaveFolder(level.getLevelWrapper()) : saveDirOverride;
        this.repo = this.createRepo();
    }

    protected abstract TRepo createRepo();

    protected abstract TDataSource createDataSourceFromDto(TDTO var1) throws InterruptedException, IOException, DataCorruptedException;

    protected abstract TDTO createDtoFromDataSource(TDataSource var1);

    protected abstract TDataSource makeEmptyDataSource(long var1);

    public CompletableFuture<TDataSource> getAsync(long pos) {
        PriorityTaskPicker.Executor executor = ThreadPoolUtil.getFileHandlerExecutor();
        if (executor == null || executor.isTerminated()) {
            return CompletableFuture.completedFuture(null);
        }
        try {
            return CompletableFuture.supplyAsync(() -> this.get(pos), executor);
        }
        catch (RejectedExecutionException ignore) {
            return CompletableFuture.completedFuture(null);
        }
    }

    @Nullable
    public TDataSource get(long pos) {
        TDataSource dataSource = null;
        try (Object dto2 = ((AbstractDhRepo)this.repo).getByKey(pos);){
            if (dto2 != null) {
                try {
                    dataSource = this.createDataSourceFromDto(dto2);
                }
                catch (DataCorruptedException e) {
                    String message;
                    String string = message = e.getMessage() == null ? e.getMessage() : "No Error message for exception [" + e.getClass().getSimpleName() + "]";
                    if (CORRUPT_DATA_ERRORS_LOGGED.add(message)) {
                        LOGGER.warn("Corrupted data found at pos [" + DhSectionPos.toString(pos) + "]. Data at position will be deleted so it can be re-generated to prevent issues. Future errors with this same message won't be logged. Error: [" + message + "].", (Throwable)e);
                    }
                    ((AbstractDhRepo)this.repo).deleteWithKey(pos);
                }
            } else {
                dataSource = this.makeEmptyDataSource(pos);
            }
        }
        catch (InterruptedException dto2) {
        }
        catch (IOException e) {
            LOGGER.warn("File read Error for pos [" + DhSectionPos.toString(pos) + "], error: " + e.getMessage(), (Throwable)e);
        }
        return dataSource;
    }

    public void updateDataSource(@NotNull FullDataSourceV2 inputDataSource) {
        this.updateDataSourceAtPos(inputDataSource.getPos(), inputDataSource, true);
    }

    public CompletableFuture<Void> updateDataSourceAsync(@NotNull FullDataSourceV2 inputDataSource) {
        PriorityTaskPicker.Executor executor = ThreadPoolUtil.getChunkToLodBuilderExecutor();
        if (executor == null || executor.isTerminated()) {
            return CompletableFuture.completedFuture(null);
        }
        try {
            this.markUpdateStart(inputDataSource.getPos());
            return CompletableFuture.runAsync(() -> {
                try {
                    this.updateDataSourceAtPos(inputDataSource.getPos(), inputDataSource, true);
                }
                catch (Exception e) {
                    LOGGER.error("Unexpected error in async data source update at pos: [" + DhSectionPos.toString(inputDataSource.getPos()) + "], error: [" + e.getMessage() + "].", (Throwable)e);
                }
                finally {
                    this.markUpdateEnd(inputDataSource.getPos());
                }
            }, executor);
        }
        catch (RejectedExecutionException ignore) {
            this.markUpdateEnd(inputDataSource.getPos());
            return CompletableFuture.completedFuture(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDataSourceAtPos(long updatePos, @NotNull FullDataSourceV2 inputData, boolean lockOnUpdatePos) {
        block20: {
            boolean methodLocked = false;
            ReentrantLock updateLock = this.updateLockProvider.getLock(updatePos);
            try {
                if (lockOnUpdatePos) {
                    methodLocked = true;
                    updateLock.lock();
                    this.lockedPosSet.add(updatePos);
                }
                try (TDataSource recipientDataSource = this.get(updatePos);){
                    boolean dataModified;
                    if (recipientDataSource == null || !(dataModified = recipientDataSource.update(inputData, this.level))) break block20;
                    try (TDTO dto = this.createDtoFromDataSource(recipientDataSource);){
                        ((AbstractDhRepo)this.repo).save(dto);
                    }
                    for (IDataSourceUpdateFunc<TDataSource> listener : this.dateSourceUpdateListeners) {
                        if (listener == null) continue;
                        listener.OnDataSourceUpdated(recipientDataSource);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error updating pos [" + DhSectionPos.toString(updatePos) + "], error: " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (methodLocked) {
                    updateLock.unlock();
                    this.lockedPosSet.remove(updatePos);
                }
            }
        }
    }

    private void markUpdateStart(long dataSourcePos) {
        this.queuedUpdateCountsByPos.compute(dataSourcePos, (pos, atomicCount) -> {
            if (atomicCount == null) {
                atomicCount = new AtomicInteger(0);
            }
            atomicCount.incrementAndGet();
            return atomicCount;
        });
    }

    private void markUpdateEnd(long dataSourcePos) {
        this.queuedUpdateCountsByPos.compute(dataSourcePos, (pos, atomicCount) -> {
            if (atomicCount != null && atomicCount.decrementAndGet() <= 0) {
                atomicCount = null;
            }
            return atomicCount;
        });
    }

    @Override
    public void close() {
        try {
            this.closeLock.lock();
            this.isShutdown = true;
            Thread.sleep(200L);
            LOGGER.info("Closing [" + this.getClass().getSimpleName() + "] for level: [" + this.level + "].");
            ((AbstractDhRepo)this.repo).close();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.closeLock.unlock();
        }
    }

    @FunctionalInterface
    public static interface IDataSourceUpdateFunc<TDataSource> {
        public void OnDataSourceUpdated(TDataSource var1);
    }
}

