/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.seibel.distanthorizons.core.config.ConfigHandler;
import com.seibel.distanthorizons.core.config.types.AbstractConfigBase;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;
import loaderCommon.fabric.com.seibel.distanthorizons.common.commands.AbstractCommand;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class ConfigCommand
extends AbstractCommand {
    private static final List<CommandArgumentData<?>> commandArguments = Arrays.asList(new CommandArgumentData<Integer>(Integer.class, configEntry -> IntegerArgumentType.integer((int)((Integer)configEntry.getMin()), (int)((Integer)configEntry.getMax())), IntegerArgumentType::getInteger), new CommandArgumentData<Double>(Double.class, configEntry -> DoubleArgumentType.doubleArg((double)((Double)configEntry.getMin()), (double)((Double)configEntry.getMax())), DoubleArgumentType::getDouble), new CommandArgumentData<Boolean>(Boolean.class, BoolArgumentType::bool, BoolArgumentType::getBool), new CommandArgumentData<String>(String.class, StringArgumentType::string, StringArgumentType::getString));

    @Override
    public LiteralArgumentBuilder<class_2168> buildCommand() {
        LiteralArgumentBuilder builder = class_2170.method_9247((String)"config");
        HashSet<String> addedCommands = new HashSet<String>();
        for (AbstractConfigBase<?> type : ConfigHandler.INSTANCE.configBaseList) {
            ConfigEntry configEntry;
            if (!(type instanceof ConfigEntry) || (configEntry = (ConfigEntry)type).getChatCommandName() == null) continue;
            if (!addedCommands.add(configEntry.getChatCommandName())) {
                throw new IllegalStateException("Duplicate command name: " + configEntry.getChatCommandName());
            }
            LiteralArgumentBuilder subcommand = (LiteralArgumentBuilder)class_2170.method_9247((String)configEntry.getChatCommandName()).executes(commandContext -> this.sendSuccessResponse((CommandContext<class_2168>)commandContext, "\nDescription of \u00a7l" + configEntry.getChatCommandName() + "\u00a7r:\n\u00a7o" + configEntry.getComment().trim() + "\u00a7r\n\u00a77Config file name: \u00a7f" + configEntry.name + "\u00a77, category: \u00a7f" + configEntry.category + "\n\nCurrent value of " + configEntry.getChatCommandName() + " is \u00a7n" + String.valueOf(configEntry.get()) + "\u00a7r", false));
            ToIntBiFunction<CommandContext, Object> updateConfigValue = (commandContext, value) -> {
                configEntry.set(value);
                return this.sendSuccessResponse((CommandContext<class_2168>)commandContext, "Changed the value of [" + configEntry.getChatCommandName() + "] to [" + String.valueOf(value) + "]", true);
            };
            if (Enum.class.isAssignableFrom(configEntry.getType())) {
                for (Object choice : configEntry.getType().getEnumConstants()) {
                    subcommand.then(class_2170.method_9247((String)choice.toString()).executes(c -> updateConfigValue.applyAsInt(c, choice)));
                }
            } else {
                boolean setterAdded = false;
                for (CommandArgumentData<?> commandArgumentData : commandArguments) {
                    if (!commandArgumentData.argumentClass.isAssignableFrom(configEntry.getType())) continue;
                    subcommand.then(class_2170.method_9244((String)"value", commandArgumentData.getArgumentType(configEntry)).executes(c -> updateConfigValue.applyAsInt(c, commandArgumentData.getValue((CommandContext<class_2168>)c, "value"))));
                    setterAdded = true;
                    break;
                }
                if (!setterAdded) {
                    throw new RuntimeException("Config type of " + type.getName() + " is not supported: " + configEntry.getType().getSimpleName());
                }
            }
            builder.then((ArgumentBuilder)subcommand);
        }
        return builder;
    }

    private static class CommandArgumentData<T> {
        public final Class<T> argumentClass;
        public final Function<ConfigEntry<T>, ArgumentType<T>> argumentTypeFunction;
        private final BiFunction<CommandContext<class_2168>, String, T> valueGetter;

        public CommandArgumentData(Class<T> argumentClass, Supplier<ArgumentType<T>> argumentTypeSupplier, BiFunction<CommandContext<class_2168>, String, T> valueGetter) {
            this(argumentClass, (ConfigEntry<T> configEntry) -> (ArgumentType)argumentTypeSupplier.get(), valueGetter);
        }

        public CommandArgumentData(Class<T> argumentClass, Function<ConfigEntry<T>, ArgumentType<T>> argumentTypeFunction, BiFunction<CommandContext<class_2168>, String, T> valueGetter) {
            this.argumentClass = argumentClass;
            this.argumentTypeFunction = argumentTypeFunction;
            this.valueGetter = valueGetter;
        }

        public ArgumentType<T> getArgumentType(ConfigEntry<T> configEntry) {
            return this.argumentTypeFunction.apply(configEntry);
        }

        public T getValue(CommandContext<class_2168> commandContext, String argumentName) {
            return this.valueGetter.apply(commandContext, argumentName);
        }
    }
}

