/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnnotationUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    public static <TEnum extends Enum<?>, TAnno extends Annotation> boolean doesEnumHaveAnnotation(TEnum enumValue, Class<TAnno> annotationToSearchFor) {
        try {
            Field[] fields;
            for (Field field : fields = enumValue.getClass().getFields()) {
                Enum testEnumValue = (Enum)field.get(enumValue);
                if (testEnumValue != enumValue) continue;
                return field.getAnnotation(annotationToSearchFor) != null;
            }
            throw new IllegalStateException("Enum missing expected value. Enum: [" + enumValue.getClass() + "] doesn't contain the value: [" + enumValue.name() + "].");
        }
        catch (ClassCastException | IllegalAccessException | IllegalArgumentException e) {
            LOGGER.error("Unable to get annotation for enum: [" + enumValue.getClass() + "]. Unexpected exception: [" + e + "], message: [" + e.getMessage() + "].", (Throwable)e);
            return false;
        }
    }
}

