/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.lzma;

import java.io.IOException;
import org.tukaani.xz.lz.LZDecoder;
import org.tukaani.xz.lzma.LZMACoder;
import org.tukaani.xz.rangecoder.RangeDecoder;

public final class LZMADecoder
extends LZMACoder {
    private final LZDecoder lz;
    private final RangeDecoder rc;
    private final LiteralDecoder literalDecoder;
    private final LengthDecoder matchLenDecoder = new LengthDecoder();
    private final LengthDecoder repLenDecoder = new LengthDecoder();

    public LZMADecoder(LZDecoder lZDecoder, RangeDecoder rangeDecoder, int i, int j, int k) {
        super(k);
        this.lz = lZDecoder;
        this.rc = rangeDecoder;
        this.literalDecoder = new LiteralDecoder(i, j);
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.literalDecoder.reset();
        this.matchLenDecoder.reset();
        this.repLenDecoder.reset();
    }

    public boolean endMarkerDetected() {
        return this.reps[0] == -1;
    }

    public void decode() throws IOException {
        this.lz.repeatPending();
        while (this.lz.hasSpace()) {
            int n = this.lz.getPos() & this.posMask;
            if (this.rc.decodeBit(this.isMatch[this.state.get()], n) == 0) {
                this.literalDecoder.decode();
                continue;
            }
            int n2 = this.rc.decodeBit(this.isRep, this.state.get()) == 0 ? this.decodeMatch(n) : this.decodeRepMatch(n);
            this.lz.repeat(this.reps[0], n2);
        }
        this.rc.normalize();
    }

    private int decodeMatch(int i) throws IOException {
        this.state.updateMatch();
        this.reps[3] = this.reps[2];
        this.reps[2] = this.reps[1];
        this.reps[1] = this.reps[0];
        int n = this.matchLenDecoder.decode(i);
        int n2 = this.rc.decodeBitTree(this.distSlots[LZMADecoder.getDistState(n)]);
        if (n2 < 4) {
            this.reps[0] = n2;
        } else {
            int n3 = (n2 >> 1) - 1;
            this.reps[0] = (2 | n2 & 1) << n3;
            if (n2 < 14) {
                this.reps[0] = this.reps[0] | this.rc.decodeReverseBitTree(this.distSpecial[n2 - 4]);
            } else {
                this.reps[0] = this.reps[0] | this.rc.decodeDirectBits(n3 - 4) << 4;
                this.reps[0] = this.reps[0] | this.rc.decodeReverseBitTree(this.distAlign);
            }
        }
        return n;
    }

    private int decodeRepMatch(int i) throws IOException {
        if (this.rc.decodeBit(this.isRep0, this.state.get()) == 0) {
            if (this.rc.decodeBit(this.isRep0Long[this.state.get()], i) == 0) {
                this.state.updateShortRep();
                return 1;
            }
        } else {
            int n;
            if (this.rc.decodeBit(this.isRep1, this.state.get()) == 0) {
                n = this.reps[1];
            } else {
                if (this.rc.decodeBit(this.isRep2, this.state.get()) == 0) {
                    n = this.reps[2];
                } else {
                    n = this.reps[3];
                    this.reps[3] = this.reps[2];
                }
                this.reps[2] = this.reps[1];
            }
            this.reps[1] = this.reps[0];
            this.reps[0] = n;
        }
        this.state.updateLongRep();
        return this.repLenDecoder.decode(i);
    }

    private class LengthDecoder
    extends LZMACoder.LengthCoder {
        private LengthDecoder() {
            super(LZMADecoder.this);
        }

        int decode(int i) throws IOException {
            if (LZMADecoder.this.rc.decodeBit(this.choice, 0) == 0) {
                return LZMADecoder.this.rc.decodeBitTree(this.low[i]) + 2;
            }
            if (LZMADecoder.this.rc.decodeBit(this.choice, 1) == 0) {
                return LZMADecoder.this.rc.decodeBitTree(this.mid[i]) + 2 + 8;
            }
            return LZMADecoder.this.rc.decodeBitTree(this.high) + 2 + 8 + 8;
        }
    }

    private class LiteralDecoder
    extends LZMACoder.LiteralCoder {
        private final LiteralSubdecoder[] subdecoders;

        LiteralDecoder(int i, int j) {
            super(LZMADecoder.this, i, j);
            this.subdecoders = new LiteralSubdecoder[1 << i + j];
            for (int k = 0; k < this.subdecoders.length; ++k) {
                this.subdecoders[k] = new LiteralSubdecoder();
            }
        }

        void reset() {
            for (int i = 0; i < this.subdecoders.length; ++i) {
                this.subdecoders[i].reset();
            }
        }

        void decode() throws IOException {
            int n = this.getSubcoderIndex(LZMADecoder.this.lz.getByte(0), LZMADecoder.this.lz.getPos());
            this.subdecoders[n].decode();
        }

        private class LiteralSubdecoder
        extends LZMACoder.LiteralCoder.LiteralSubcoder {
            private LiteralSubdecoder() {
                super(LiteralDecoder.this);
            }

            void decode() throws IOException {
                int n = 1;
                if (LZMADecoder.this.state.isLiteral()) {
                    while ((n = n << 1 | LZMADecoder.this.rc.decodeBit(this.probs, n)) < 256) {
                    }
                } else {
                    int n2 = LZMADecoder.this.lz.getByte(LZMADecoder.this.reps[0]);
                    int n3 = 256;
                    do {
                        int n4 = (n2 <<= 1) & n3;
                        int n5 = LZMADecoder.this.rc.decodeBit(this.probs, n3 + n4 + n);
                        n = n << 1 | n5;
                        n3 &= 0 - n5 ^ ~n4;
                    } while (n < 256);
                }
                LZMADecoder.this.lz.putByte((byte)n);
                LZMADecoder.this.state.updateLiteral();
            }
        }
    }
}

