/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.jar.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class JSwitchBox
extends AbstractButton {
    private Color shadow1 = UIManager.getColor("controlHighlight");
    private Color shadow2 = UIManager.getColor("control");
    private Color colorBright = UIManager.getColor("Button.light");
    private Color red = UIManager.getColor("controlShadow");
    private Color redf = UIManager.getColor("Button.foreground");
    private Color trackBackground = UIManager.getColor("textHighlight");
    private Color trackBackgroundText = UIManager.getColor("textHighlightText");
    private Border buttonBorder = UIManager.getBorder("Button.border");
    private Border trackBorder = UIManager.getBorder("Button.border");
    private Font font = new JLabel().getFont();
    private int gap = 5;
    private int globalWitdh = 0;
    private final String trueLabel;
    private final String falseLabel;
    private Dimension thumbBounds;
    private Rectangle2D bounds;
    private int max;

    public JSwitchBox(String trueLabel, String falseLabel) {
        this.setBackground(UIManager.getColor("Panel.background"));
        this.trueLabel = trueLabel;
        this.falseLabel = falseLabel;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        double trueLenth = fontMetrics.getStringBounds(trueLabel, this.getGraphics()).getWidth();
        double falseLenght = fontMetrics.getStringBounds(falseLabel, this.getGraphics()).getWidth();
        this.max = (int)Math.max(trueLenth, falseLenght);
        this.gap = Math.max(5, 5 + (int)Math.abs(trueLenth - falseLenght));
        this.thumbBounds = new Dimension(this.max + this.gap * 2, (int)((double)fontMetrics.getHeight() * 1.5));
        this.globalWitdh = this.max + this.thumbBounds.width + this.gap * 2;
        this.setModel(new DefaultButtonModel());
        this.setSelected(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (new Rectangle(JSwitchBox.this.getPreferredSize()).contains(e.getPoint())) {
                    JSwitchBox.this.setSelected(!JSwitchBox.this.isSelected());
                }
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.globalWitdh, this.thumbBounds.height);
    }

    @Override
    public void setSelected(boolean b) {
        if (b) {
            this.setText(this.trueLabel);
            this.setBackground(this.trackBackground);
            this.setForeground(this.trackBackgroundText);
        } else {
            this.setBackground(this.red);
            this.setForeground(this.redf);
            this.setText(this.falseLabel);
        }
        super.setSelected(b);
    }

    @Override
    public void setText(String text) {
        super.setText(text);
    }

    @Override
    public int getHeight() {
        return this.getPreferredSize().height;
    }

    @Override
    public int getWidth() {
        return this.getPreferredSize().width;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight() - 4);
        Graphics2D g2 = (Graphics2D)g;
        this.trackBorder.paintBorder(this, g2, 0, 2, this.getWidth(), this.getHeight() - 4);
        int buttonX = 0;
        int textX = 0;
        if (this.isSelected()) {
            textX = this.thumbBounds.width;
        } else {
            buttonX = this.thumbBounds.width;
        }
        int y = 0;
        int w = this.thumbBounds.width;
        int h = this.thumbBounds.height;
        g2.setPaint(new GradientPaint(buttonX, (int)((double)y - 0.1 * (double)h), this.shadow2, buttonX, (int)((double)y + 1.2 * (double)h), this.shadow1));
        g2.fillRect(buttonX, y, w, h);
        g2.setPaint(new GradientPaint(buttonX, (int)((double)y + 0.65 * (double)h), this.shadow1, buttonX, (int)((double)y + 1.3 * (double)h), this.shadow2));
        g2.fillRect(buttonX, (int)((double)y + 0.65 * (double)h), w, (int)((double)h - 0.65 * (double)h));
        if (w > 14) {
            int size = 10;
            g2.setColor(this.colorBright);
            g2.fillRect(buttonX + w / 2 - size / 2, y + h / 2 - size / 2, size, size);
            g2.setColor(this.colorBright.darker());
            g2.fillRect(buttonX + w / 2 - 4, h / 2 - 4, 2, 2);
            g2.fillRect(buttonX + w / 2 - 1, h / 2 - 4, 2, 2);
            g2.fillRect(buttonX + w / 2 + 2, h / 2 - 4, 2, 2);
            g2.setColor(this.colorBright.darker().darker());
            g2.fillRect(buttonX + w / 2 - 4, h / 2 - 2, 2, 6);
            g2.fillRect(buttonX + w / 2 - 1, h / 2 - 2, 2, 6);
            g2.fillRect(buttonX + w / 2 + 2, h / 2 - 2, 2, 6);
            g2.setColor(this.colorBright.darker());
            g2.fillRect(buttonX + w / 2 - 4, h / 2 + 2, 2, 2);
            g2.fillRect(buttonX + w / 2 - 1, h / 2 + 2, 2, 2);
            g2.fillRect(buttonX + w / 2 + 2, h / 2 + 2, 2, 2);
        }
        this.buttonBorder.paintBorder(this, g2, buttonX, y, w, h);
        g2.setColor(this.getForeground());
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setFont(this.getFont());
        g2.drawString(this.getText(), textX + this.gap, y + h / 2 + h / 4);
    }
}

