/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block;

import com.google.common.collect.ImmutableList;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiBlockMaterial;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_4275;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class BlockStateWrapper
implements IBlockStateWrapper {
    public static final String RESOURCE_LOCATION_SEPARATOR = ":";
    public static final String STATE_STRING_SEPARATOR = "_STATE_";
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final ConcurrentHashMap<class_2680, BlockStateWrapper> WRAPPER_BY_BLOCK_STATE = new ConcurrentHashMap();
    public static final ConcurrentHashMap<String, BlockStateWrapper> WRAPPER_BY_RESOURCE_LOCATION = new ConcurrentHashMap();
    public static final String AIR_STRING = "AIR";
    public static final BlockStateWrapper AIR = new BlockStateWrapper(null, null);
    public static final String DIRT_RESOURCE_LOCATION_STRING = "minecraft:dirt";
    public static final String WATER_RESOURCE_LOCATION_STRING = "minecraft:water";
    public static HashSet<IBlockStateWrapper> rendererIgnoredBlocks = null;
    public static HashSet<IBlockStateWrapper> rendererIgnoredCaveBlocks = null;
    private static final HashSet<class_2960> BROKEN_RESOURCE_LOCATIONS = new HashSet();
    @Nullable
    public final class_2680 blockState;
    private String serialString;
    private final int hashCode;
    private final int opacity;
    private byte blockMaterialId = 0;
    private final boolean isBeaconBlock;
    private final boolean isBeaconBaseBlock;
    private final boolean allowsBeaconBeamPassage;
    private final Color beaconTintColor;
    private final Color mapColor;

    public static BlockStateWrapper fromBlockState(class_2680 blockState, ILevelWrapper levelWrapper) {
        if (blockState == null || blockState.method_26215()) {
            return AIR;
        }
        if (WRAPPER_BY_BLOCK_STATE.containsKey(blockState)) {
            return WRAPPER_BY_BLOCK_STATE.get(blockState);
        }
        BlockStateWrapper newWrapper = new BlockStateWrapper(blockState, levelWrapper);
        WRAPPER_BY_BLOCK_STATE.put(blockState, newWrapper);
        return newWrapper;
    }

    public static BlockStateWrapper fromBlockState(class_2680 blockState, ILevelWrapper levelWrapper, IBlockStateWrapper guess) {
        class_2680 inputBlockState;
        class_2680 guessBlockState = guess == null || guess.isAir() ? null : (class_2680)guess.getWrappedMcObject();
        class_2680 class_26802 = inputBlockState = blockState == null || blockState.method_26215() ? null : blockState;
        if (guess instanceof BlockStateWrapper && guessBlockState == inputBlockState) {
            return (BlockStateWrapper)guess;
        }
        return BlockStateWrapper.fromBlockState(blockState, levelWrapper);
    }

    private BlockStateWrapper(class_2680 blockState, ILevelWrapper levelWrapper) {
        boolean allowsBeaconBeamPassage;
        class_2248 block;
        this.blockState = blockState;
        this.serialString = this.serialize(levelWrapper);
        this.hashCode = Objects.hash(this.serialString);
        this.blockMaterialId = this.calculateEDhApiBlockMaterialId().index;
        this.opacity = this.calculateOpacity();
        String lowercaseSerial = this.serialString.toLowerCase();
        boolean isBeaconBaseBlock = false;
        for (int i = 0; i < LodUtil.BEACON_BASE_BLOCK_NAME_LIST.size(); ++i) {
            String baseBlockName = LodUtil.BEACON_BASE_BLOCK_NAME_LIST.get(i);
            if (!lowercaseSerial.contains(baseBlockName)) continue;
            isBeaconBaseBlock = true;
            break;
        }
        this.isBeaconBaseBlock = isBeaconBaseBlock;
        this.isBeaconBlock = lowercaseSerial.contains("minecraft:beacon");
        Color beaconTintColor = null;
        if (this.blockState != null && !this.isBeaconBlock && (block = this.blockState.method_26204()) instanceof class_4275) {
            int colorInt = ((class_4275)block).method_10622().method_7794().field_16011;
            beaconTintColor = ColorUtil.toColorObjRGB(colorInt);
        }
        this.beaconTintColor = beaconTintColor;
        if (this.blockState != null) {
            boolean canOcclude = this.getCanOcclude();
            boolean propagatesSkyLightDown = this.getPropagatesSkyLightDown();
            allowsBeaconBeamPassage = lowercaseSerial.contains("minecraft:bedrock") ? true : (propagatesSkyLightDown || !canOcclude ? true : this.opacity != 16);
        } else {
            allowsBeaconBeamPassage = true;
        }
        this.allowsBeaconBeamPassage = allowsBeaconBeamPassage;
        int mcColor = 0;
        if (this.blockState != null) {
            mcColor = this.blockState.method_26207().method_15803().field_16011;
            this.mapColor = ColorUtil.toColorObjRGB(mcColor);
        } else {
            this.mapColor = new Color(0, 0, 0, 0);
        }
    }

    public static HashSet<IBlockStateWrapper> getRendererIgnoredBlocks(ILevelWrapper levelWrapper) {
        if (rendererIgnoredBlocks != null) {
            return rendererIgnoredBlocks;
        }
        HashSet<String> baseIgnoredBlock = new HashSet<String>();
        baseIgnoredBlock.add(AIR_STRING);
        rendererIgnoredBlocks = BlockStateWrapper.getBlockWrappers(Config.Client.Advanced.Graphics.Culling.ignoredRenderBlockCsv, baseIgnoredBlock, levelWrapper);
        return rendererIgnoredBlocks;
    }

    public static HashSet<IBlockStateWrapper> getRendererIgnoredCaveBlocks(ILevelWrapper levelWrapper) {
        if (rendererIgnoredCaveBlocks != null) {
            return rendererIgnoredCaveBlocks;
        }
        HashSet<String> baseIgnoredBlock = new HashSet<String>();
        baseIgnoredBlock.add(AIR_STRING);
        rendererIgnoredCaveBlocks = BlockStateWrapper.getBlockWrappers(Config.Client.Advanced.Graphics.Culling.ignoredRenderCaveBlockCsv, baseIgnoredBlock, levelWrapper);
        return rendererIgnoredCaveBlocks;
    }

    public static void clearRendererIgnoredBlocks() {
        rendererIgnoredBlocks = null;
    }

    public static void clearRendererIgnoredCaveBlocks() {
        rendererIgnoredCaveBlocks = null;
    }

    private static HashSet<IBlockStateWrapper> getBlockWrappers(ConfigEntry<String> config, HashSet<String> baseResourceLocations, ILevelWrapper levelWrapper) {
        String ignoreBlockCsv;
        HashSet<String> blockStringList = new HashSet<String>();
        if (baseResourceLocations != null) {
            blockStringList.addAll(baseResourceLocations);
        }
        if ((ignoreBlockCsv = config.get()) != null) {
            blockStringList.addAll(Arrays.asList(ignoreBlockCsv.split(",")));
        }
        return BlockStateWrapper.getBlockWrappers(blockStringList, levelWrapper);
    }

    private static HashSet<IBlockStateWrapper> getBlockWrappers(HashSet<String> blockResourceLocationSet, ILevelWrapper levelWrapper) {
        HashSet<IBlockStateWrapper> blockStateWrappers = new HashSet<IBlockStateWrapper>();
        for (String blockResourceLocation : blockResourceLocationSet) {
            try {
                String cleanedResourceLocation;
                if (blockResourceLocation == null || (cleanedResourceLocation = blockResourceLocation.trim()).length() == 0) continue;
                BlockStateWrapper defaultBlockStateToIgnore = (BlockStateWrapper)BlockStateWrapper.deserialize(cleanedResourceLocation, levelWrapper);
                blockStateWrappers.add(defaultBlockStateToIgnore);
                if (defaultBlockStateToIgnore != AIR) {
                    ImmutableList blockStatesToIgnore = defaultBlockStateToIgnore.blockState.method_26204().method_9595().method_11662();
                    for (class_2680 blockState : blockStatesToIgnore) {
                        BlockStateWrapper newBlockToIgnore = BlockStateWrapper.fromBlockState(blockState, levelWrapper);
                        blockStateWrappers.add(newBlockToIgnore);
                    }
                    continue;
                }
                blockStateWrappers.add(AIR);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to deserialize block with the resource location: [" + blockResourceLocation + "]. Error: " + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.warn("Unexpected error deserializing block with the resource location: [" + blockResourceLocation + "]. Error: " + e.getMessage(), (Throwable)e);
            }
        }
        return blockStateWrappers;
    }

    @Override
    public int getOpacity() {
        return this.opacity;
    }

    private int calculateOpacity() {
        boolean canOcclude = this.getCanOcclude();
        boolean propagatesSkyLightDown = this.getPropagatesSkyLightDown();
        int opacity = this.isAir() ? 0 : (this.isLiquid() && !canOcclude ? 1 : (propagatesSkyLightDown && !canOcclude ? 0 : 16));
        return opacity;
    }

    private boolean getCanOcclude() {
        boolean canOcclude = false;
        if (this.blockState != null) {
            canOcclude = this.blockState.method_26225();
        }
        return canOcclude;
    }

    private boolean getPropagatesSkyLightDown() {
        boolean propagatesSkyLightDown = true;
        if (this.blockState != null) {
            propagatesSkyLightDown = this.blockState.method_26167((class_1922)class_2682.field_12294, class_2338.field_10980);
        }
        return propagatesSkyLightDown;
    }

    @Override
    public int getLightEmission() {
        return this.blockState != null ? this.blockState.method_26213() : 0;
    }

    @Override
    public String getSerialString() {
        return this.serialString;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlockStateWrapper that = (BlockStateWrapper)obj;
        return Objects.equals(this.getSerialString(), that.getSerialString());
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public Object getWrappedMcObject() {
        return this.blockState;
    }

    @Override
    public boolean isAir() {
        return this.isAir(this.blockState);
    }

    public boolean isAir(class_2680 blockState) {
        return blockState == null || blockState.method_26215();
    }

    @Override
    public boolean isSolid() {
        if (this.isAir()) {
            return false;
        }
        return this.blockState.method_26207().method_15799();
    }

    @Override
    public boolean isLiquid() {
        if (this.isAir()) {
            return false;
        }
        return this.blockState.method_26207().method_15797() || !this.blockState.method_26227().method_15769();
    }

    @Override
    public boolean isBeaconBlock() {
        return this.isBeaconBlock;
    }

    @Override
    public boolean isBeaconBaseBlock() {
        return this.isBeaconBaseBlock;
    }

    @Override
    public boolean isBeaconTintBlock() {
        return this.beaconTintColor != null;
    }

    @Override
    public boolean allowsBeaconBeamPassage() {
        return this.allowsBeaconBeamPassage;
    }

    @Override
    public Color getMapColor() {
        return this.mapColor;
    }

    @Override
    public Color getBeaconTintColor() {
        return this.beaconTintColor;
    }

    @Override
    public byte getMaterialId() {
        return this.blockMaterialId;
    }

    public String toString() {
        return this.getSerialString();
    }

    private String serialize(ILevelWrapper levelWrapper) {
        if (this.blockState == null) {
            return AIR_STRING;
        }
        class_1937 level = (class_1937)levelWrapper.getWrappedMcObject();
        class_5455 registryAccess = level.method_30349();
        class_2960 resourceLocation = registryAccess.method_30530(class_7924.field_41254).method_10221((Object)this.blockState.method_26204());
        if (resourceLocation == null) {
            LOGGER.warn("No ResourceLocation found, unable to serialize: " + String.valueOf(this.blockState));
            return AIR_STRING;
        }
        this.serialString = resourceLocation.method_12836() + RESOURCE_LOCATION_SEPARATOR + resourceLocation.method_12832() + STATE_STRING_SEPARATOR + BlockStateWrapper.serializeBlockStateProperties(this.blockState);
        return this.serialString;
    }

    public static IBlockStateWrapper deserialize(String resourceStateString, ILevelWrapper levelWrapper) throws IOException {
        String finalResourceStateString = resourceStateString;
        if (finalResourceStateString.equals(AIR_STRING) || finalResourceStateString.equals("")) {
            return AIR;
        }
        if (WRAPPER_BY_RESOURCE_LOCATION.containsKey(finalResourceStateString)) {
            return WRAPPER_BY_RESOURCE_LOCATION.get(finalResourceStateString);
        }
        BlockStateWrapper foundWrapper = AIR;
        try {
            class_2680 foundState;
            class_2248 block;
            class_2960 resourceLocation;
            String blockStatePropertiesString;
            block18: {
                int separatorIndex;
                blockStatePropertiesString = null;
                int stateSeparatorIndex = resourceStateString.indexOf(STATE_STRING_SEPARATOR);
                if (stateSeparatorIndex != -1) {
                    blockStatePropertiesString = resourceStateString.substring(stateSeparatorIndex + STATE_STRING_SEPARATOR.length());
                    resourceStateString = resourceStateString.substring(0, stateSeparatorIndex);
                }
                if ((separatorIndex = resourceStateString.indexOf(RESOURCE_LOCATION_SEPARATOR)) == -1) {
                    throw new IOException("Unable to parse Resource Location out of string: [" + resourceStateString + "].");
                }
                try {
                    resourceLocation = new class_2960(resourceStateString.substring(0, separatorIndex), resourceStateString.substring(separatorIndex + 1));
                }
                catch (Exception e) {
                    throw new IOException("No Resource Location found for the string: [" + resourceStateString + "] Error: [" + e.getMessage() + "].");
                }
                try {
                    LodUtil.assertTrue(levelWrapper != null && levelWrapper.getWrappedMcObject() != null);
                    class_1937 level = (class_1937)levelWrapper.getWrappedMcObject();
                    class_5455 registryAccess = level.method_30349();
                    block = (class_2248)registryAccess.method_30530(class_7924.field_41254).method_10223(resourceLocation);
                    if (block == null) {
                        if (!BROKEN_RESOURCE_LOCATIONS.contains(resourceLocation)) {
                            BROKEN_RESOURCE_LOCATIONS.add(resourceLocation);
                            LOGGER.warn("Unable to find BlockState with the resourceLocation [" + String.valueOf(resourceLocation) + "] and properties: [" + blockStatePropertiesString + "]. Air will be used instead, some data may be lost.");
                        }
                        BlockStateWrapper blockStateWrapper = AIR;
                        return blockStateWrapper;
                    }
                    foundState = null;
                    if (blockStatePropertiesString == null) break block18;
                }
                catch (Exception e) {
                    throw new IOException("Failed to deserialize the string [" + finalResourceStateString + "] into a BlockStateWrapper: " + e.getMessage(), e);
                }
                ImmutableList possibleStateList = block.method_9595().method_11662();
                for (class_2680 possibleState : possibleStateList) {
                    String possibleStatePropertiesString = BlockStateWrapper.serializeBlockStateProperties(possibleState);
                    if (!possibleStatePropertiesString.equals(blockStatePropertiesString)) continue;
                    foundState = possibleState;
                    break;
                }
            }
            if (foundState == null) {
                if (blockStatePropertiesString != null && !BROKEN_RESOURCE_LOCATIONS.contains(resourceLocation)) {
                    BROKEN_RESOURCE_LOCATIONS.add(resourceLocation);
                    LOGGER.warn("Unable to find BlockState for Block [" + String.valueOf(resourceLocation) + "] with properties: [" + blockStatePropertiesString + "]. Using the default block state.");
                }
                foundState = block.method_9564();
            }
            BlockStateWrapper blockStateWrapper = foundWrapper = new BlockStateWrapper(foundState, levelWrapper);
            return blockStateWrapper;
        }
        finally {
            WRAPPER_BY_RESOURCE_LOCATION.putIfAbsent(finalResourceStateString, foundWrapper);
        }
    }

    private static String serializeBlockStateProperties(class_2680 blockState) {
        Collection blockPropertyCollection = blockState.method_28501();
        ArrayList sortedBlockPropteryList = new ArrayList(blockPropertyCollection);
        sortedBlockPropteryList.sort((a, b) -> a.method_11899().compareTo(b.method_11899()));
        StringBuilder stringBuilder = new StringBuilder();
        for (class_2769 property : sortedBlockPropteryList) {
            String propertyName = property.method_11899();
            String value = "NULL";
            if (blockState.method_28498(property)) {
                value = blockState.method_11654(property).toString();
            }
            stringBuilder.append("{");
            stringBuilder.append(propertyName).append(RESOURCE_LOCATION_SEPARATOR).append(value);
            stringBuilder.append("}");
        }
        return stringBuilder.toString();
    }

    private EDhApiBlockMaterial calculateEDhApiBlockMaterialId() {
        if (this.blockState == null) {
            return EDhApiBlockMaterial.AIR;
        }
        String serialString = this.getSerialString().toLowerCase();
        if (this.blockState.method_26164(class_3481.field_15503) || serialString.contains("bamboo") || serialString.contains("cactus") || serialString.contains("chorus_flower") || serialString.contains("mushroom")) {
            return EDhApiBlockMaterial.LEAVES;
        }
        if (this.blockState.method_27852(class_2246.field_10164)) {
            return EDhApiBlockMaterial.LAVA;
        }
        if (this.isLiquid() || this.blockState.method_27852(class_2246.field_10382)) {
            return EDhApiBlockMaterial.WATER;
        }
        if (this.blockState.method_26231() == class_2498.field_11547 || serialString.contains("root") || this.blockState.method_26231() == class_2498.field_42766) {
            return EDhApiBlockMaterial.WOOD;
        }
        if (this.blockState.method_26231() == class_2498.field_11533 || this.blockState.method_26231() == class_2498.field_27204) {
            return EDhApiBlockMaterial.METAL;
        }
        if (serialString.contains("grass_block")) {
            return EDhApiBlockMaterial.GRASS;
        }
        if (serialString.contains("dirt") || serialString.contains("gravel") || serialString.contains("mud") || serialString.contains("podzol") || serialString.contains("mycelium")) {
            return EDhApiBlockMaterial.DIRT;
        }
        if (this.blockState.method_26231() == class_2498.field_29033 || this.blockState.method_26231() == class_2498.field_29034 || this.blockState.method_26231() == class_2498.field_29035 || this.blockState.method_26231() == class_2498.field_29036 || serialString.contains("deepslate")) {
            return EDhApiBlockMaterial.DEEPSLATE;
        }
        if (this.serialString.contains("snow")) {
            return EDhApiBlockMaterial.SNOW;
        }
        if (serialString.contains("sand")) {
            return EDhApiBlockMaterial.SAND;
        }
        if (serialString.contains("terracotta")) {
            return EDhApiBlockMaterial.TERRACOTTA;
        }
        if (this.blockState.method_26164(class_3481.field_25807)) {
            return EDhApiBlockMaterial.NETHER_STONE;
        }
        if (serialString.contains("stone") || serialString.contains("ore")) {
            return EDhApiBlockMaterial.STONE;
        }
        if (this.blockState.method_26213() > 0) {
            return EDhApiBlockMaterial.ILLUMINATED;
        }
        return EDhApiBlockMaterial.UNKNOWN;
    }
}

