/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.world;

import com.seibel.distanthorizons.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.world.level.dimension.DimensionType;

public class DimensionTypeWrapper
implements IDimensionTypeWrapper {
    private static final ConcurrentMap<String, DimensionTypeWrapper> DIMENSION_WRAPPER_BY_NAME = new ConcurrentHashMap<String, DimensionTypeWrapper>();
    private final DimensionType dimensionType;

    public DimensionTypeWrapper(DimensionType dimensionType) {
        this.dimensionType = dimensionType;
    }

    public static DimensionTypeWrapper getDimensionTypeWrapper(DimensionType dimensionType) {
        String dimName = DimensionTypeWrapper.getName(dimensionType);
        if (DIMENSION_WRAPPER_BY_NAME.containsKey(dimName) && DIMENSION_WRAPPER_BY_NAME.get(dimName) != null) {
            return (DimensionTypeWrapper)DIMENSION_WRAPPER_BY_NAME.get(dimName);
        }
        DimensionTypeWrapper dimensionTypeWrapper = new DimensionTypeWrapper(dimensionType);
        DIMENSION_WRAPPER_BY_NAME.put(dimName, dimensionTypeWrapper);
        return dimensionTypeWrapper;
    }

    public static void clearMap() {
        DIMENSION_WRAPPER_BY_NAME.clear();
    }

    @Override
    public String getName() {
        return DimensionTypeWrapper.getName(this.dimensionType);
    }

    public static String getName(DimensionType dimensionType) {
        return dimensionType.f_63837_().m_135815_();
    }

    @Override
    public boolean hasCeiling() {
        return this.dimensionType.f_63856_();
    }

    @Override
    public boolean hasSkyLight() {
        return this.dimensionType.f_223549_();
    }

    @Override
    public Object getWrappedMcObject() {
        return this.dimensionType;
    }

    @Override
    public boolean isTheEnd() {
        return this.getName().equalsIgnoreCase("the_end");
    }

    @Override
    public double getCoordinateScale() {
        return this.dimensionType.f_63859_();
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != DimensionTypeWrapper.class) {
            return false;
        }
        DimensionTypeWrapper other = (DimensionTypeWrapper)obj;
        return other.getName().equals(this.getName());
    }
}

