/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.api.external.methods.data;

import com.seibel.distanthorizons.api.interfaces.data.IDhApiTerrainDataCache;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.lang.ref.SoftReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class DhApiTerrainDataCache
implements IDhApiTerrainDataCache {
    private final Object modificationLock = new Object();
    private Long2ReferenceOpenHashMap<SoftReference<FullDataSourceV2>> posToFullDataRef = new Long2ReferenceOpenHashMap();
    private static final Logger LOGGER = LogManager.getLogger((String)DhApiTerrainDataCache.class.getSimpleName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long pos, FullDataSourceV2 dataSource) {
        Object object = this.modificationLock;
        synchronized (object) {
            this.posToFullDataRef.put(pos, new SoftReference<FullDataSourceV2>(dataSource));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FullDataSourceV2 get(long pos) {
        Object object = this.modificationLock;
        synchronized (object) {
            SoftReference ref = (SoftReference)this.posToFullDataRef.get(pos);
            if (ref != null) {
                return (FullDataSourceV2)ref.get();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.modificationLock;
        synchronized (object) {
            LongSet keySet = this.posToFullDataRef.keySet();
            LongIterator longIterator = keySet.iterator();
            while (longIterator.hasNext()) {
                FullDataSourceV2 dataSource;
                long pos = (Long)longIterator.next();
                SoftReference dataRef = (SoftReference)this.posToFullDataRef.remove(pos);
                if (dataRef == null || (dataSource = (FullDataSourceV2)dataRef.get()) == null) continue;
                try {
                    dataSource.close();
                }
                catch (Exception e) {
                    LOGGER.warn("Unable to close data source, error: [" + e.getMessage() + "].", (Throwable)e);
                }
            }
        }
    }
}

