/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.render.columnViews;

import com.seibel.distanthorizons.core.dataObjects.render.columnViews.IColumnDataView;
import com.seibel.distanthorizons.core.util.RenderDataPointUtil;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;

public final class ColumnArrayView
implements IColumnDataView {
    public final LongArrayList data;
    public final int size;
    public final int verticalSize;
    public final int offset;

    public ColumnArrayView(LongArrayList data, int size, int offset, int verticalSize) throws IllegalArgumentException {
        this.data = data;
        this.size = size;
        this.offset = offset;
        this.verticalSize = verticalSize;
        if (this.data.size() < this.offset) {
            throw new IllegalArgumentException("data size [" + this.data.size() + "] is shorter than offset [" + this.offset + "].");
        }
    }

    @Override
    public long get(int index) {
        try {
            return this.data.getLong(index + this.offset);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ConcurrentModificationException("Potential concurrent modification detected. Make sure the parent ColumnRenderSource isn't being closed before the ColumnArrayView processing is complete.", e);
        }
    }

    public void set(int index, long value) {
        this.data.set(index + this.offset, value);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int verticalSize() {
        return this.verticalSize;
    }

    @Override
    public int dataCount() {
        return this.verticalSize != 0 ? this.size / this.verticalSize : 0;
    }

    @Override
    public ColumnArrayView subView(int dataIndexStart, int dataCount) {
        return new ColumnArrayView(this.data, dataCount * this.verticalSize, this.offset + dataIndexStart * this.verticalSize, this.verticalSize);
    }

    public void fill(long value) {
        Arrays.fill(this.data.elements(), this.offset, this.offset + this.size, value);
    }

    public void copyFrom(IColumnDataView source) {
        this.copyFrom(source, 0);
    }

    public void copyFrom(IColumnDataView source, int outputDataIndexOffset) {
        if (source.verticalSize() > this.verticalSize) {
            throw new IllegalArgumentException("source verticalSize must be <= self's verticalSize to copy");
        }
        if (source.dataCount() + outputDataIndexOffset > this.dataCount()) {
            throw new IllegalArgumentException("dataIndexStart + source.dataCount() must be <= self.dataCount() to copy");
        }
        if (source.verticalSize() != this.verticalSize) {
            for (int i = 0; i < source.dataCount(); ++i) {
                int outputOffset = this.offset + outputDataIndexOffset * this.verticalSize + i * this.verticalSize;
                source.subView(i, 1).copyTo(this.data.elements(), outputOffset, source.verticalSize());
                Arrays.fill(this.data.elements(), outputOffset + source.verticalSize(), outputOffset + this.verticalSize, 0L);
            }
        } else {
            source.copyTo(this.data.elements(), this.offset + outputDataIndexOffset * this.verticalSize, source.size());
        }
    }

    @Override
    public void copyTo(long[] target, int offset, int size) {
        System.arraycopy(this.data.elements(), this.offset, target, offset, size);
    }

    public boolean mergeWith(ColumnArrayView source, boolean override) {
        if (this.size != source.size) {
            throw new IllegalArgumentException("Cannot merge views of different sizes");
        }
        if (this.verticalSize != source.verticalSize) {
            throw new IllegalArgumentException("Cannot merge views of different vertical sizes");
        }
        boolean anyChange = false;
        for (int o = 0; o < source.size() * this.verticalSize; o += this.verticalSize) {
            if (override) {
                if (RenderDataPointUtil.compareDatapointPriority(source.get(o), this.get(o)) < 0) continue;
                anyChange = true;
                System.arraycopy(source.data, source.offset + o, this.data, this.offset + o, this.verticalSize);
                continue;
            }
            if (RenderDataPointUtil.compareDatapointPriority(source.get(o), this.get(o)) <= 0) continue;
            anyChange = true;
            System.arraycopy(source.data, source.offset + o, this.data, this.offset + o, this.verticalSize);
        }
        return anyChange;
    }

    public void changeVerticalSizeFrom(IColumnDataView source) {
        if (this.dataCount() != source.dataCount()) {
            throw new IllegalArgumentException("Cannot copy and resize to views with different dataCounts");
        }
        if (this.verticalSize >= source.verticalSize()) {
            this.copyFrom(source);
        } else {
            for (int i = 0; i < this.dataCount(); ++i) {
                RenderDataPointUtil.mergeMultiData(source.subView(i, 1), this.subView(i, 1));
            }
        }
    }

    public void mergeMultiDataFrom(IColumnDataView source) {
        if (this.dataCount() != 1) {
            throw new IllegalArgumentException("output dataCount must be 1");
        }
        RenderDataPointUtil.mergeMultiData(source, this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("S:").append(this.size);
        sb.append(" V:").append(this.verticalSize);
        sb.append(" O:").append(this.offset);
        sb.append(" [");
        for (int i = 0; i < this.size; ++i) {
            sb.append(RenderDataPointUtil.toString(this.data.getLong(this.offset + i)));
            if (i >= this.size - 1) continue;
            sb.append(",\n");
        }
        sb.append("]");
        return sb.toString();
    }

    public int getDataHash() {
        return ColumnArrayView.arrayHash(this.data, this.offset, this.size);
    }

    private static int arrayHash(LongArrayList a, int offset, int length) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            long element = a.getLong(i);
            int elementHash = (int)(element ^ element >>> 32);
            result = 31 * result + elementHash;
        }
        return result;
    }
}

