/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.sql.repo;

import com.seibel.distanthorizons.api.enums.config.EDhApiDataCompressionMode;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.sql.DbConnectionClosedException;
import com.seibel.distanthorizons.core.sql.dto.FullDataSourceV2DTO;
import com.seibel.distanthorizons.core.sql.repo.AbstractDhRepo;
import com.seibel.distanthorizons.core.util.BoolUtil;
import com.seibel.distanthorizons.core.util.ListUtil;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataInputStream;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FullDataSourceV2Repo
extends AbstractDhRepo<Long, FullDataSourceV2DTO> {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private final String insertSqlTemplate = "INSERT INTO " + this.getTableName() + " (\n   DetailLevel, PosX, PosZ, \n   MinY, DataChecksum, \n   Data, ColumnGenerationStep, ColumnWorldCompressionMode, Mapping, \n   DataFormatVersion, CompressionMode, ApplyToParent, ApplyToChildren, \n   LastModifiedUnixDateTime, CreatedUnixDateTime) \nVALUES( \n    ?, ?, ?, \n    ?, ?, \n    ?, ?, ?, ?, \n    ?, ?, ?, ?, \n    ?, ? \n);";
    private final String setApplyToParentSql = "UPDATE " + this.getTableName() + " \nSET ApplyToParent = ? \nWHERE DetailLevel = ? AND PosX = ? AND PosZ = ?";
    private final String setApplyToChildrenSql = "UPDATE " + this.getTableName() + " \nSET ApplyToChildren = ? \nWHERE DetailLevel = ? AND PosX = ? AND PosZ = ?";
    private final String getParentPositionsToUpdateSql = "SELECT DetailLevel, PosX, PosZ,    abs((PosX << (6 + DetailLevel)) - ?) + abs((PosZ << (6 + DetailLevel)) - ?) AS Distance FROM " + this.getTableName() + " WHERE ApplyToParent = 1 ORDER BY DetailLevel ASC, Distance ASC LIMIT ?; ";
    private final String getChildPositionsToUpdateSql = "SELECT DetailLevel, PosX, PosZ,    abs((PosX << (6 + DetailLevel)) - ?) + abs((PosZ << (6 + DetailLevel)) - ?) AS Distance FROM " + this.getTableName() + " WHERE ApplyToChildren = 1 ORDER BY DetailLevel ASC, Distance ASC LIMIT ?; ";
    private final String getColumnGenerationStepSql = "select ColumnGenerationStep, CompressionMode from " + this.getTableName() + " WHERE DetailLevel = ? AND PosX = ? AND PosZ = ?";
    private final String getTimestampForPosSql = "SELECT LastModifiedUnixDateTime FROM " + this.getTableName() + " WHERE DetailLevel = ? AND PosX = ? AND PosZ = ?;";
    private final String getTimestampForRangeSql = "SELECT PosX, PosZ, LastModifiedUnixDateTime FROM " + this.getTableName() + " WHERE DetailLevel = ? AND PosX BETWEEN ? AND ? AND PosZ BETWEEN ? AND ?;";
    private final String getAllPositionsSql = "select DetailLevel, PosX, PosZ from " + this.getTableName() + "; ";
    private final String getDataSizeInBytesSql = "select LENGTH(Data) as dataSize from " + this.getTableName() + " WHERE DetailLevel = ? AND PosX = ? AND PosZ = ?";
    private final String getTotalDataSizeInBytesSql = "select SUM(LENGTH(Data)) as dataSize from " + this.getTableName() + "; ";

    public FullDataSourceV2Repo(String databaseType, File databaseFile) throws SQLException {
        super(databaseType, databaseFile, FullDataSourceV2DTO.class);
    }

    @Override
    public String getTableName() {
        return "FullData";
    }

    @Override
    protected String CreateParameterizedWhereString() {
        return "DetailLevel = ? AND PosX = ? AND PosZ = ?";
    }

    @Override
    protected int setPreparedStatementWhereClause(PreparedStatement statement, int index, Long pos) throws SQLException {
        int detailLevel = DhSectionPos.getDetailLevel(pos) - 6;
        statement.setInt(index++, detailLevel);
        statement.setInt(index++, DhSectionPos.getX(pos));
        statement.setInt(index++, DhSectionPos.getZ(pos));
        return index;
    }

    @Override
    @Nullable
    public FullDataSourceV2DTO convertResultSetToDto(ResultSet resultSet) throws ClassCastException, IOException, SQLException {
        byte detailLevel = resultSet.getByte("DetailLevel");
        byte sectionDetailLevel = (byte)(detailLevel + 6);
        int posX = resultSet.getInt("PosX");
        int posZ = resultSet.getInt("PosZ");
        long pos = DhSectionPos.encode(sectionDetailLevel, posX, posZ);
        int minY = resultSet.getInt("MinY");
        int dataChecksum = resultSet.getInt("DataChecksum");
        byte dataFormatVersion = resultSet.getByte("DataFormatVersion");
        byte compressionModeValue = resultSet.getByte("CompressionMode");
        boolean applyToParent = resultSet.getInt("ApplyToParent") == 1;
        boolean applyToChildren = resultSet.getInt("ApplyToChildren") == 1;
        long lastModifiedUnixDateTime = resultSet.getLong("LastModifiedUnixDateTime");
        long createdUnixDateTime = resultSet.getLong("CreatedUnixDateTime");
        FullDataSourceV2DTO dto = FullDataSourceV2DTO.CreateEmptyDataSourceForDecoding();
        dto.compressedDataByteArray = FullDataSourceV2Repo.putAllBytes(resultSet.getBinaryStream("Data"), dto.compressedDataByteArray);
        dto.compressedColumnGenStepByteArray = FullDataSourceV2Repo.putAllBytes(resultSet.getBinaryStream("ColumnGenerationStep"), dto.compressedColumnGenStepByteArray);
        dto.compressedWorldCompressionModeByteArray = FullDataSourceV2Repo.putAllBytes(resultSet.getBinaryStream("ColumnWorldCompressionMode"), dto.compressedWorldCompressionModeByteArray);
        dto.compressedMappingByteArray = FullDataSourceV2Repo.putAllBytes(resultSet.getBinaryStream("Mapping"), dto.compressedMappingByteArray);
        dto.pos = pos;
        dto.dataChecksum = dataChecksum;
        dto.dataFormatVersion = dataFormatVersion;
        dto.compressionModeValue = compressionModeValue;
        dto.lastModifiedUnixDateTime = lastModifiedUnixDateTime;
        dto.createdUnixDateTime = createdUnixDateTime;
        dto.applyToParent = applyToParent;
        dto.applyToChildren = applyToChildren;
        dto.levelMinY = minY;
        return dto;
    }

    @Override
    public PreparedStatement createInsertStatement(FullDataSourceV2DTO dto) throws SQLException {
        PreparedStatement statement = this.createPreparedStatement(this.insertSqlTemplate);
        if (statement == null) {
            return null;
        }
        int i = 1;
        statement.setInt(i++, DhSectionPos.getDetailLevel(dto.pos) - 6);
        statement.setInt(i++, DhSectionPos.getX(dto.pos));
        statement.setInt(i++, DhSectionPos.getZ(dto.pos));
        statement.setInt(i++, dto.levelMinY);
        statement.setInt(i++, dto.dataChecksum);
        statement.setBinaryStream(i++, (InputStream)new ByteArrayInputStream(dto.compressedDataByteArray.elements()), dto.compressedDataByteArray.size());
        statement.setBinaryStream(i++, (InputStream)new ByteArrayInputStream(dto.compressedColumnGenStepByteArray.elements()), dto.compressedColumnGenStepByteArray.size());
        statement.setBinaryStream(i++, (InputStream)new ByteArrayInputStream(dto.compressedWorldCompressionModeByteArray.elements()), dto.compressedWorldCompressionModeByteArray.size());
        statement.setBinaryStream(i++, (InputStream)new ByteArrayInputStream(dto.compressedMappingByteArray.elements()), dto.compressedMappingByteArray.size());
        statement.setByte(i++, dto.dataFormatVersion);
        statement.setByte(i++, dto.compressionModeValue);
        statement.setBoolean(i++, BoolUtil.falseIfNull(dto.applyToParent));
        statement.setBoolean(i++, BoolUtil.falseIfNull(dto.applyToChildren));
        statement.setLong(i++, System.currentTimeMillis());
        statement.setLong(i++, System.currentTimeMillis());
        return statement;
    }

    @Override
    public PreparedStatement createUpdateStatement(FullDataSourceV2DTO dto) throws SQLException {
        String updateSqlTemplate = ("UPDATE " + this.getTableName() + " \nSET \n    MinY = ? \n   ,DataChecksum = ? \n   ,Data = ? \n   ,ColumnGenerationStep = ? \n   ,ColumnWorldCompressionMode = ? \n   ,Mapping = ? \n   ,DataFormatVersion = ? \n   ,CompressionMode = ? \n" + (dto.applyToParent != null ? "   ,ApplyToParent = ? \n" : "") + (dto.applyToChildren != null ? "   ,ApplyToChildren = ? \n" : "") + "   ,LastModifiedUnixDateTime = ? \n   ,CreatedUnixDateTime = ? \nWHERE DetailLevel = ? AND PosX = ? AND PosZ = ?").intern();
        PreparedStatement statement = this.createPreparedStatement(updateSqlTemplate);
        if (statement == null) {
            return null;
        }
        int i = 1;
        statement.setInt(i++, dto.levelMinY);
        statement.setInt(i++, dto.dataChecksum);
        statement.setBinaryStream(i++, (InputStream)new ByteArrayInputStream(dto.compressedDataByteArray.elements()), dto.compressedDataByteArray.size());
        statement.setBinaryStream(i++, (InputStream)new ByteArrayInputStream(dto.compressedColumnGenStepByteArray.elements()), dto.compressedColumnGenStepByteArray.size());
        statement.setBinaryStream(i++, (InputStream)new ByteArrayInputStream(dto.compressedWorldCompressionModeByteArray.elements()), dto.compressedWorldCompressionModeByteArray.size());
        statement.setBinaryStream(i++, (InputStream)new ByteArrayInputStream(dto.compressedMappingByteArray.elements()), dto.compressedMappingByteArray.size());
        statement.setByte(i++, dto.dataFormatVersion);
        statement.setByte(i++, dto.compressionModeValue);
        if (dto.applyToParent != null) {
            statement.setBoolean(i++, dto.applyToParent);
        }
        if (dto.applyToChildren != null) {
            statement.setBoolean(i++, dto.applyToChildren);
        }
        statement.setLong(i++, System.currentTimeMillis());
        statement.setLong(i++, dto.createdUnixDateTime);
        statement.setInt(i++, DhSectionPos.getDetailLevel(dto.pos) - 6);
        statement.setInt(i++, DhSectionPos.getX(dto.pos));
        statement.setInt(i++, DhSectionPos.getZ(dto.pos));
        return statement;
    }

    public void setApplyToParent(long pos, boolean applyToParent) {
        this.setApplyToFlag(pos, applyToParent, true);
    }

    public void setApplyToChild(long pos, boolean applyToChild) {
        this.setApplyToFlag(pos, applyToChild, false);
    }

    private void setApplyToFlag(long pos, boolean applyFlag, boolean applyToParent) {
        String sql = applyToParent ? this.setApplyToParentSql : this.setApplyToChildrenSql;
        try (PreparedStatement statement = this.createPreparedStatement(sql);){
            if (statement == null) {
                return;
            }
            int i = 1;
            statement.setBoolean(i++, applyFlag);
            int detailLevel = DhSectionPos.getDetailLevel(pos) - 6;
            statement.setInt(i++, detailLevel);
            statement.setInt(i++, DhSectionPos.getX(pos));
            statement.setInt(i++, DhSectionPos.getZ(pos));
            ResultSet result = this.query(statement);
            if (result != null) {
                result.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public LongArrayList getPositionsToUpdate(int targetBlockPosX, int targetBlockPosZ, int returnCount) {
        return this.getPositionsToUpdate(targetBlockPosX, targetBlockPosZ, returnCount, true);
    }

    public LongArrayList getChildPositionsToUpdate(int targetBlockPosX, int targetBlockPosZ, int returnCount) {
        return this.getPositionsToUpdate(targetBlockPosX, targetBlockPosZ, returnCount, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LongArrayList getPositionsToUpdate(int targetBlockPosX, int targetBlockPosZ, int returnCount, boolean getParentUpdates) {
        LongArrayList list = new LongArrayList();
        String sql = getParentUpdates ? this.getParentPositionsToUpdateSql : this.getChildPositionsToUpdateSql;
        try (PreparedStatement statement = this.createPreparedStatement(sql);){
            if (statement == null) {
                LongArrayList longArrayList2 = list;
                return longArrayList2;
            }
            int i = 1;
            statement.setInt(i++, targetBlockPosX);
            statement.setInt(i++, targetBlockPosZ);
            statement.setInt(i++, returnCount);
            try (ResultSet result = this.query(statement);){
                while (result != null && result.next()) {
                    byte detailLevel = result.getByte("DetailLevel");
                    byte sectionDetailLevel = (byte)(detailLevel + 6);
                    int posX = result.getInt("PosX");
                    int posZ = result.getInt("PosZ");
                    long pos = DhSectionPos.encode(sectionDetailLevel, posX, posZ);
                    list.add(pos);
                }
            }
            LongArrayList longArrayList = list;
            return longArrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void getColumnGenerationStepForPos(long pos, ByteArrayList outputByteArray) {
        try (PreparedStatement statement = this.createPreparedStatement(this.getColumnGenerationStepSql);){
            if (statement == null) {
                return;
            }
            int detailLevel = DhSectionPos.getDetailLevel(pos) - 6;
            int i = 1;
            statement.setInt(i++, detailLevel);
            statement.setInt(i++, DhSectionPos.getX(pos));
            statement.setInt(i++, DhSectionPos.getZ(pos));
            try (ResultSet result = this.query(statement);){
                if (result == null || !result.next()) {
                    return;
                }
                byte compressionModeEnumValue = result.getByte("CompressionMode");
                EDhApiDataCompressionMode compressionModeEnum = EDhApiDataCompressionMode.getFromValue(compressionModeEnumValue);
                try (DhDataInputStream compressedIn = new DhDataInputStream(result.getBinaryStream("ColumnGenerationStep"), compressionModeEnum);){
                    FullDataSourceV2Repo.putAllBytes(compressedIn, outputByteArray);
                }
                catch (IOException e) {
                    LOGGER.warn("Decompression issue when getting column gen steps for pos: [" + DhSectionPos.toString(pos) + "], deleting corrupted data.", (Throwable)e);
                    this.deleteWithKey(pos);
                    ListUtil.clearAndSetSize(outputByteArray, 4096);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Long getTimestampForPos(long pos) {
        try (PreparedStatement preparedStatement = this.createPreparedStatement(this.getTimestampForPosSql);){
            Long l;
            block21: {
                ResultSet result;
                block19: {
                    Long l2;
                    block20: {
                        if (preparedStatement == null) {
                            Long l3 = null;
                            return l3;
                        }
                        int i = 1;
                        preparedStatement.setInt(i++, DhSectionPos.getDetailLevel(pos) - 6);
                        preparedStatement.setInt(i++, DhSectionPos.getX(pos));
                        preparedStatement.setInt(i++, DhSectionPos.getZ(pos));
                        result = this.query(preparedStatement);
                        try {
                            if (result != null && result.next()) break block19;
                            l2 = null;
                            if (result == null) break block20;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return l2;
                }
                l = result.getLong("LastModifiedUnixDateTime");
                if (result == null) break block21;
                result.close();
            }
            return l;
        }
        catch (DbConnectionClosedException e) {
            return null;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Map<Long, Long> getTimestampsForRange(byte detailLevel, int startPosX, int startPosZ, int endPosX, int endPosZ) {
        try (PreparedStatement preparedStatement = this.createPreparedStatement(this.getTimestampForRangeSql);){
            HashMap<Long, Long> hashMap;
            block17: {
                if (preparedStatement == null) {
                    HashMap<Long, Long> hashMap2 = new HashMap<Long, Long>();
                    return hashMap2;
                }
                int i = 1;
                preparedStatement.setInt(i++, detailLevel - 6);
                preparedStatement.setInt(i++, startPosX);
                preparedStatement.setInt(i++, endPosX - 1);
                preparedStatement.setInt(i++, startPosZ);
                preparedStatement.setInt(i++, endPosZ - 1);
                ResultSet result = this.query(preparedStatement);
                try {
                    HashMap<Long, Long> returnMap = new HashMap<Long, Long>();
                    while (result != null && result.next()) {
                        long key = DhSectionPos.encode(detailLevel, result.getInt("PosX"), result.getInt("PosZ"));
                        long value = result.getLong("LastModifiedUnixDateTime");
                        returnMap.put(key, value);
                    }
                    hashMap = returnMap;
                    if (result == null) break block17;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return hashMap;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public LongArrayList getAllPositions() {
        LongArrayList list = new LongArrayList();
        try (PreparedStatement statement = this.createPreparedStatement(this.getAllPositionsSql);){
            LongArrayList longArrayList;
            block17: {
                if (statement == null) {
                    LongArrayList longArrayList2 = list;
                    return longArrayList2;
                }
                ResultSet result = this.query(statement);
                try {
                    while (result != null && result.next()) {
                        byte detailLevel = result.getByte("DetailLevel");
                        byte sectionDetailLevel = (byte)(detailLevel + 6);
                        int posX = result.getInt("PosX");
                        int posZ = result.getInt("PosZ");
                        long pos = DhSectionPos.encode(sectionDetailLevel, posX, posZ);
                        list.add(pos);
                    }
                    longArrayList = list;
                    if (result == null) break block17;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return longArrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public long getDataSizeInBytes(long pos) {
        int detailLevel = DhSectionPos.getDetailLevel(pos) - 6;
        try (PreparedStatement statement = this.createPreparedStatement(this.getDataSizeInBytesSql);){
            long l;
            block20: {
                ResultSet result;
                block18: {
                    long l2;
                    block19: {
                        if (statement == null) {
                            long l3 = 0L;
                            return l3;
                        }
                        int i = 1;
                        statement.setInt(i++, detailLevel);
                        statement.setInt(i++, DhSectionPos.getX(pos));
                        statement.setInt(i++, DhSectionPos.getZ(pos));
                        result = this.query(statement);
                        try {
                            if (result != null && result.next()) break block18;
                            l2 = 0L;
                            if (result == null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return l2;
                }
                l = result.getLong("dataSize");
                if (result == null) break block20;
                result.close();
            }
            return l;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public long getTotalDataSizeInBytes() {
        try (PreparedStatement statement = this.createPreparedStatement(this.getTotalDataSizeInBytesSql);){
            long l;
            block18: {
                ResultSet result;
                block16: {
                    long l2;
                    block17: {
                        result = this.query(statement);
                        try {
                            if (result != null && result.next()) break block16;
                            l2 = 0L;
                            if (result == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return l2;
                }
                l = result.getLong("dataSize");
                if (result == null) break block18;
                result.close();
            }
            return l;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static ByteArrayList putAllBytes(InputStream inputStream, @Nullable ByteArrayList existingArrayList) throws IOException {
        if (existingArrayList == null) {
            existingArrayList = new ByteArrayList(64);
        } else {
            existingArrayList.clear();
        }
        try {
            int nextByte = inputStream.read();
            while (nextByte != -1) {
                existingArrayList.add((byte)nextByte);
                nextByte = inputStream.read();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return existingArrayList;
    }
}

