/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.seibel.distanthorizons.core.generation.PregenManager;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import loaderCommon.fabric.com.seibel.distanthorizons.common.commands.AbstractCommand;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2264;
import net.minecraft.class_2265;
import net.minecraft.class_3218;

public class PregenCommand
extends AbstractCommand {
    private final PregenManager pregenManager = new PregenManager();

    @Override
    public LiteralArgumentBuilder<class_2168> buildCommand() {
        LiteralArgumentBuilder statusCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"status").executes(this::pregenStatus);
        LiteralArgumentBuilder startCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"start").then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)"origin", (ArgumentType)class_2264.method_9701()).then(class_2170.method_9244((String)"chunkRadius", (ArgumentType)IntegerArgumentType.integer((int)32)).executes(this::pregenStart))));
        LiteralArgumentBuilder stopCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"stop").executes(this::pregenStop);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"pregen").then((ArgumentBuilder)statusCommand)).then((ArgumentBuilder)startCommand)).then((ArgumentBuilder)stopCommand);
    }

    private int pregenStatus(CommandContext<class_2168> c) {
        String statusString = this.pregenManager.getStatusString();
        if (statusString != null) {
            return this.sendSuccessResponse(c, statusString, false);
        }
        return this.sendSuccessResponse(c, "Pregen is not running", false);
    }

    private int pregenStart(CommandContext<class_2168> c) throws CommandSyntaxException {
        this.sendSuccessResponse(c, "Starting pregen. Progress will be in the server console.", true);
        class_3218 level = class_2181.method_9289(c, (String)"dimension");
        class_2265 origin = class_2264.method_9702(c, (String)"origin");
        int chunkRadius = IntegerArgumentType.getInteger(c, (String)"chunkRadius");
        CompletableFuture<Void> future = this.pregenManager.startPregen(ServerLevelWrapper.getWrapper(level), new DhBlockPos2D(origin.field_10708, origin.field_10707), chunkRadius);
        future.whenComplete((result, throwable) -> {
            if (throwable instanceof CancellationException) {
                this.sendSuccessResponse(c, "Pregen is cancelled", true);
                return;
            }
            if (throwable != null) {
                this.sendFailureResponse(c, "Pregen failed: " + throwable.getMessage() + "\n Check the logs for more details.");
                return;
            }
            this.sendSuccessResponse(c, "Pregen is complete", true);
        });
        return 1;
    }

    private int pregenStop(CommandContext<class_2168> c) {
        CompletableFuture<Void> runningPregen = this.pregenManager.getRunningPregen();
        if (runningPregen == null) {
            return this.sendFailureResponse(c, "Pregen is not running");
        }
        runningPregen.cancel(true);
        return 1;
    }
}

