/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class WorldGenStructFeatManager
extends StructureFeatureManager {
    final WorldGenLevel genLevel;
    WorldGenSettings worldGenSettings;
    StructureCheck structureCheck;

    public WorldGenStructFeatManager(WorldGenSettings worldGenSettings, WorldGenLevel genLevel, StructureCheck structureCheck) {
        super((LevelAccessor)genLevel, worldGenSettings, structureCheck);
        this.genLevel = genLevel;
        this.worldGenSettings = worldGenSettings;
    }

    public WorldGenStructFeatManager forWorldGenRegion(WorldGenRegion worldGenRegion) {
        if (worldGenRegion == this.genLevel) {
            return this;
        }
        return new WorldGenStructFeatManager(this.worldGenSettings, (WorldGenLevel)worldGenRegion, this.structureCheck);
    }

    private ChunkAccess _getChunk(int x, int z, ChunkStatus status) {
        if (this.genLevel == null) {
            return null;
        }
        return this.genLevel.m_6522_(x, z, status, false);
    }

    public boolean m_186605_(BlockPos blockPos) {
        SectionPos sectionPos = SectionPos.m_123199_((BlockPos)blockPos);
        ChunkAccess chunk = this._getChunk(sectionPos.m_123170_(), sectionPos.m_123222_(), ChunkStatus.f_62316_);
        if (chunk == null) {
            return false;
        }
        return chunk.m_187678_();
    }

    public List<StructureStart> m_207811_(SectionPos sectionPos, Predicate<ConfiguredStructureFeature<?, ?>> predicate) {
        ChunkAccess chunk = this._getChunk(sectionPos.m_123170_(), sectionPos.m_123222_(), ChunkStatus.f_62316_);
        if (chunk == null) {
            return List.of();
        }
        Map map = chunk.m_7049_();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry entry : map.entrySet()) {
            ConfiguredStructureFeature configuredStructureFeature = (ConfiguredStructureFeature)entry.getKey();
            if (!predicate.test(configuredStructureFeature)) continue;
            LongSet var10002 = (LongSet)entry.getValue();
            Objects.requireNonNull(builder);
            this.m_207781_(configuredStructureFeature, var10002, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        }
        return builder.build();
    }

    public List<StructureStart> m_207794_(SectionPos sectionPos, ConfiguredStructureFeature<?, ?> configuredStructureFeature) {
        ChunkAccess chunk = this._getChunk(sectionPos.m_123170_(), sectionPos.m_123222_(), ChunkStatus.f_62316_);
        if (chunk == null) {
            return (List)((Object)Stream.empty());
        }
        LongSet longSet = chunk.m_207420_(configuredStructureFeature);
        ImmutableList.Builder builder = ImmutableList.builder();
        Objects.requireNonNull(builder);
        this.m_207781_(configuredStructureFeature, longSet, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public Map<ConfiguredStructureFeature<?, ?>, LongSet> m_207815_(BlockPos blockPos) {
        SectionPos sectionPos = SectionPos.m_123199_((BlockPos)blockPos);
        ChunkAccess chunk = this._getChunk(sectionPos.m_123170_(), sectionPos.m_123222_(), ChunkStatus.f_62316_);
        if (chunk == null) {
            return (Map)((Object)Stream.empty());
        }
        return chunk.m_7049_();
    }
}

