package uk.co.cablepost.ad_astra_cargo_rockets.launch_pad;

import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.ad_astra_cargo_rockets.AdAstraCargoRockets;
import uk.co.cablepost.ad_astra_cargo_rockets.CargoRocketItem;
import uk.co.cablepost.ad_astra_cargo_rockets.cargo_rocket.CargoRocketEntity;
import uk.co.cablepost.f_tech.machines.abstract_machine.AbstractMachineBlock;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_5558;

public class LaunchPadBlock extends AbstractMachineBlock {

    public LaunchPadBlock(class_2251 settings) {
        super(
            settings,
            -1,
            1,
            0,
            0,
            -1,
            1
        );
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    @Override
    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return checkType(world, type, AdAstraCargoRockets.LAUNCH_PAD.getBlockEntity());
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new LaunchPadBlockEntity(pos, state);
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);
        if (!world.field_9236 && !stack.method_7960() && stack.method_7909() instanceof CargoRocketItem cargoRocketItem) {
            List<CargoRocketEntity> allCargoRocketEntitiesNearby = world.method_8390(CargoRocketEntity.class, new class_238(pos).method_1014(3), CargoRocketEntity::method_5805);
            if(allCargoRocketEntitiesNearby.isEmpty()) {
                CargoRocketEntity cargoRocketEntity = AdAstraCargoRockets.CARGO_ROCKET_ENTITY.method_5883(world);
                assert cargoRocketEntity != null;
                cargoRocketEntity.method_5808(pos.method_46558().method_10216(), pos.method_10264() + 1f, pos.method_46558().method_10215(), 0.0f, 0.0f);
                world.method_8649(cargoRocketEntity);
                cargoRocketEntity.setTier(cargoRocketItem.tier);

                stack.method_7934(1);
                return class_1269.field_21466;
            }
        }

        return super.method_9534(state, world, pos, player, hand, hit);
    }
}
