package uk.co.cablepost.ad_astra_cargo_rockets.launch_pad;

import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.ad_astra_cargo_rockets.cargo_rocket.CargoRocketEntity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_7923;

public class LaunchPadBlockPeripheral implements IPeripheral {

    private final LaunchPadBlockEntity blockEntity;

    public LaunchPadBlockPeripheral(class_2586 blockEntity, class_2350 direction) {
        this.blockEntity = (LaunchPadBlockEntity) blockEntity;
    }

    @Override
    public void attach(IComputerAccess computer) {
        blockEntity.addComputer(computer);
    }

    @Override
    public void detach(IComputerAccess computer) {
        blockEntity.removeComputer(computer);
    }

    @Override
    public String getType() {
        return "cargo_rocket_launch_pad";
    }

    @Override
    public boolean equals(IPeripheral iPeripheral) {
        return iPeripheral instanceof LaunchPadBlockPeripheral;
    }

    @LuaFunction(mainThread = true)
    public final void launch(String planet) throws LuaException {
        @Nullable LaunchFailReason launchFailReason = blockEntity.launch(planet);

        if(launchFailReason == null){
            return;
        }

        switch (launchFailReason){
            case NO_ROCKET -> throw new LuaException("No rocket found");
            case INVALID_PLANET -> throw new LuaException(planet + " is not a valid planet");
            case NOT_ENOUGH_ENERGY -> throw new LuaException("Not enough energy to launch");
            case ROCKET_TIER_TOO_LOW -> throw new LuaException(planet + " is too high of a tier for this rocket");
        }
    }

    @LuaFunction(mainThread = true)
    public final void moveItemsFromRocketToLaunchPad(int rocketSlot, int launchPadSlot) throws LuaException {
        @Nullable ItemMoveFailReason itemMoveFailReason = blockEntity.moveStackFromRocketToLaunchPad(rocketSlot, launchPadSlot);

        if(itemMoveFailReason == null){
            return;
        }

        switch (itemMoveFailReason){
            case NO_ROCKET -> throw new LuaException("No rocket found");
            case TARGET_FULL -> throw new LuaException("Destination full");
            case INVALID_SLOT -> throw new LuaException("Invalid slot");
        }
    }

    @LuaFunction(mainThread = true)
    public final void moveItemsFromLaunchPadToRocket(int launchPadSlot, int rocketSlot) throws LuaException {
        @Nullable ItemMoveFailReason itemMoveFailReason = blockEntity.moveStackFromLaunchPadToRocket(launchPadSlot, rocketSlot);

        if(itemMoveFailReason == null){
            return;
        }

        switch (itemMoveFailReason){
            case NO_ROCKET -> throw new LuaException("No rocket found");
            case TARGET_FULL -> throw new LuaException("Destination full");
            case INVALID_SLOT -> throw new LuaException("Invalid slot");
        }
    }

    @LuaFunction(mainThread = true)
    public final int getEnergyRequiredForLaunch() {
        return blockEntity.getEnergyRequiredForLaunch();
    }

    @LuaFunction(mainThread = true)
    public final long getEnergy() {
        return blockEntity.getEnergy();
    }

    @LuaFunction(mainThread = true)
    public final long getMaxEnergy() {
        return blockEntity.getMaxEnergy();
    }

    @LuaFunction(mainThread = true)
    public final Map<String, Integer> getValidDestinations() {
        return blockEntity.getValidDestinations();
    }

    @LuaFunction(mainThread = true)
    public Map<Integer, Map<String, ?>> listLaunchPadInventory() {
        Map<Integer, Map<String, ?>> result = new HashMap<>();
        var size = blockEntity.method_5439();
        for (var i = 0; i < size; i++) {
            var stack = blockEntity.method_5438(i);
            if (!stack.method_7960()) result.put(i + 1, Map.ofEntries(
                Map.entry("name", stack.method_7909().method_7848().method_10858(128)),
                Map.entry("id", class_7923.field_41178.method_10221(stack.method_7909()).toString()),
                Map.entry("count", stack.method_7947()),
                Map.entry("max_count", stack.method_7914())
            ));
        }

        return result;
    }

    @LuaFunction
    public List<Integer> listLaunchPadInputSlotIndexes() {
        List<Integer> result = new ArrayList<>();
        for(int s : blockEntity._inputSlots) {
            result.add(s + 1);
        }
        return result;
    }

    @LuaFunction
    public List<Integer> listLaunchPadOutputSlotIndexes() {
        List<Integer> result = new ArrayList<>();
        for(int s : blockEntity._outputSlots) {
            result.add(s + 1);
        }
        return result;
    }

    @LuaFunction(mainThread = true)
    public Boolean isRocketPresent(){
        return blockEntity.getRocket() != null;
    }

    @LuaFunction(mainThread = true)
    public Map<Integer, @Nullable Map<String, ?>> listRocketInventory() {

        @Nullable CargoRocketEntity cargoRocketEntity = blockEntity.getRocket();

        if(cargoRocketEntity == null){
            return null;
        }

        Map<Integer, Map<String, ?>> result = new HashMap<>();
        var size = cargoRocketEntity.method_35199().method_5439();
        for (var i = 0; i < size; i++) {
            var stack = cargoRocketEntity.method_35199().method_5438(i);
            if (!stack.method_7960()) result.put(i + 1, Map.ofEntries(
                Map.entry("name", stack.method_7909().method_7848().method_10858(128)),
                Map.entry("id", class_7923.field_41178.method_10221(stack.method_7909()).toString()),
                Map.entry("count", stack.method_7947()),
                Map.entry("max_count", stack.method_7914())
            ));
        }

        return result;
    }

    @LuaFunction(mainThread = true)
    public void destroyRocket(){
        blockEntity.destroyRocket();
    }
}
