package uk.co.cablepost.ad_astra_cargo_rockets.launch_pad;

import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3929;
import net.minecraft.class_5601;
import net.minecraft.class_5616;
import uk.co.cablepost.ad_astra_cargo_rockets.AdAstraCargoRockets;
import uk.co.cablepost.f_tech.machines.abstract_machine.AbstractMachineInit;

public class LaunchPadInit extends AbstractMachineInit<LaunchPadBlock, LaunchPadBlockEntity, LaunchPadScreenHandler, LaunchPadScreen> {

    public static class_5601 MODEL_LAYER;

    public LaunchPadInit(){
        super(AdAstraCargoRockets.MOD_ID, "launch_pad");
    }

    @Override
    public void onInitialize() {
        super.onInitialize();

//        System.out.println("MODS FOUND BY FabricLoader");
//        for(var s : FabricLoader.getInstance().getAllMods()){
//            System.out.println(s.getMetadata().getId());
//        }

        if(FabricLoader.getInstance().getModContainer("connectormod").isPresent()) {
            LaunchPadPeripheralForgeCompat.regPer();
        }
        else{
//            PeripheralLookup.get().registerForBlockEntity(
//                LaunchPadBlockPeripheral::new,
//                getBlockEntity()
//            );

            LaunchPadPeripheralFabricCompat.regPer();
        }
    }

    @Override
    protected LaunchPadBlock createBlock(FabricBlockSettings blockSettings) {
        return new LaunchPadBlock(blockSettings);
    }

    @Override
    protected FabricBlockEntityTypeBuilder.Factory<LaunchPadBlockEntity> createBlockEntityFactory() {
        return LaunchPadBlockEntity::new;
    }

    @Override
    protected ExtendedScreenHandlerType<LaunchPadScreenHandler> createScreenHandler() {
        return new ExtendedScreenHandlerType<>(LaunchPadScreenHandler::new);
    }

    @Override
    protected void registerScreen(ExtendedScreenHandlerType<LaunchPadScreenHandler> screenHandler) {
        class_3929.method_17542(screenHandler, LaunchPadScreen::new);
    }

    @Override
    public void onInitializeClient(){
        MODEL_LAYER = new class_5601(new class_2960(AdAstraCargoRockets.MOD_ID, "launch_pad"), "main");

        super.onInitializeClient();
        class_5616.method_32144(blockEntity, LaunchPadBlockEntityRenderer::new);
        EntityModelLayerRegistry.registerModelLayer(MODEL_LAYER, LaunchPadModel::getTexturedModelData);
    }
}
