package uk.co.cablepost.ad_astra_cargo_rockets.launch_pad;

import dan200.computercraft.api.peripheral.IComputerAccess;
import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.ad_astra_cargo_rockets.AdAstraCargoRockets;
import uk.co.cablepost.ad_astra_cargo_rockets.cargo_rocket.CargoRocketEntity;
import uk.co.cablepost.f_tech.config.FTechConfig;
import uk.co.cablepost.f_tech.machines.abstract_machine.AbstractMachineBlockEntity;

import java.util.*;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2680;

public class LaunchPadBlockEntity extends AbstractMachineBlockEntity {

    private final Set<IComputerAccess> computers = new HashSet<>();

    public LaunchPadBlockEntity(class_2338 pos, class_2680 state) {
        super(
            AdAstraCargoRockets.LAUNCH_PAD.getBlockEntity(),
            pos,
            state,
            new int[]{ 0,  1,  2,  3,  4,  5,  6,  7,  8 },
            new int[]{ 9, 10, 11, 12, 13, 14, 15, 16, 17 },
            1000000,
            1000,
            0,
            false
        );
    }

    //region BlockEntity Stuff
    @Override
    public int getMaxProcessProgress() {
        return 0;
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
    }

    @Override
    public class_2487 method_16887() {
        class_2487 nbtCompound = new class_2487();
        this.method_11007(nbtCompound);
        return nbtCompound;
    }

    @Override
    public int processEnergyConsumption() {
        return 100 * FTechConfig.CONFIG.getOrDefault("f_tech_core.energy_mul", 1);
    }

    @Nullable
    @Override
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new LaunchPadScreenHandler(syncId, playerInventory, this, _propertyDelegate);
    }

    @Override
    public void serverTickExtra() {
    }
    //endregion

    //region Peripheral Stuff
    public void addComputer(IComputerAccess computer) {
        computers.add(computer);
    }

    public void removeComputer(IComputerAccess computer) {
        computers.remove(computer);
    }
    //endregion

    public @Nullable ItemMoveFailReason moveStackFromRocketToLaunchPad(int rocketSlotIndex, int launchPadSlotIndex) {
        @Nullable CargoRocketEntity rocket = getRocket();

        if(rocket == null){
            return ItemMoveFailReason.NO_ROCKET;
        }

        class_1799 rocketStack;
        class_1799 launchPadStack;
        try {
            rocketStack = rocket.method_35199().method_5438(rocketSlotIndex - 1);
            launchPadStack = _inventory.get(launchPadSlotIndex - 1);
        }catch (Exception ignored){
            return ItemMoveFailReason.INVALID_SLOT;
        }

        if(!launchPadStack.method_7960() && (!rocketStack.method_7909().equals(launchPadStack.method_7909()) || launchPadStack.method_7947() >= launchPadStack.method_7914())) {
            return ItemMoveFailReason.TARGET_FULL;
        }

        int maxCanMove = Math.min(
            launchPadStack.method_7914() - launchPadStack.method_7947(),
            rocketStack.method_7947()
        );

        if(maxCanMove == 0){
            return null;
        }

        if(launchPadStack.method_7960()){
            _inventory.set(launchPadSlotIndex - 1, rocketStack.method_7972());
            _inventory.get(launchPadSlotIndex - 1).method_7939(maxCanMove);
            rocketStack.method_7934(maxCanMove);
        }
        else{
            launchPadStack.method_7933(maxCanMove);
            rocketStack.method_7934(maxCanMove);
        }

        return null;
    }

    public @Nullable ItemMoveFailReason moveStackFromLaunchPadToRocket(int launchPadSlotIndex, int rocketSlotIndex) {
        @Nullable CargoRocketEntity rocket = getRocket();

        if(rocket == null){
            return ItemMoveFailReason.NO_ROCKET;
        }

        class_1799 rocketStack;
        class_1799 launchPadStack;
        try {
            rocketStack = rocket.method_35199().method_5438(rocketSlotIndex - 1);
            launchPadStack = _inventory.get(launchPadSlotIndex - 1);
        }catch (Exception ignored){
            return ItemMoveFailReason.INVALID_SLOT;
        }

        if(!rocketStack.method_7960() && (!launchPadStack.method_7909().equals(rocketStack.method_7909()) || rocketStack.method_7947() >= rocketStack.method_7914())) {
            return ItemMoveFailReason.TARGET_FULL;
        }

        int maxCanMove = Math.min(
            rocketStack.method_7914() - rocketStack.method_7947(),
            launchPadStack.method_7947()
        );

        if(maxCanMove == 0){
            return null;
        }

        if(rocketStack.method_7960()){
            rocket.method_35199().method_5447(rocketSlotIndex - 1, launchPadStack.method_7972());
            rocket.method_35199().method_5438(rocketSlotIndex - 1).method_7939(maxCanMove);
            launchPadStack.method_7934(maxCanMove);
        }
        else{
            rocketStack.method_7933(maxCanMove);
            launchPadStack.method_7934(maxCanMove);
        }

        method_5431();

        return null;
    }

    public @Nullable CargoRocketEntity getRocket(){
        List<CargoRocketEntity> allCargoRocketEntitiesNearby = field_11863.method_8390(CargoRocketEntity.class, new class_238(field_11867).method_1014(2), CargoRocketEntity::method_5805);

        allCargoRocketEntitiesNearby = allCargoRocketEntitiesNearby.stream().filter(x -> x.method_19538().method_1022(field_11867.method_46558().method_1031(0, 0.5f, 0)) < 1f).toList();

        if(allCargoRocketEntitiesNearby.size() != 1){
            return null;
        }

        return allCargoRocketEntitiesNearby.get(0);
    }

    public @Nullable LaunchFailReason launch(String planet) {
        @Nullable CargoRocketEntity rocket = getRocket();

        if(rocket == null){
            return LaunchFailReason.NO_ROCKET;
        }

        if(!getValidDestinations().contains(planet)){
            return LaunchFailReason.INVALID_PLANET;
        }

        if(getEnergyRequiredForLaunch() > _energyStorage.amount){
            return LaunchFailReason.NOT_ENOUGH_ENERGY;
        }

        // TODO - validate rocket tier for planet

        rocket.targetPlanet = planet;
        _energyStorage.amount -= getEnergyRequiredForLaunch();

        return null;
    }

    public int getEnergyRequiredForLaunch() {
        return 10000;
    }

    public long getEnergy(){
        return _energyStorage.amount;
    }

    public long getMaxEnergy(){
        return _energyStorage.capacity;
    }

    public List<String> getValidDestinations(){
        assert field_11863 != null;
        var worlds = Objects.requireNonNull(field_11863.method_8503()).method_3738();

        List<String> validDestinations = new ArrayList<>();

        for(var otherWorld : worlds){
            String dimId = otherWorld.method_27983().method_29177().toString();
            if(dimId.contains("astra")) {// TODO - uncomment for release
                validDestinations.add(dimId);
            }
        }

        return validDestinations;
    }
}
