/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotExecutionListenerDispatch;
import com.oracle.truffle.polyglot.PolyglotImpl;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.Truffle;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.EventBinding;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.EventContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Instrumenter;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.StandardTags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionDescriptors;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.SandboxPolicy;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.io.ProcessHandler;

final class PolyglotEngineDispatch
extends AbstractPolyglotImpl.AbstractEngineDispatch {
    private final PolyglotImpl polyglot;

    protected PolyglotEngineDispatch(PolyglotImpl polyglot) {
        super(polyglot);
        this.polyglot = polyglot;
    }

    @Override
    public void setAPI(Object oreceiver, Object engine) {
        ((PolyglotEngineImpl)oreceiver).api = engine;
    }

    @Override
    public Object requirePublicLanguage(Object oreceiver, String id) {
        PolyglotEngineImpl receiver = (PolyglotEngineImpl)oreceiver;
        try {
            return receiver.requirePublicLanguage(id);
        }
        catch (Throwable t2) {
            throw PolyglotImpl.guestToHostException(receiver, t2);
        }
    }

    @Override
    public Object requirePublicInstrument(Object oreceiver, String id) {
        PolyglotEngineImpl receiver = (PolyglotEngineImpl)oreceiver;
        try {
            return receiver.requirePublicInstrument(id);
        }
        catch (Throwable t2) {
            throw PolyglotImpl.guestToHostException(receiver, t2);
        }
    }

    @Override
    public void close(Object oreceiver, Object apiObject, boolean cancelIfExecuting) {
        PolyglotEngineImpl receiver = (PolyglotEngineImpl)oreceiver;
        try {
            receiver.ensureClosed(cancelIfExecuting, false);
        }
        catch (Throwable t2) {
            throw PolyglotImpl.guestToHostException(receiver, t2);
        }
    }

    @Override
    public Map<String, Object> getInstruments(Object oreceiver) {
        PolyglotEngineImpl receiver = (PolyglotEngineImpl)oreceiver;
        try {
            return receiver.getInstruments();
        }
        catch (Throwable t2) {
            throw PolyglotImpl.guestToHostException(receiver, t2);
        }
    }

    @Override
    public Map<String, Object> getLanguages(Object oreceiver) {
        PolyglotEngineImpl receiver = (PolyglotEngineImpl)oreceiver;
        try {
            return receiver.getLanguages();
        }
        catch (Throwable t2) {
            throw PolyglotImpl.guestToHostException(receiver, t2);
        }
    }

    @Override
    public OptionDescriptors getOptions(Object oreceiver) {
        PolyglotEngineImpl receiver = (PolyglotEngineImpl)oreceiver;
        try {
            return receiver.getOptions();
        }
        catch (Throwable t2) {
            throw PolyglotImpl.guestToHostException(receiver, t2);
        }
    }

    @Override
    public Object createContext(Object oreceiver, SandboxPolicy sandboxPolicy, OutputStream out, OutputStream err, InputStream in, boolean allowHostLookup, Object hostAccess, Object polyglotAccess, boolean allowNativeAccess, boolean allowCreateThread, boolean allowHostClassLoading, boolean allowInnerContextOptions, boolean allowExperimentalOptions, Predicate<String> classFilter, Map<String, String> options, Map<String, String[]> arguments, String[] onlyLanguages, Object ioAccess, Object logHandler, boolean allowCreateProcess, ProcessHandler processHandler, Object environmentAccess, Map<String, String> environment, ZoneId zone, Object limitsImpl, String currentWorkingDirectory, String tmpDir, ClassLoader hostClassLoader, boolean allowValueSharing, boolean useSystemExit) {
        PolyglotEngineImpl receiver = (PolyglotEngineImpl)oreceiver;
        PolyglotContextImpl context = receiver.createContext(sandboxPolicy, out, err, in, allowHostLookup, hostAccess, polyglotAccess, allowNativeAccess, allowCreateThread, allowHostClassLoading, allowInnerContextOptions, allowExperimentalOptions, classFilter, options, arguments, onlyLanguages, ioAccess, logHandler, allowCreateProcess, processHandler, environmentAccess, environment, zone, limitsImpl, currentWorkingDirectory, tmpDir, hostClassLoader, allowValueSharing, useSystemExit);
        return this.polyglot.getAPIAccess().newContext(this.polyglot.contextDispatch, context, context.engine.api);
    }

    @Override
    public String getImplementationName(Object oreceiver) {
        PolyglotEngineImpl receiver = (PolyglotEngineImpl)oreceiver;
        try {
            return Truffle.getRuntime().getName();
        }
        catch (Throwable t2) {
            throw PolyglotImpl.guestToHostException(receiver, t2);
        }
    }

    @Override
    public Set<Object> getCachedSources(Object oreceiver) {
        PolyglotEngineImpl receiver = (PolyglotEngineImpl)oreceiver;
        try {
            return receiver.getCachedSources();
        }
        catch (Throwable t2) {
            throw PolyglotImpl.guestToHostException(receiver, t2);
        }
    }

    @Override
    public String getVersion(Object oreceiver) {
        PolyglotEngineImpl receiver = (PolyglotEngineImpl)oreceiver;
        try {
            return receiver.getVersion();
        }
        catch (Throwable t2) {
            throw PolyglotImpl.guestToHostException(receiver, t2);
        }
    }

    @Override
    public Object attachExecutionListener(Object engineReceiver, Consumer<Object> onEnter, Consumer<Object> onReturn, boolean expressions, boolean statements, boolean roots, final Predicate<Object> sourceFilter, final Predicate<String> rootFilter, boolean collectInputValues, boolean collectReturnValues, boolean collectExceptions) {
        EventBinding<ExecutionEventNodeFactory> binding;
        final PolyglotEngineImpl engine = (PolyglotEngineImpl)engineReceiver;
        if (engine.sandboxPolicy.isStricterOrEqual(SandboxPolicy.CONSTRAINED)) {
            throw PolyglotImpl.sandboxPolicyException(engine.sandboxPolicy, "ExecutionListener is attached to an Engine, but execution listeners are not allowed.", "do not attach execution listeners to this engine");
        }
        Instrumenter instrumenter = (Instrumenter)EngineAccessor.INSTRUMENT.getEngineInstrumenter(engine.instrumentationHandler);
        ArrayList<Class<StandardTags.RootTag>> tags = new ArrayList<Class<StandardTags.RootTag>>();
        if (expressions) {
            tags.add(StandardTags.ExpressionTag.class);
        }
        if (statements) {
            tags.add(StandardTags.StatementTag.class);
        }
        if (roots) {
            tags.add(StandardTags.RootTag.class);
        }
        if (tags.isEmpty()) {
            throw new IllegalArgumentException("No elements specified to listen to for execution listener. Need to specify at least one element kind: expressions, statements or roots.");
        }
        if (onReturn == null && onEnter == null) {
            throw new IllegalArgumentException("At least one event consumer must be provided for onEnter or onReturn.");
        }
        SourceSectionFilter.Builder filterBuilder = SourceSectionFilter.newBuilder().tagIs(tags.toArray(new Class[0]));
        filterBuilder.includeInternal(false);
        final PolyglotExecutionListenerDispatch.ListenerImpl config = new PolyglotExecutionListenerDispatch.ListenerImpl(this.polyglot.getExecutionEventDispatch(), engine, onEnter, onReturn, collectInputValues, collectReturnValues, collectExceptions);
        filterBuilder.sourceIs(new SourceSectionFilter.SourcePredicate(){
            final /* synthetic */ PolyglotEngineDispatch this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(Source s2) {
                String language = s2.getLanguage();
                if (language == null) {
                    return false;
                }
                if (!engine.idToLanguage.containsKey(language)) {
                    return false;
                }
                if (sourceFilter != null) {
                    try {
                        return sourceFilter.test(PolyglotImpl.getOrCreatePolyglotSource(this.this$0.polyglot, s2));
                    }
                    catch (Throwable e2) {
                        if (config.closing) {
                            return false;
                        }
                        throw engine.host.toHostException(null, e2);
                    }
                }
                return true;
            }
        });
        if (rootFilter != null) {
            filterBuilder.rootNameIs(new Predicate<String>(){
                final /* synthetic */ PolyglotEngineDispatch this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public boolean test(String s2) {
                    try {
                        return rootFilter.test(s2);
                    }
                    catch (Throwable e2) {
                        if (config.closing) {
                            return false;
                        }
                        throw engine.host.toHostException(null, e2);
                    }
                }
            });
        }
        SourceSectionFilter filter = filterBuilder.build();
        try {
            boolean mayNeedInputValues = config.collectInputValues && config.onReturn != null;
            boolean mayNeedReturnValue = config.collectReturnValues && config.onReturn != null;
            boolean mayNeedExceptions = config.collectExceptions;
            binding = mayNeedInputValues || mayNeedReturnValue || mayNeedExceptions ? instrumenter.attachExecutionEventFactory(filter, mayNeedInputValues ? filter : null, new ExecutionEventNodeFactory(){
                final /* synthetic */ PolyglotEngineDispatch this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ExecutionEventNode create(EventContext context) {
                    return new PolyglotExecutionListenerDispatch.ProfilingNode(config, context);
                }
            }) : instrumenter.attachExecutionEventFactory(filter, null, new ExecutionEventNodeFactory(){
                final /* synthetic */ PolyglotEngineDispatch this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ExecutionEventNode create(EventContext context) {
                    return new PolyglotExecutionListenerDispatch.DefaultNode(config, context);
                }
            });
        }
        catch (Throwable t2) {
            throw PolyglotImpl.guestToHostException(engine, t2);
        }
        config.binding = binding;
        return this.polyglot.getManagement().newExecutionListener(this.polyglot.getExecutionListenerDispatch(), config);
    }

    @Override
    public void shutdown(Object engine) {
        ((PolyglotEngineImpl)engine).onVMShutdown();
    }

    @Override
    public RuntimeException hostToGuestException(Object engineReceiver, Throwable throwable) {
        return PolyglotImpl.hostToGuestException((PolyglotEngineImpl)engineReceiver, throwable);
    }

    @Override
    public SandboxPolicy getSandboxPolicy(Object engineReceiver) {
        return ((PolyglotEngineImpl)engineReceiver).sandboxPolicy;
    }
}

