/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotExceptionImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleFile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleStackTraceElement;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.LanguageInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.RootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.SourceSection;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class PolyglotExceptionFrame
extends AbstractPolyglotImpl.AbstractStackFrameImpl {
    final PolyglotLanguage language;
    private final Object sourceLocation;
    private final String rootName;
    private final boolean host;
    private StackTraceElement stackTrace;
    private final String formattedSource;
    private final int bytecodeIndex;

    private PolyglotExceptionFrame(PolyglotExceptionImpl source, PolyglotLanguage language, Object sourceLocation, String rootName, boolean isHost, StackTraceElement stackTrace, int bytecodeIndex) {
        super(source.polyglot);
        this.language = language;
        this.sourceLocation = sourceLocation;
        this.bytecodeIndex = bytecodeIndex;
        this.rootName = rootName;
        this.host = isHost;
        this.stackTrace = stackTrace;
        if (!isHost) {
            SourceSection sourceSection = sourceLocation != null ? (SourceSection)source.polyglot.getAPIAccess().getSourceSectionReceiver(sourceLocation) : null;
            this.formattedSource = PolyglotExceptionFrame.formatSource(sourceSection, language != null ? source.getFileSystemContext(language) : null);
        } else {
            this.formattedSource = null;
        }
    }

    @Override
    public Object getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public int getBytecodeIndex() {
        return this.bytecodeIndex;
    }

    @Override
    public Object getLanguage() {
        return this.language.api;
    }

    @Override
    public String getRootName() {
        return this.rootName;
    }

    @Override
    public boolean isHostFrame() {
        return this.host;
    }

    @Override
    public StackTraceElement toHostFrame() {
        if (this.stackTrace == null) {
            Object declaringClass = this.language != null ? "<" + this.language.getId() + ">" : "";
            String methodName = this.rootName == null ? "" : this.rootName;
            SourceSection sourceSection = this.sourceLocation != null ? (SourceSection)this.language.getAPIAccess().getSourceSectionReceiver(this.sourceLocation) : null;
            String fileName = sourceSection != null ? sourceSection.getSource().getName() : "Unknown";
            int startLine = sourceSection != null ? sourceSection.getStartLine() : -1;
            this.stackTrace = new StackTraceElement((String)declaringClass, methodName, fileName, startLine);
        }
        return this.stackTrace;
    }

    @Override
    public String toStringImpl(int langColumn) {
        StringBuilder b2 = new StringBuilder();
        if (this.isHostFrame()) {
            String languageId = "";
        } else {
            String languageId = this.language.getId();
            b2.append(PolyglotExceptionFrame.spaces(Math.max(langColumn, languageId.length()) - languageId.length())).append("<").append(languageId).append("> ");
        }
        if (this.isHostFrame()) {
            b2.append(this.stackTrace.toString());
        } else {
            b2.append(this.rootName);
            b2.append("(");
            assert (this.formattedSource != null);
            b2.append(this.formattedSource);
            b2.append(")");
        }
        return b2.toString();
    }

    static PolyglotExceptionFrame createGuest(PolyglotExceptionImpl exception, TruffleStackTraceElement frame, boolean first) {
        if (frame == null) {
            return null;
        }
        RootNode targetRoot = frame.getTarget().getRootNode();
        if (targetRoot.isInternal() && !exception.showInternalStackFrames) {
            return null;
        }
        LanguageInfo info = targetRoot.getLanguageInfo();
        if (info == null) {
            return null;
        }
        PolyglotEngineImpl engine = exception.engine;
        PolyglotLanguage language = null;
        Object location = null;
        String rootName = targetRoot.getName();
        if (engine != null) {
            language = engine.idToLanguage.get(info.getId());
            Node callNode = frame.getLocation();
            if (callNode != null) {
                SourceSection section = callNode.getEncapsulatingSourceSection();
                if (section != null) {
                    Object source = engine.getAPIAccess().newSource(exception.polyglot.getSourceDispatch(), section.getSource());
                    location = engine.getAPIAccess().newSourceSection(source, exception.polyglot.getSourceSectionDispatch(), section);
                } else {
                    location = null;
                }
            } else {
                location = first ? exception.getSourceLocation() : null;
            }
        }
        return new PolyglotExceptionFrame(exception, language, location, rootName, false, null, frame.getBytecodeIndex());
    }

    static PolyglotExceptionFrame createHost(PolyglotExceptionImpl exception, StackTraceElement hostStack) {
        PolyglotLanguage language = exception.engine != null ? exception.engine.hostLanguage : null;
        Object location = null;
        String rootname = hostStack.getClassName() + "." + hostStack.getMethodName();
        return new PolyglotExceptionFrame(exception, language, location, rootname, true, hostStack, -1);
    }

    private static String spaces(int length) {
        StringBuilder b2 = new StringBuilder();
        for (int i2 = 0; i2 < length; ++i2) {
            b2.append(' ');
        }
        return b2.toString();
    }

    private static String formatSource(SourceSection sourceSection, Object fileSystemContext) {
        if (sourceSection == null) {
            return "Unknown";
        }
        Source source = sourceSection.getSource();
        if (source == null) {
            return "Unknown";
        }
        StringBuilder b2 = new StringBuilder();
        String path = source.getPath();
        if (path == null) {
            b2.append(source.getName());
        } else if (fileSystemContext != null) {
            try {
                TruffleFile pathAbsolute = EngineAccessor.LANGUAGE.getTruffleFile(path, fileSystemContext);
                TruffleFile pathBase = EngineAccessor.LANGUAGE.getTruffleFile("", fileSystemContext).getAbsoluteFile();
                TruffleFile pathRelative = pathBase.relativize(pathAbsolute);
                b2.append(pathRelative.getPath());
            }
            catch (IllegalArgumentException | SecurityException | UnsupportedOperationException e2) {
                b2.append(path);
            }
        } else {
            b2.append(path);
        }
        b2.append(":").append(PolyglotExceptionFrame.formatIndices(sourceSection, true));
        return b2.toString();
    }

    private static String formatIndices(SourceSection sourceSection, boolean needsColumnSpecifier) {
        boolean singleLine;
        StringBuilder b2 = new StringBuilder();
        boolean bl = singleLine = sourceSection.getStartLine() == sourceSection.getEndLine();
        if (singleLine) {
            b2.append(sourceSection.getStartLine());
        } else {
            b2.append(sourceSection.getStartLine()).append("-").append(sourceSection.getEndLine());
        }
        if (needsColumnSpecifier) {
            b2.append(":");
            if (sourceSection.getCharLength() <= 1) {
                b2.append(sourceSection.getCharIndex());
            } else {
                b2.append(sourceSection.getCharIndex()).append("-").append(sourceSection.getCharIndex() + sourceSection.getCharLength() - 1);
            }
        }
        return b2.toString();
    }
}

