/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.EnterpriseEngineOptions;
import java.util.Iterator;
import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleOptionDescriptors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GeneratedBy;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionCategory;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionDescriptor;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionStability;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.SandboxPolicy;

@GeneratedBy(value=EnterpriseEngineOptions.class)
final class EnterpriseEngineOptionsOptionDescriptors
implements TruffleOptionDescriptors {
    EnterpriseEngineOptionsOptionDescriptors() {
    }

    @Override
    public OptionDescriptor get(String string) {
        if (string.startsWith("engine.IsolateOption.") || string.equals("engine.IsolateOption")) {
            return OptionDescriptor.newBuilder(EnterpriseEngineOptions.IsolateOption, "engine.IsolateOption").deprecated(false).help("Isolate VM options.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
        }
        switch (string) {
            case "engine.HostCallStackHeadRoom": {
                return OptionDescriptor.newBuilder(EnterpriseEngineOptions.HostCallStackHeadRoom, "engine.HostCallStackHeadRoom").deprecated(false).help("Stack space headroom for calls to the host.").usageSyntax("[1, inf)<B>|<KB>|<MB>|<GB>").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            }
            case "engine.InterpreterCallStackHeadRoom": {
                return OptionDescriptor.newBuilder(EnterpriseEngineOptions.InterpreterCallStackHeadRoom, "engine.InterpreterCallStackHeadRoom").deprecated(false).help("Stack space headroom for any interpreter call. Supported only in the AOT mode.").usageSyntax("[0, inf)<B>|<KB>|<MB>|<GB>").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            }
            case "engine.IsolateLibrary": {
                return OptionDescriptor.newBuilder(EnterpriseEngineOptions.IsolateLibrary, "engine.IsolateLibrary").deprecated(false).help("Path to the isolate library.").usageSyntax("<path>").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.IsolateMemoryProtection": {
                return OptionDescriptor.newBuilder(EnterpriseEngineOptions.IsolateMemoryProtection, "engine.IsolateMemoryProtection").deprecated(false).help("Enable memory protection for the isolate.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.MaxIsolateMemory": {
                return OptionDescriptor.newBuilder(EnterpriseEngineOptions.MaxIsolateMemory, "engine.MaxIsolateMemory").deprecated(false).help("Set maximum polyglot isolate heap size. This is a hard limit for the size of the isolate heap including both guest applications retained data and data allocated by the runtime.").usageSyntax("[32MB, inf)<B>|<KB>|<MB>|<GB>").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "engine.SpawnIsolate": {
                return OptionDescriptor.newBuilder(EnterpriseEngineOptions.SpawnIsolate, "engine.SpawnIsolate").deprecated(false).help("Spawn an isolate with isolated heap for this engine. Can be set to true or false or to the set of languages that should be initialized.").usageSyntax("true|false|<language>,<language>,...").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "engine.UntrustedCodeMitigation": {
                return OptionDescriptor.newBuilder(EnterpriseEngineOptions.UntrustedCodeMitigation, "engine.UntrustedCodeMitigation").deprecated(false).help("Enable untrusted code execution defenses.").usageSyntax("none|hardware|software").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
        }
        return null;
    }

    @Override
    public SandboxPolicy getSandboxPolicy(String string) {
        assert (this.get(string) != null) : "Unknown option " + string;
        if (string.startsWith("engine.IsolateOption.") || string.equals("engine.IsolateOption")) {
            return SandboxPolicy.CONSTRAINED;
        }
        return SandboxPolicy.UNTRUSTED;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return List.of(OptionDescriptor.newBuilder(EnterpriseEngineOptions.HostCallStackHeadRoom, "engine.HostCallStackHeadRoom").deprecated(false).help("Stack space headroom for calls to the host.").usageSyntax("[1, inf)<B>|<KB>|<MB>|<GB>").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EnterpriseEngineOptions.InterpreterCallStackHeadRoom, "engine.InterpreterCallStackHeadRoom").deprecated(false).help("Stack space headroom for any interpreter call. Supported only in the AOT mode.").usageSyntax("[0, inf)<B>|<KB>|<MB>|<GB>").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EnterpriseEngineOptions.IsolateLibrary, "engine.IsolateLibrary").deprecated(false).help("Path to the isolate library.").usageSyntax("<path>").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EnterpriseEngineOptions.IsolateMemoryProtection, "engine.IsolateMemoryProtection").deprecated(false).help("Enable memory protection for the isolate.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EnterpriseEngineOptions.IsolateOption, "engine.IsolateOption").deprecated(false).help("Isolate VM options.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EnterpriseEngineOptions.MaxIsolateMemory, "engine.MaxIsolateMemory").deprecated(false).help("Set maximum polyglot isolate heap size. This is a hard limit for the size of the isolate heap including both guest applications retained data and data allocated by the runtime.").usageSyntax("[32MB, inf)<B>|<KB>|<MB>|<GB>").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EnterpriseEngineOptions.SpawnIsolate, "engine.SpawnIsolate").deprecated(false).help("Spawn an isolate with isolated heap for this engine. Can be set to true or false or to the set of languages that should be initialized.").usageSyntax("true|false|<language>,<language>,...").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EnterpriseEngineOptions.UntrustedCodeMitigation, "engine.UntrustedCodeMitigation").deprecated(false).help("Enable untrusted code execution defenses.").usageSyntax("none|hardware|software").category(OptionCategory.USER).stability(OptionStability.STABLE).build()).iterator();
    }
}

