/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.HSDirectoryStream;
import com.oracle.truffle.polyglot.enterprise.HSPathIteratorGen;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Iterator;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNI;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNICalls;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIEntryPoint;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIMethodScope;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryMarshaller;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.ForeignException;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIClassCache;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIConfig;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.StackValue;

final class HSDirectoryStreamGen {
    HSDirectoryStreamGen() {
    }

    static HSDirectoryStream createNativeToHS(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
        return new StartPoint(jNIEnv, jObject);
    }

    private static final class StartPoint
    extends HSDirectoryStream {
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        final JNIData jniMethods_;

        StartPoint(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
            super(jNIEnv, jObject);
            JNIData jNIData = JNIData.cache_;
            if (jNIData == null) {
                jNIData = JNIData.cache_ = new JNIData(jNIEnv);
            }
            this.jniMethods_ = jNIData;
        }

        @Override
        public void close() throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.closeMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public Iterator<Path> iterator() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.iteratorMethod, jValue);
                return r2.isNonNull() ? HSPathIteratorGen.createNativeToHS(jNIEnv, r2) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }

        static final class JNIData {
            static JNIData cache_;
            final JNI.JClass endPointClass;
            final JNICalls.JNIMethod closeMethod;
            final JNICalls.JNIMethod iteratorMethod;

            JNIData(JNI.JNIEnv jNIEnv) {
                this.endPointClass = JNIClassCache.lookupClass(jNIEnv, EndPoint.class);
                this.closeMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "close", "(Ljava/nio/file/DirectoryStream;)V");
                this.iteratorMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "iterator", "(Ljava/nio/file/DirectoryStream;)Ljava/util/Iterator;");
            }
        }
    }

    private static class EndPoint {
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @JNIEntryPoint
        static void close(DirectoryStream<Path> directoryStream) {
            try {
                directoryStream.close();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Iterator<Path> iterator(DirectoryStream<Path> directoryStream) {
            try {
                Iterator<Path> iterator = directoryStream.iterator();
                return iterator;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

