/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.HSHostLanguageService;
import com.oracle.truffle.polyglot.enterprise.HSPolyglotObject;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNI;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNICalls;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIEntryPoint;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIMethodScope;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIUtil;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryInput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryMarshaller;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryOutput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.ForeignException;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIClassCache;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIConfig;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.StackValue;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.UnmanagedMemory;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.type.CCharPointer;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class HSHostLanguageServiceGen {
    HSHostLanguageServiceGen() {
    }

    static HSHostLanguageService createNativeToHS(HSPolyglotObject hSPolyglotObject, AbstractPolyglotImpl abstractPolyglotImpl, JNI.JNIEnv jNIEnv) {
        return new StartPoint(hSPolyglotObject, abstractPolyglotImpl, jNIEnv);
    }

    private static final class StartPoint
    extends HSHostLanguageService {
        private static final BinaryMarshaller<Error> errorMarshaller;
        private static final BinaryMarshaller<Object> objectWithHostContextMarshaller;
        private static final BinaryMarshaller<Object> objectWithInteropObjectMarshaller;
        private static final BinaryMarshaller<Object> objectWithTruffleFileMarshaller;
        private static final BinaryMarshaller<RuntimeException> runtimeExceptionWithInteropObjectMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        private static final BinaryMarshaller<Throwable> throwableWithInteropObjectMarshaller;
        final JNIData jniMethods_;

        StartPoint(HSPolyglotObject hSPolyglotObject, AbstractPolyglotImpl abstractPolyglotImpl, JNI.JNIEnv jNIEnv) {
            super(hSPolyglotObject, abstractPolyglotImpl);
            JNIData jNIData = JNIData.cache_;
            if (jNIData == null) {
                jNIData = JNIData.cache_ = new JNIData(jNIEnv);
            }
            this.jniMethods_ = jNIData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void addToHostClassPath(Object object, Object object2) {
            try {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(512);
                int n3 = objectWithHostContextMarshaller.inferSize(object) + objectWithTruffleFileMarshaller.inferSize(object2);
                if (n3 > 512) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 512;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object3 = BinaryOutput.create(cCharPointer, n2, false);){
                        objectWithHostContextMarshaller.write((BinaryOutput)object3, object);
                        objectWithTruffleFileMarshaller.write((BinaryOutput)object3, object2);
                        int n4 = ((BinaryOutput.CCharPointerBinaryOutput)object3).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, n4);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n4, ((BinaryOutput.CCharPointerBinaryOutput)object3).getAddress());
                    }
                    object3 = StackValue.get(2, JNI.JValue.class);
                    object3.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                    object3.addressOf(1).setJObject(jByteArray);
                    ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.addToHostClassPathMethod, (JNI.JValue)object3);
                }
                finally {
                    if (cCharPointer != cCharPointer2) {
                        UnmanagedMemory.free(cCharPointer);
                    }
                }
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean allowsPublicAccess() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                return ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.allowsPublicAccessMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object createHostAdapter(Object object, Object[] objectArray, Object object2) {
            Object object32;
            block20: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(768);
                int n3 = objectWithHostContextMarshaller.inferSize(object) + 4 + (objectArray != null && objectArray.length > 0 ? objectArray.length * objectWithInteropObjectMarshaller.inferSize(objectArray[0]) : 0) + objectWithInteropObjectMarshaller.inferSize(object2);
                if (n3 > 768) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 768;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object4 = BinaryOutput.create(cCharPointer, n2, false);){
                        objectWithHostContextMarshaller.write((BinaryOutput)object4, object);
                        if (objectArray != null) {
                            ((BinaryOutput)object4).writeInt(objectArray.length);
                            for (Object object32 : objectArray) {
                                objectWithInteropObjectMarshaller.write((BinaryOutput)object4, object32);
                            }
                        } else {
                            ((BinaryOutput)object4).writeInt(-1);
                        }
                        objectWithInteropObjectMarshaller.write((BinaryOutput)object4, object2);
                        int n4 = ((BinaryOutput.CCharPointerBinaryOutput)object4).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, n4);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n4, ((BinaryOutput.CCharPointerBinaryOutput)object4).getAddress());
                    }
                    object4 = StackValue.get(2, JNI.JValue.class);
                    object4.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                    object4.addressOf(1).setJObject(jByteArray);
                    JNI.JByteArray jByteArray2 = (JNI.JByteArray)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.createHostAdapterMethod, (JNI.JValue)object4);
                    int n5 = JNIUtil.GetArrayLength(jNIEnv, jByteArray2);
                    if (n2 < n5) {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n5);
                    }
                    JNIUtil.GetByteArrayRegion(jNIEnv, jByteArray2, 0, n5, cCharPointer);
                    BinaryInput binaryInput = BinaryInput.create(cCharPointer, n5);
                    object32 = objectWithInteropObjectMarshaller.read(binaryInput);
                    if (cCharPointer == cCharPointer2) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer);
            }
            return object32;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object findStaticClass(Object object, String string) {
            Object object2;
            block17: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(256);
                int n3 = objectWithHostContextMarshaller.inferSize(object);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object3 = BinaryOutput.create(cCharPointer, n2, false);){
                        objectWithHostContextMarshaller.write((BinaryOutput)object3, object);
                        int n4 = ((BinaryOutput.CCharPointerBinaryOutput)object3).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, n4);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n4, ((BinaryOutput.CCharPointerBinaryOutput)object3).getAddress());
                    }
                    object3 = StackValue.get(3, JNI.JValue.class);
                    object3.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                    object3.addressOf(1).setJObject(JNIUtil.createHSString(jNIEnv, string));
                    object3.addressOf(2).setJObject(jByteArray);
                    JNI.JByteArray jByteArray2 = (JNI.JByteArray)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.findStaticClassMethod, (JNI.JValue)object3);
                    int n5 = JNIUtil.GetArrayLength(jNIEnv, jByteArray2);
                    if (n2 < n5) {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n5);
                    }
                    JNIUtil.GetByteArrayRegion(jNIEnv, jByteArray2, 0, n5, cCharPointer);
                    BinaryInput binaryInput = BinaryInput.create(cCharPointer, n5);
                    object2 = objectWithInteropObjectMarshaller.read(binaryInput);
                    if (cCharPointer == cCharPointer2) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer);
            }
            return object2;
        }

        @Override
        public void hostExit(int n2) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                jValue.addressOf(1).setInt(n2);
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.hostExitMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        boolean isHostExceptionImpl(Object object) {
            boolean bl;
            block15: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(256);
                int n3 = objectWithInteropObjectMarshaller.inferSize(object);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object2 = BinaryOutput.create(cCharPointer, n2, false);){
                        objectWithInteropObjectMarshaller.write((BinaryOutput)object2, object);
                        int bl2 = ((BinaryOutput.CCharPointerBinaryOutput)object2).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, bl2);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, bl2, ((BinaryOutput.CCharPointerBinaryOutput)object2).getAddress());
                    }
                    object2 = StackValue.get(2, JNI.JValue.class);
                    object2.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                    object2.addressOf(1).setJObject(jByteArray);
                    bl = ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.isHostExceptionImplMethod, (JNI.JValue)object2);
                    if (cCharPointer == cCharPointer2) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        boolean isHostFunctionImpl(Object object) {
            boolean bl;
            block15: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(256);
                int n3 = objectWithInteropObjectMarshaller.inferSize(object);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object2 = BinaryOutput.create(cCharPointer, n2, false);){
                        objectWithInteropObjectMarshaller.write((BinaryOutput)object2, object);
                        int bl2 = ((BinaryOutput.CCharPointerBinaryOutput)object2).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, bl2);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, bl2, ((BinaryOutput.CCharPointerBinaryOutput)object2).getAddress());
                    }
                    object2 = StackValue.get(2, JNI.JValue.class);
                    object2.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                    object2.addressOf(1).setJObject(jByteArray);
                    bl = ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.isHostFunctionImplMethod, (JNI.JValue)object2);
                    if (cCharPointer == cCharPointer2) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        boolean isHostObjectImpl(Object object) {
            boolean bl;
            block15: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(256);
                int n3 = objectWithInteropObjectMarshaller.inferSize(object);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object2 = BinaryOutput.create(cCharPointer, n2, false);){
                        objectWithInteropObjectMarshaller.write((BinaryOutput)object2, object);
                        int bl2 = ((BinaryOutput.CCharPointerBinaryOutput)object2).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, bl2);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, bl2, ((BinaryOutput.CCharPointerBinaryOutput)object2).getAddress());
                    }
                    object2 = StackValue.get(2, JNI.JValue.class);
                    object2.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                    object2.addressOf(1).setJObject(jByteArray);
                    bl = ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.isHostObjectImplMethod, (JNI.JValue)object2);
                    if (cCharPointer == cCharPointer2) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        boolean isHostProxyImpl(Object object) {
            boolean bl;
            block15: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(256);
                int n3 = objectWithInteropObjectMarshaller.inferSize(object);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object2 = BinaryOutput.create(cCharPointer, n2, false);){
                        objectWithInteropObjectMarshaller.write((BinaryOutput)object2, object);
                        int bl2 = ((BinaryOutput.CCharPointerBinaryOutput)object2).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, bl2);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, bl2, ((BinaryOutput.CCharPointerBinaryOutput)object2).getAddress());
                    }
                    object2 = StackValue.get(2, JNI.JValue.class);
                    object2.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                    object2.addressOf(1).setJObject(jByteArray);
                    bl = ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.isHostProxyImplMethod, (JNI.JValue)object2);
                    if (cCharPointer == cCharPointer2) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        boolean isHostSymbolImpl(Object object) {
            boolean bl;
            block15: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(256);
                int n3 = objectWithInteropObjectMarshaller.inferSize(object);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object2 = BinaryOutput.create(cCharPointer, n2, false);){
                        objectWithInteropObjectMarshaller.write((BinaryOutput)object2, object);
                        int bl2 = ((BinaryOutput.CCharPointerBinaryOutput)object2).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, bl2);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, bl2, ((BinaryOutput.CCharPointerBinaryOutput)object2).getAddress());
                    }
                    object2 = StackValue.get(2, JNI.JValue.class);
                    object2.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                    object2.addressOf(1).setJObject(jByteArray);
                    bl = ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.isHostSymbolImplMethod, (JNI.JValue)object2);
                    if (cCharPointer == cCharPointer2) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer);
            }
            return bl;
        }

        @Override
        public void throwHostLanguageException(String string) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                jValue.addressOf(1).setJObject(JNIUtil.createHSString(jNIEnv, string));
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.throwHostLanguageExceptionMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public RuntimeException toHostException(Object object, Throwable throwable) {
            RuntimeException runtimeException;
            block17: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(512);
                int n3 = objectWithHostContextMarshaller.inferSize(object) + throwableMarshaller.inferSize(throwable);
                if (n3 > 512) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 512;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object2 = BinaryOutput.create(cCharPointer, n2, false);){
                        objectWithHostContextMarshaller.write((BinaryOutput)object2, object);
                        throwableMarshaller.write((BinaryOutput)object2, throwable);
                        int n4 = ((BinaryOutput.CCharPointerBinaryOutput)object2).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, n4);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n4, ((BinaryOutput.CCharPointerBinaryOutput)object2).getAddress());
                    }
                    object2 = StackValue.get(2, JNI.JValue.class);
                    object2.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                    object2.addressOf(1).setJObject(jByteArray);
                    JNI.JByteArray jByteArray2 = (JNI.JByteArray)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.toHostExceptionMethod, (JNI.JValue)object2);
                    int n5 = JNIUtil.GetArrayLength(jNIEnv, jByteArray2);
                    if (n2 < n5) {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n5);
                    }
                    JNIUtil.GetByteArrayRegion(jNIEnv, jByteArray2, 0, n5, cCharPointer);
                    BinaryInput binaryInput = BinaryInput.create(cCharPointer, n5);
                    runtimeException = runtimeExceptionWithInteropObjectMarshaller.read(binaryInput);
                    if (cCharPointer == cCharPointer2) break block17;
                }
                catch (Throwable throwable2) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        throw throwable2;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer);
            }
            return runtimeException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Error toHostResourceError(Throwable throwable) {
            Error error;
            block17: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(256);
                int n3 = throwableWithInteropObjectMarshaller.inferSize(throwable);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object = BinaryOutput.create(cCharPointer, n2, false);){
                        throwableWithInteropObjectMarshaller.write((BinaryOutput)object, throwable);
                        int n4 = ((BinaryOutput.CCharPointerBinaryOutput)object).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, n4);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n4, ((BinaryOutput.CCharPointerBinaryOutput)object).getAddress());
                    }
                    object = StackValue.get(2, JNI.JValue.class);
                    object.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                    object.addressOf(1).setJObject(jByteArray);
                    JNI.JByteArray jByteArray2 = (JNI.JByteArray)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.toHostResourceErrorMethod, (JNI.JValue)object);
                    int n5 = JNIUtil.GetArrayLength(jNIEnv, jByteArray2);
                    if (n2 < n5) {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n5);
                    }
                    JNIUtil.GetByteArrayRegion(jNIEnv, jByteArray2, 0, n5, cCharPointer);
                    BinaryInput binaryInput = BinaryInput.create(cCharPointer, n5);
                    error = errorMarshaller.read(binaryInput);
                    if (cCharPointer == cCharPointer2) break block17;
                }
                catch (Throwable throwable2) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        throw throwable2;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer);
            }
            return error;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Throwable unboxHostException(Throwable throwable) {
            Throwable throwable2;
            block17: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(256);
                int n3 = throwableWithInteropObjectMarshaller.inferSize(throwable);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object = BinaryOutput.create(cCharPointer, n2, false);){
                        throwableWithInteropObjectMarshaller.write((BinaryOutput)object, throwable);
                        int n4 = ((BinaryOutput.CCharPointerBinaryOutput)object).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, n4);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n4, ((BinaryOutput.CCharPointerBinaryOutput)object).getAddress());
                    }
                    object = StackValue.get(2, JNI.JValue.class);
                    object.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                    object.addressOf(1).setJObject(jByteArray);
                    JNI.JByteArray jByteArray2 = (JNI.JByteArray)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.unboxHostExceptionMethod, (JNI.JValue)object);
                    int n5 = JNIUtil.GetArrayLength(jNIEnv, jByteArray2);
                    if (n2 < n5) {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n5);
                    }
                    JNIUtil.GetByteArrayRegion(jNIEnv, jByteArray2, 0, n5, cCharPointer);
                    BinaryInput binaryInput = BinaryInput.create(cCharPointer, n5);
                    throwable2 = throwableMarshaller.read(binaryInput);
                    if (cCharPointer == cCharPointer2) break block17;
                }
                catch (Throwable throwable3) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        throw throwable3;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer);
            }
            return throwable2;
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            errorMarshaller = jNIConfig.lookupMarshaller(Error.class, new Class[0]);
            objectWithHostContextMarshaller = jNIConfig.lookupMarshaller(Object.class, PolyglotJNIConfig.HostContext.class);
            objectWithInteropObjectMarshaller = jNIConfig.lookupMarshaller(Object.class, PolyglotJNIConfig.InteropObject.class);
            objectWithTruffleFileMarshaller = jNIConfig.lookupMarshaller(Object.class, PolyglotJNIConfig.TruffleFile.class);
            runtimeExceptionWithInteropObjectMarshaller = jNIConfig.lookupMarshaller(RuntimeException.class, PolyglotJNIConfig.InteropObject.class);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
            throwableWithInteropObjectMarshaller = jNIConfig.lookupMarshaller(Throwable.class, PolyglotJNIConfig.InteropObject.class);
        }

        static final class JNIData {
            static JNIData cache_;
            final JNI.JClass endPointClass;
            final JNICalls.JNIMethod addToHostClassPathMethod;
            final JNICalls.JNIMethod allowsPublicAccessMethod;
            final JNICalls.JNIMethod createHostAdapterMethod;
            final JNICalls.JNIMethod findStaticClassMethod;
            final JNICalls.JNIMethod hostExitMethod;
            final JNICalls.JNIMethod isHostExceptionImplMethod;
            final JNICalls.JNIMethod isHostFunctionImplMethod;
            final JNICalls.JNIMethod isHostObjectImplMethod;
            final JNICalls.JNIMethod isHostProxyImplMethod;
            final JNICalls.JNIMethod isHostSymbolImplMethod;
            final JNICalls.JNIMethod throwHostLanguageExceptionMethod;
            final JNICalls.JNIMethod toHostExceptionMethod;
            final JNICalls.JNIMethod toHostResourceErrorMethod;
            final JNICalls.JNIMethod unboxHostExceptionMethod;

            JNIData(JNI.JNIEnv jNIEnv) {
                this.endPointClass = JNIClassCache.lookupClass(jNIEnv, EndPoint.class);
                this.addToHostClassPathMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "addToHostClassPath", "(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;[B)V");
                this.allowsPublicAccessMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "allowsPublicAccess", "(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;)Z");
                this.createHostAdapterMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "createHostAdapter", "(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;[B)[B");
                this.findStaticClassMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "findStaticClass", "(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;Ljava/lang/String;[B)[B");
                this.hostExitMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "hostExit", "(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;I)V");
                this.isHostExceptionImplMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "isHostExceptionImpl", "(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;[B)Z");
                this.isHostFunctionImplMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "isHostFunctionImpl", "(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;[B)Z");
                this.isHostObjectImplMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "isHostObjectImpl", "(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;[B)Z");
                this.isHostProxyImplMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "isHostProxyImpl", "(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;[B)Z");
                this.isHostSymbolImplMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "isHostSymbolImpl", "(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;[B)Z");
                this.throwHostLanguageExceptionMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "throwHostLanguageException", "(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;Ljava/lang/String;)V");
                this.toHostExceptionMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "toHostException", "(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;[B)[B");
                this.toHostResourceErrorMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "toHostResourceError", "(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;[B)[B");
                this.unboxHostExceptionMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "unboxHostException", "(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;[B)[B");
            }
        }
    }

    private static class EndPoint {
        private static final BinaryMarshaller<Error> errorMarshaller;
        private static final BinaryMarshaller<Object> objectWithHostContextMarshaller;
        private static final BinaryMarshaller<Object> objectWithInteropObjectMarshaller;
        private static final BinaryMarshaller<Object> objectWithTruffleFileMarshaller;
        private static final BinaryMarshaller<RuntimeException> runtimeExceptionWithInteropObjectMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        private static final BinaryMarshaller<Throwable> throwableWithInteropObjectMarshaller;

        private EndPoint() {
        }

        @JNIEntryPoint
        static void addToHostClassPath(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create(byArray);
                Object object = objectWithHostContextMarshaller.read(binaryInput);
                Object object2 = objectWithTruffleFileMarshaller.read(binaryInput);
                abstractHostLanguageService.addToHostClassPath(object, object2);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean allowsPublicAccess(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService) {
            try {
                boolean bl = abstractHostLanguageService.allowsPublicAccess();
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static byte[] createHostAdapter(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, byte[] byArray) {
            try {
                Object object;
                int n2;
                Object object2;
                Object[] objectArray;
                BinaryInput binaryInput = BinaryInput.create(byArray);
                Object object3 = objectWithHostContextMarshaller.read(binaryInput);
                int n3 = binaryInput.readInt();
                if (n3 != -1) {
                    objectArray = new Object[n3];
                    for (int i2 = 0; i2 < n3; ++i2) {
                        objectArray[i2] = object2 = objectWithInteropObjectMarshaller.read(binaryInput);
                    }
                } else {
                    objectArray = null;
                }
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = (n2 = objectWithInteropObjectMarshaller.inferSize(object2 = abstractHostLanguageService.createHostAdapter(object3, objectArray, object = objectWithInteropObjectMarshaller.read(binaryInput)))) > byArray.length ? BinaryOutput.ByteArrayBinaryOutput.create(n2) : BinaryOutput.create(byArray);
                objectWithInteropObjectMarshaller.write(byteArrayBinaryOutput, object2);
                return byteArrayBinaryOutput.getArray();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static byte[] findStaticClass(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, String string, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create(byArray);
                Object object = objectWithHostContextMarshaller.read(binaryInput);
                Object object2 = abstractHostLanguageService.findStaticClass(object, string);
                int n2 = objectWithInteropObjectMarshaller.inferSize(object2);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = n2 > byArray.length ? BinaryOutput.ByteArrayBinaryOutput.create(n2) : BinaryOutput.create(byArray);
                objectWithInteropObjectMarshaller.write(byteArrayBinaryOutput, object2);
                return byteArrayBinaryOutput.getArray();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void hostExit(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, int n2) {
            try {
                abstractHostLanguageService.hostExit(n2);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean isHostExceptionImpl(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create(byArray);
                Object object = objectWithInteropObjectMarshaller.read(binaryInput);
                boolean bl = abstractHostLanguageService.isHostException(object);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean isHostFunctionImpl(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create(byArray);
                Object object = objectWithInteropObjectMarshaller.read(binaryInput);
                boolean bl = abstractHostLanguageService.isHostFunction(object);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean isHostObjectImpl(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create(byArray);
                Object object = objectWithInteropObjectMarshaller.read(binaryInput);
                boolean bl = abstractHostLanguageService.isHostObject(object);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean isHostProxyImpl(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create(byArray);
                Object object = objectWithInteropObjectMarshaller.read(binaryInput);
                boolean bl = abstractHostLanguageService.isHostProxy(object);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean isHostSymbolImpl(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create(byArray);
                Object object = objectWithInteropObjectMarshaller.read(binaryInput);
                boolean bl = abstractHostLanguageService.isHostSymbol(object);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void throwHostLanguageException(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, String string) {
            try {
                abstractHostLanguageService.throwHostLanguageException(string);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static byte[] toHostException(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create(byArray);
                Object object = objectWithHostContextMarshaller.read(binaryInput);
                Throwable throwable = throwableMarshaller.read(binaryInput);
                RuntimeException runtimeException = abstractHostLanguageService.toHostException(object, throwable);
                int n2 = runtimeExceptionWithInteropObjectMarshaller.inferSize(runtimeException);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = n2 > byArray.length ? BinaryOutput.ByteArrayBinaryOutput.create(n2) : BinaryOutput.create(byArray);
                runtimeExceptionWithInteropObjectMarshaller.write(byteArrayBinaryOutput, runtimeException);
                return byteArrayBinaryOutput.getArray();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static byte[] toHostResourceError(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create(byArray);
                Throwable throwable = throwableWithInteropObjectMarshaller.read(binaryInput);
                Error error = abstractHostLanguageService.toHostResourceError(throwable);
                int n2 = errorMarshaller.inferSize(error);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = n2 > byArray.length ? BinaryOutput.ByteArrayBinaryOutput.create(n2) : BinaryOutput.create(byArray);
                errorMarshaller.write(byteArrayBinaryOutput, error);
                return byteArrayBinaryOutput.getArray();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static byte[] unboxHostException(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create(byArray);
                Throwable throwable = throwableWithInteropObjectMarshaller.read(binaryInput);
                Throwable throwable2 = abstractHostLanguageService.unboxHostException(throwable);
                int n2 = throwableMarshaller.inferSize(throwable2);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = n2 > byArray.length ? BinaryOutput.ByteArrayBinaryOutput.create(n2) : BinaryOutput.create(byArray);
                throwableMarshaller.write(byteArrayBinaryOutput, throwable2);
                return byteArrayBinaryOutput.getArray();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            errorMarshaller = jNIConfig.lookupMarshaller(Error.class, new Class[0]);
            objectWithHostContextMarshaller = jNIConfig.lookupMarshaller(Object.class, PolyglotJNIConfig.HostContext.class);
            objectWithInteropObjectMarshaller = jNIConfig.lookupMarshaller(Object.class, PolyglotJNIConfig.InteropObject.class);
            objectWithTruffleFileMarshaller = jNIConfig.lookupMarshaller(Object.class, PolyglotJNIConfig.TruffleFile.class);
            runtimeExceptionWithInteropObjectMarshaller = jNIConfig.lookupMarshaller(RuntimeException.class, PolyglotJNIConfig.InteropObject.class);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
            throwableWithInteropObjectMarshaller = jNIConfig.lookupMarshaller(Throwable.class, PolyglotJNIConfig.InteropObject.class);
        }
    }
}

