/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.client.gui.component.input;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.ARGB;
import net.minecraft.util.Util;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.client.gui.component.input.IInputListener;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integratedscripting.client.gui.component.input.TextFieldHelperExtended;

public class WidgetTextArea
extends EditBox
implements GuiEventListener {
    public static final int ROW_HEIGHT = 9;
    private final TextFieldHelperExtended textFieldHelper;
    private final Font font;
    private final boolean showLineNumbers;
    private int frameTick;
    private String value = "";
    private String selected = "";
    @Nullable
    private IInputListener listener;
    @Nullable
    private IInputListener listenerSelection;
    @Nullable
    private IInputListener listenerCursor;
    @Nullable
    private IMarkupProvider markupProvider;
    private DisplayCache emptyDisplayCache;
    @Nullable
    private DisplayCache displayCache = this.emptyDisplayCache = this.createEmptyDisplayCache();
    private long lastClickTime;
    private int lastIndex = -1;
    @Nullable
    private WidgetScrollBar scrollBar;
    private int firstRow;

    public WidgetTextArea(Font font, int x2, int y2, int width, int height, Component narrationMessage, boolean scrollBar, boolean showLineNumbers) {
        super(font, x2, y2, width, height, narrationMessage);
        this.font = font;
        this.showLineNumbers = showLineNumbers;
        this.textFieldHelper = new TextFieldHelperExtended(this::getValue, this::setValuePassive, this::getClipboard, this::setClipboard, s2 -> true, this::setSelected, this::onCursorPosChanged);
        if (scrollBar) {
            this.scrollBar = new WidgetScrollBar(x2 + width - 14, y2, height, (Component)Component.translatable((String)"gui.cyclopscore.scrollbar"), firstRow -> this.setFirstRow(firstRow, false), height / 9){

                public int getTotalRows() {
                    return WidgetTextArea.this.getDisplayCache().linesTotal;
                }

                public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                    if (this.needsScrollBars()) {
                        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
                    }
                }
            };
        }
    }

    private DisplayCache createEmptyDisplayCache() {
        Pos2i pos = this.convertLocalToScreen(new Pos2i(0, 0));
        return new DisplayCache("", pos, true, new int[]{0}, new LineInfo[]{new LineInfo(Collections.emptyList(), pos.x, pos.y, 0, false)}, new LineInfo[]{new LineInfo(Collections.emptyList(), pos.x, pos.y, 0, false)}, new Rect2i[0], 0, 0);
    }

    public void setFirstRow(int firstRow, boolean propagateToScrollbar) {
        this.firstRow = firstRow;
        if (this.scrollBar != null) {
            int linesTotal = this.getDisplayCache().linesTotal;
            if (this.firstRow > linesTotal - this.scrollBar.getVisibleRows()) {
                this.firstRow = linesTotal - this.scrollBar.getVisibleRows();
            }
            if (this.firstRow < 0) {
                this.firstRow = 0;
            }
            if (propagateToScrollbar) {
                this.scrollBar.setFirstRow(this.firstRow, false);
            }
        }
        this.clearDisplayCache();
    }

    public void setListener(@Nullable IInputListener listener) {
        this.listener = listener;
    }

    public void setListenerSelection(@Nullable IInputListener listenerSelection) {
        this.listenerSelection = listenerSelection;
    }

    public void setListenerCursor(@Nullable IInputListener listenerCursor) {
        this.listenerCursor = listenerCursor;
    }

    public void setMarkupProvider(@Nullable IMarkupProvider markupProvider) {
        this.markupProvider = markupProvider;
    }

    public void setValue(String value) {
        this.setValuePassive(value);
        this.textFieldHelper.setCursorToStart();
        this.textFieldHelper.setSelectionPos(this.textFieldHelper.getCursorPos());
        if (this.scrollBar != null) {
            this.scrollBar.scrollTo(0.0f);
        }
    }

    public void setValuePassive(String value) {
        this.firstRow = 0;
        this.value = value;
        this.clearDisplayCache();
        if (this.listener != null) {
            this.listener.onChanged();
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setSelected(String value) {
        this.selected = value;
        if (this.listenerSelection != null) {
            this.listenerSelection.onChanged();
        }
    }

    public String getSelected() {
        return this.selected;
    }

    public int getCursorPos() {
        return this.textFieldHelper.getCursorPos();
    }

    public void setCursorPos(int pos) {
        this.textFieldHelper.setCursorPos(pos, true);
    }

    private void onCursorPosChanged(int cursorPos) {
        if (this.listenerCursor != null) {
            this.listenerCursor.onChanged();
        }
    }

    public int getSelectionPos() {
        return this.textFieldHelper.getSelectionPos();
    }

    public void setSelectionPos(int pos) {
        this.textFieldHelper.setSelectionPos(pos);
    }

    public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)Component.translatable((String)"narration.edit_box", (Object[])new Object[]{this.getValue()}));
    }

    private void setClipboard(String value) {
        TextFieldHelper.setClipboardContents((Minecraft)Minecraft.getInstance(), (String)value);
    }

    private String getClipboard() {
        return TextFieldHelper.getClipboardContents((Minecraft)Minecraft.getInstance());
    }

    public void tick() {
        ++this.frameTick;
    }

    public boolean mouseClicked(MouseButtonEvent mouse, boolean isDoubleClick) {
        if (mouse.button() == 1 && mouse.x() >= (double)this.getX() && mouse.x() < (double)(this.getX() + this.width) && mouse.y() >= (double)this.getY() && mouse.y() < (double)(this.getY() + this.height)) {
            this.setFocused(true);
            this.textFieldHelper.selectAll();
            return true;
        }
        if (mouse.button() == 0 && mouse.x() >= (double)this.getX() && mouse.x() < (double)(this.getX() + this.width) && mouse.y() >= (double)this.getY() && mouse.y() < (double)(this.getY() + this.height)) {
            this.setFocused(true);
            long i2 = Util.getMillis();
            DisplayCache displayCache = this.getDisplayCache();
            int j2 = displayCache.getIndexAtPosition(this.font, this.convertScreenToLocal(new Pos2i((int)mouse.x(), (int)mouse.y())));
            if (j2 >= 0) {
                if (j2 == this.lastIndex && i2 - this.lastClickTime < 250L) {
                    if (!this.textFieldHelper.isSelecting()) {
                        this.selectWord(j2);
                    } else {
                        this.textFieldHelper.selectAll();
                    }
                } else {
                    this.textFieldHelper.setCursorPos(j2, Minecraft.getInstance().hasShiftDown());
                }
                this.clearDisplayCache();
            }
            this.lastIndex = j2;
            this.lastClickTime = i2;
            this.setFocused(true);
        } else {
            this.setFocused(false);
        }
        return this.isFocused();
    }

    private void selectWord(int p_98142_) {
        String value = this.getValue();
        this.textFieldHelper.setSelectionRange(StringSplitter.getWordPosition((String)value, (int)-1, (int)p_98142_, (boolean)false), StringSplitter.getWordPosition((String)value, (int)1, (int)p_98142_, (boolean)false));
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double mouseZ, double scroll) {
        return this.scrollBar != null && mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + this.width) && mouseY >= (double)this.getY() && mouseY < (double)(this.getY() + this.height) && this.scrollBar.mouseScrolled(mouseX, mouseY, mouseZ, scroll);
    }

    public boolean mouseDragged(MouseButtonEvent mouse, double offsetX, double offsetY) {
        if (this.scrollBar != null && mouse.x() >= (double)(this.getX() + this.width - 12) && mouse.x() < (double)(this.getX() + this.width) && mouse.y() >= (double)this.getY() && mouse.y() < (double)(this.getY() + this.height)) {
            return this.scrollBar.mouseDragged(mouse, offsetX, offsetY);
        }
        if (mouse.button() == 0 && mouse.x() >= (double)this.getX() && mouse.x() < (double)(this.getX() + this.width) && mouse.y() >= (double)this.getY() && mouse.y() < (double)(this.getY() + this.height)) {
            DisplayCache bookeditscreen$displaycache = this.getDisplayCache();
            int i2 = bookeditscreen$displaycache.getIndexAtPosition(this.font, this.convertScreenToLocal(new Pos2i((int)mouse.x(), (int)mouse.y())));
            this.textFieldHelper.setCursorPos(i2, true);
            this.clearDisplayCache();
            this.setFocused(true);
        }
        return true;
    }

    public boolean keyPressed(KeyEvent event) {
        boolean flag = this.textFieldKeyPressed(event);
        if (flag) {
            this.clearDisplayCache();
            this.setFocused(true);
            return true;
        }
        this.setFocused(false);
        return false;
    }

    public boolean charTyped(CharacterEvent event) {
        if (super.charTyped(event)) {
            this.setFocused(true);
            return true;
        }
        if (event.isAllowedChatCharacter()) {
            this.textFieldHelper.insertText(event.codepointAsString());
            this.clearDisplayCache();
            this.setFocused(true);
            return true;
        }
        this.setFocused(false);
        return false;
    }

    private boolean textFieldKeyPressed(KeyEvent event) {
        if (event.isSelectAll()) {
            this.textFieldHelper.selectAll();
            return true;
        }
        if (event.isCopy()) {
            this.textFieldHelper.copy();
            return true;
        }
        if (event.isPaste()) {
            this.textFieldHelper.paste();
            return true;
        }
        if (event.isCut()) {
            this.textFieldHelper.cut();
            return true;
        }
        TextFieldHelper.CursorStep cursorStep = event.hasControlDown() ? TextFieldHelper.CursorStep.WORD : TextFieldHelper.CursorStep.CHARACTER;
        switch (event.key()) {
            case 257: 
            case 335: {
                this.textFieldHelper.insertText("\n");
                return true;
            }
            case 259: {
                this.textFieldHelper.removeFromCursor(-1, cursorStep);
                return true;
            }
            case 261: {
                this.textFieldHelper.removeFromCursor(1, cursorStep);
                return true;
            }
            case 262: {
                this.textFieldHelper.moveBy(1, event.hasShiftDown(), cursorStep);
                return true;
            }
            case 263: {
                this.textFieldHelper.moveBy(-1, event.hasShiftDown(), cursorStep);
                return true;
            }
            case 264: {
                this.keyDown(event);
                return true;
            }
            case 265: {
                this.keyUp(event);
                return true;
            }
            case 266: {
                return true;
            }
            case 267: {
                return true;
            }
            case 268: {
                this.keyHome(event);
                return true;
            }
            case 269: {
                this.keyEnd(event);
                return true;
            }
        }
        return false;
    }

    private void keyUp(KeyEvent event) {
        this.changeLine(-1, event);
    }

    private void keyDown(KeyEvent event) {
        this.changeLine(1, event);
    }

    private void changeLine(int p_98098_, KeyEvent event) {
        int cursorPos = this.textFieldHelper.getCursorPos();
        DisplayCache displayCache = this.getDisplayCache();
        int j2 = displayCache.changeLine(cursorPos, p_98098_);
        this.textFieldHelper.setCursorPos(j2, event.hasShiftDown());
        if (this.scrollBar != null) {
            int cursorLine = WidgetTextArea.findLineFromPos(Arrays.stream(displayCache.lineStarts).toArray(), cursorPos);
            if (cursorLine < this.firstRow + 2) {
                this.setFirstRow(cursorLine - 2, true);
            } else if (cursorLine > this.firstRow + this.scrollBar.getVisibleRows() - 3) {
                this.setFirstRow(cursorLine - (this.scrollBar.getVisibleRows() - 3), true);
            }
        }
    }

    private void keyHome(KeyEvent event) {
        if (event.hasControlDown()) {
            this.textFieldHelper.setCursorToStart(event.hasShiftDown());
        } else {
            int i2 = this.textFieldHelper.getCursorPos();
            int j2 = this.getDisplayCache().findLineStart(i2);
            this.textFieldHelper.setCursorPos(j2, event.hasShiftDown());
        }
    }

    private void keyEnd(KeyEvent event) {
        if (event.hasControlDown()) {
            this.textFieldHelper.setCursorToEnd(event.hasShiftDown());
        } else {
            DisplayCache displayCache = this.getDisplayCache();
            int i2 = this.textFieldHelper.getCursorPos();
            int j2 = displayCache.findLineEnd(i2);
            this.textFieldHelper.setCursorPos(j2, event.hasShiftDown());
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        DisplayCache displayCache = this.getDisplayCache();
        List<LineInfo> lines = Arrays.asList(displayCache.lines);
        int offsetY = 0;
        int lastLineNumber = -1;
        for (LineInfo line : lines) {
            guiGraphics.drawString(this.font, line.asComponent, line.x, line.y - offsetY, ARGB.opaque((int)-16777216), false);
            if (this.showLineNumbers && lastLineNumber != line.lineNumber) {
                IModHelpers.get().getRenderHelpers().drawScaledString(guiGraphics, this.font, String.valueOf(line.lineNumber), this.getX(), line.y - offsetY + 2, 0.5f, line.hasCursor ? 0 : IModHelpers.get().getBaseHelpers().RGBAToInt(120, 120, 120, 255), false, Font.DisplayMode.NORMAL);
            }
            lastLineNumber = line.lineNumber;
        }
        this.renderHighlight(guiGraphics, displayCache.selection);
        if (displayCache.cursor != null) {
            this.renderCursor(guiGraphics, displayCache.cursor, displayCache.cursorAtEnd);
        }
        if (this.scrollBar != null) {
            this.scrollBar.render(guiGraphics, this.getX(), this.getY(), partialTicks);
        }
    }

    private void renderCursor(GuiGraphics guiGraphics, Pos2i pos, boolean cursorAtEnd) {
        if (this.isFocused() && this.frameTick / 6 % 2 == 0) {
            pos = this.convertLocalToScreen(pos);
            if (!cursorAtEnd) {
                guiGraphics.fill(pos.x, pos.y - 1, pos.x + 1, pos.y + 9, -16777216);
            } else {
                guiGraphics.drawString(this.font, "_", pos.x, pos.y, ARGB.opaque((int)0));
            }
        }
    }

    private void renderHighlight(GuiGraphics guiGraphics, Rect2i[] highlightAreas) {
        for (Rect2i rect2i : highlightAreas) {
            int i2 = rect2i.getX();
            int j2 = rect2i.getY();
            int k2 = i2 + rect2i.getWidth();
            int l2 = j2 + rect2i.getHeight();
            guiGraphics.fill(RenderPipelines.GUI_TEXT_HIGHLIGHT, i2, j2, k2, l2, -16776961);
        }
    }

    private int getLinesXOffset() {
        return this.showLineNumbers ? 14 : 0;
    }

    private Pos2i convertScreenToLocal(Pos2i posScreen) {
        return new Pos2i(posScreen.x - this.getX() - this.getLinesXOffset(), posScreen.y - this.getY());
    }

    private Pos2i convertLocalToScreen(Pos2i posLocal) {
        return new Pos2i(this.getX() + posLocal.x + this.getLinesXOffset(), this.getY() + posLocal.y);
    }

    private DisplayCache getDisplayCache() {
        if (this.displayCache == null) {
            this.displayCache = this.rebuildDisplayCache();
        }
        return this.displayCache;
    }

    private void clearDisplayCache() {
        this.displayCache = null;
    }

    private DisplayCache rebuildDisplayCache() {
        Pos2i cursor;
        boolean flag;
        String s2 = this.getValue();
        if (s2.isEmpty()) {
            return this.emptyDisplayCache;
        }
        int cursorPos = this.textFieldHelper.getCursorPos();
        int selectionPos = this.textFieldHelper.getSelectionPos();
        IntArrayList linePositionsOld = new IntArrayList();
        ArrayList linesAll = Lists.newArrayList();
        MutableInt mutableint = new MutableInt();
        MutableBoolean mutableboolean = new MutableBoolean();
        StringSplitter stringsplitter = this.font.getSplitter();
        MutableInt lineNumber = new MutableInt();
        stringsplitter.splitLines(s2, this.getWidth() - this.getLinesXOffset(), Style.EMPTY, true, (arg_0, arg_1, arg_2) -> this.lambda$rebuildDisplayCache$2(mutableint, s2, mutableboolean, (IntList)linePositionsOld, linesAll, lineNumber, cursorPos, arg_0, arg_1, arg_2));
        int linesTotal = linesAll.size();
        List lines = linesAll;
        IntArrayList lineStarts = linePositionsOld;
        if (this.scrollBar != null) {
            lines = lines.subList(this.firstRow, Math.min(this.firstRow + this.scrollBar.getVisibleRows(), lines.size()));
        }
        int[] lineStartsArr = lineStarts.toIntArray();
        boolean bl = flag = cursorPos == s2.length();
        if (flag && mutableboolean.isTrue()) {
            cursor = new Pos2i(0, lines.size() * 9);
        } else {
            int cursorLine = WidgetTextArea.findLineFromPos(lineStartsArr, cursorPos);
            int cursorX = this.font.width(s2.substring(lineStartsArr[cursorLine], cursorPos));
            cursor = new Pos2i(cursorX, (cursorLine - this.firstRow) * 9);
        }
        if (cursor.y < 0 || cursor.y > this.getHeight()) {
            cursor = null;
        }
        ArrayList selection = Lists.newArrayList();
        if (cursorPos != selectionPos) {
            int lineEnd;
            int l2 = Math.min(cursorPos, selectionPos);
            int i1 = Math.max(cursorPos, selectionPos);
            int lineStart = WidgetTextArea.findLineFromPos(lineStartsArr, l2);
            if (lineStart == (lineEnd = WidgetTextArea.findLineFromPos(lineStartsArr, i1))) {
                int l1 = lineStart * 9;
                int i2 = lineStartsArr[lineStart];
                selection.add(this.createPartialLineSelection(s2, stringsplitter, l2, i1, l1, i2));
            } else {
                int i3 = lineStart + 1 > lineStartsArr.length ? s2.length() : lineStartsArr[lineStart + 1];
                selection.add(this.createPartialLineSelection(s2, stringsplitter, l2, i3, lineStart * 9, lineStartsArr[lineStart]));
                for (int j3 = lineStart + 1; j3 < lineEnd; ++j3) {
                    int j2 = j3 * 9;
                    String s1 = s2.substring(lineStartsArr[j3], lineStartsArr[j3 + 1]);
                    int k2 = (int)stringsplitter.stringWidth(s1);
                    selection.add(this.createSelection(new Pos2i(0, j2), new Pos2i(k2, j2 + 9)));
                }
                selection.add(this.createPartialLineSelection(s2, stringsplitter, lineStartsArr[lineEnd], i1, lineEnd * 9, lineStartsArr[lineEnd]));
            }
        }
        ArrayList selectionNew = Lists.newArrayList();
        for (Rect2i rect2i : selection) {
            Rect2i rect2iNew = new Rect2i(rect2i.getX(), rect2i.getY() - this.firstRow * 9, rect2i.getWidth(), rect2i.getHeight());
            if (rect2iNew.getY() - this.getY() < 0 || rect2iNew.getY() - this.getY() >= this.getHeight()) continue;
            selectionNew.add(rect2iNew);
        }
        return new DisplayCache(s2, cursor, flag, lineStartsArr, lines.toArray(new LineInfo[0]), linesAll.toArray(new LineInfo[0]), selectionNew.toArray(new Rect2i[0]), linesTotal, this.firstRow);
    }

    private List<Pair<Style, String>> markupLine(Style style, String line) {
        if (this.markupProvider != null) {
            return this.markupProvider.markupLine(style, line);
        }
        return Stream.of(Pair.of((Object)style, (Object)line)).collect(Collectors.toList());
    }

    static int findLineFromPos(int[] p_98150_, int p_98151_) {
        int i2 = Arrays.binarySearch(p_98150_, p_98151_);
        return i2 < 0 ? -(i2 + 2) : i2;
    }

    private Rect2i createPartialLineSelection(String p_98120_, StringSplitter p_98121_, int p_98122_, int p_98123_, int p_98124_, int p_98125_) {
        String s2 = p_98120_.substring(p_98125_, p_98122_);
        String s1 = p_98120_.substring(p_98125_, p_98123_);
        Pos2i bookeditscreen$pos2i = new Pos2i((int)p_98121_.stringWidth(s2), p_98124_);
        Pos2i bookeditscreen$pos2i1 = new Pos2i((int)p_98121_.stringWidth(s1), p_98124_ + 9);
        return this.createSelection(bookeditscreen$pos2i, bookeditscreen$pos2i1);
    }

    private Rect2i createSelection(Pos2i p_98117_, Pos2i p_98118_) {
        Pos2i bookeditscreen$pos2i = this.convertLocalToScreen(p_98117_);
        Pos2i bookeditscreen$pos2i1 = this.convertLocalToScreen(p_98118_);
        int i2 = Math.min(bookeditscreen$pos2i.x, bookeditscreen$pos2i1.x);
        int j2 = Math.max(bookeditscreen$pos2i.x, bookeditscreen$pos2i1.x);
        int k2 = Math.min(bookeditscreen$pos2i.y, bookeditscreen$pos2i1.y);
        int l2 = Math.max(bookeditscreen$pos2i.y, bookeditscreen$pos2i1.y);
        return new Rect2i(i2, k2, j2 - i2, l2 - k2);
    }

    private /* synthetic */ void lambda$rebuildDisplayCache$2(MutableInt mutableint, String s2, MutableBoolean mutableboolean, IntList linePositionsOld, List linesAll, MutableInt lineNumber, int cursorPos, Style style, int startPos, int endPos) {
        int k3 = mutableint.getAndIncrement();
        String stringPart = s2.substring(startPos, endPos);
        boolean hasNewLine = stringPart.endsWith("\n");
        mutableboolean.setValue(hasNewLine);
        String s3 = StringUtils.stripEnd((String)stringPart, (String)" \n");
        int l3 = (k3 - this.firstRow) * 9;
        Pos2i bookeditscreen$pos2i1 = this.convertLocalToScreen(new Pos2i(0, l3));
        linePositionsOld.add(startPos);
        linesAll.add(new LineInfo(this.markupLine(style, s3), bookeditscreen$pos2i1.x, bookeditscreen$pos2i1.y, lineNumber.getValue(), cursorPos >= startPos && cursorPos < (hasNewLine ? endPos : s2.indexOf("\n", endPos))));
        if (hasNewLine) {
            lineNumber.increment();
        }
    }

    static class DisplayCache {
        private final String fullText;
        @Nullable
        final Pos2i cursor;
        final boolean cursorAtEnd;
        private final int[] lineStarts;
        final LineInfo[] lines;
        final LineInfo[] linesAll;
        final Rect2i[] selection;
        final int linesTotal;
        final int firstRow;

        public DisplayCache(String p_98201_, Pos2i cursor, boolean p_98203_, int[] p_98204_, LineInfo[] lines, LineInfo[] linesAll, Rect2i[] selection, int linesTotal, int firstRow) {
            this.fullText = p_98201_;
            this.cursor = cursor;
            this.cursorAtEnd = p_98203_;
            this.lineStarts = p_98204_;
            this.lines = lines;
            this.linesAll = linesAll;
            this.selection = selection;
            this.linesTotal = linesTotal;
            this.firstRow = firstRow;
        }

        public int getIndexAtPosition(Font p_98214_, Pos2i p_98215_) {
            int i2 = p_98215_.y / 9 + this.firstRow;
            if (i2 < 0) {
                return 0;
            }
            if (i2 >= this.linesAll.length) {
                return this.fullText.length();
            }
            LineInfo bookeditscreen$lineinfo = this.linesAll[i2];
            return this.lineStarts[i2] + p_98214_.getSplitter().plainIndexAtWidth(bookeditscreen$lineinfo.contents, p_98215_.x, Style.EMPTY);
        }

        public int changeLine(int p_98211_, int p_98212_) {
            int k2;
            int i2 = WidgetTextArea.findLineFromPos(this.lineStarts, p_98211_);
            int j2 = i2 + p_98212_;
            if (0 <= j2 && j2 < this.lineStarts.length) {
                int l2 = p_98211_ - this.lineStarts[i2];
                int i1 = this.linesAll[j2].contents.length();
                k2 = this.lineStarts[j2] + Math.min(l2, i1);
            } else {
                k2 = p_98211_;
            }
            return k2;
        }

        public int findLineStart(int p_98209_) {
            int i2 = WidgetTextArea.findLineFromPos(this.lineStarts, p_98209_);
            return this.lineStarts[i2];
        }

        public int findLineEnd(int p_98219_) {
            int i2 = WidgetTextArea.findLineFromPos(this.lineStarts, p_98219_);
            return this.lineStarts[i2] + this.linesAll[i2].contents.length();
        }
    }

    static class Pos2i {
        public final int x;
        public final int y;

        Pos2i(int p_98249_, int p_98250_) {
            this.x = p_98249_;
            this.y = p_98250_;
        }
    }

    static class LineInfo {
        final List<Pair<Style, String>> contentsStyled;
        final String contents;
        final Component asComponent;
        final int x;
        final int y;
        final int lineNumber;
        final boolean hasCursor;

        public LineInfo(List<Pair<Style, String>> contentsStyled, int x2, int y2, int lineNumber, boolean hasCursor) {
            this.contentsStyled = contentsStyled;
            this.contents = contentsStyled.stream().map(Pair::getRight).collect(Collectors.joining());
            this.x = x2;
            this.y = y2;
            this.lineNumber = lineNumber;
            this.hasCursor = hasCursor;
            MutableComponent component = Component.literal((String)"");
            for (Pair<Style, String> value : contentsStyled) {
                component = component.append((Component)Component.literal((String)((String)value.getRight())).setStyle((Style)value.getLeft()));
            }
            this.asComponent = component;
        }
    }

    public static interface IMarkupProvider {
        public List<Pair<Style, String>> markupLine(Style var1, String var2);
    }
}

