/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.core.network;

import java.util.function.Supplier;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.api.network.IIdentifiableNetworkElement;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.core.network.TileNetworkElement;
import org.cyclops.integratedscripting.GeneralConfig;
import org.cyclops.integratedscripting.blockentity.BlockEntityScriptingDrive;
import org.cyclops.integratedscripting.core.network.ScriptingNetworkHelpers;

public class ScriptingDriveNetworkElement
extends TileNetworkElement<BlockEntityScriptingDrive>
implements IIdentifiableNetworkElement {
    public static final Identifier GROUP = Identifier.fromNamespaceAndPath((String)"integratedscripting", (String)"scripting_drive");
    private final Supplier<Integer> idGetter;

    public ScriptingDriveNetworkElement(DimPos pos, Supplier<Integer> idGetter) {
        super(pos);
        this.idGetter = idGetter;
    }

    public int getId() {
        return this.idGetter.get();
    }

    public Identifier getGroup() {
        return GROUP;
    }

    public boolean onNetworkAddition(INetwork network) {
        if (super.onNetworkAddition(network)) {
            return ScriptingNetworkHelpers.getScriptingNetwork(network).map(scriptingNetwork -> {
                scriptingNetwork.addDisk(this.getId());
                return true;
            }).orElse(false);
        }
        return false;
    }

    public void onNetworkRemoval(INetwork network, BlockState blockState, BlockEntity blockEntity) {
        super.onNetworkRemoval(network, blockState, blockEntity);
        ScriptingNetworkHelpers.getScriptingNetwork(network).ifPresent(scriptingNetwork -> scriptingNetwork.removeDisk(this.getId()));
    }

    public void setPriorityAndChannel(INetwork network, int priority, int channel) {
    }

    public int getPriority() {
        return 0;
    }

    public int getChannel() {
        return 0;
    }

    public int getConsumptionRate() {
        return GeneralConfig.scriptingDriveBaseConsumption;
    }

    protected Class<BlockEntityScriptingDrive> getTileClass() {
        return BlockEntityScriptingDrive.class;
    }
}

