/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api;

import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.LanguageAccessor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.RootCallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.Frame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;

public final class TruffleStackTraceElement {
    private final Node location;
    private final RootCallTarget target;
    private final Frame frame;
    private final int bytecodeIndex;

    TruffleStackTraceElement(Node location, RootCallTarget target, Frame frame, int bytecodeIndex) {
        this.location = location;
        this.target = target;
        this.frame = frame;
        this.bytecodeIndex = bytecodeIndex;
    }

    public static TruffleStackTraceElement create(Node location, RootCallTarget target, Frame frame) {
        Objects.requireNonNull(target, "RootCallTarget must not be null");
        return new TruffleStackTraceElement(location, target, frame, -1);
    }

    public static TruffleStackTraceElement create(Node location, RootCallTarget target, Frame frame, int bytecodeIndex) {
        Objects.requireNonNull(target, "RootCallTarget must not be null");
        return new TruffleStackTraceElement(location, target, frame, bytecodeIndex);
    }

    public Node getLocation() {
        return this.location;
    }

    public RootCallTarget getTarget() {
        return this.target;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public boolean hasBytecodeIndex() {
        return this.getBytecodeIndex() >= 0;
    }

    public int getBytecodeIndex() {
        return this.bytecodeIndex;
    }

    public Object getGuestObject() {
        assert (LanguageAccessor.engineAccess().getCurrentCreatorTruffleContext() != null) : "The TruffleContext must be entered.";
        Object guestObject = LanguageAccessor.nodesAccess().translateStackTraceElement(this);
        assert (LanguageAccessor.EXCEPTIONS.assertGuestObject(guestObject));
        return guestObject;
    }

    public String toString() {
        return "TruffleStackTraceElement[rootNode=" + String.valueOf(this.target.getRootNode()) + ", callNode=" + String.valueOf(this.location) + ", bytecodeIndex=" + this.bytecodeIndex + ", frame=" + String.valueOf(this.frame) + "]";
    }
}

