/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.exception;

import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.TruffleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportMessage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.SourceSection;

@ExportLibrary(value=InteropLibrary.class)
final class HostStackTraceElementObject
implements TruffleObject {
    private final StackTraceElement stackTraceElement;

    HostStackTraceElementObject(StackTraceElement stackTraceElement) {
        this.stackTraceElement = Objects.requireNonNull(stackTraceElement);
    }

    @ExportMessage
    boolean hasExecutableName() {
        return true;
    }

    @ExportMessage
    Object getExecutableName() {
        return this.stackTraceElement.getMethodName();
    }

    @ExportMessage
    boolean hasSourceLocation() {
        return this.stackTraceElement.getLineNumber() >= 0;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    SourceSection getSourceLocation() throws UnsupportedMessageException {
        int lineNumber = this.stackTraceElement.getLineNumber();
        if (lineNumber >= 0) {
            Source dummySource = Source.newBuilder("host", "", this.stackTraceElement.getFileName()).content(Source.CONTENT_NONE).cached(false).build();
            return dummySource.createSection(lineNumber);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean hasDeclaringMetaObject() {
        return true;
    }

    @ExportMessage
    Object getDeclaringMetaObject() {
        return new DeclaringMetaObject();
    }

    @ExportLibrary(value=InteropLibrary.class)
    final class DeclaringMetaObject
    implements TruffleObject {
        DeclaringMetaObject() {
        }

        @ExportMessage
        boolean isMetaObject() {
            return true;
        }

        @ExportMessage
        Object getMetaQualifiedName() {
            return HostStackTraceElementObject.this.stackTraceElement.getClassName();
        }

        @CompilerDirectives.TruffleBoundary
        @ExportMessage
        Object getMetaSimpleName() {
            String qualifiedName = HostStackTraceElementObject.this.stackTraceElement.getClassName();
            return qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1);
        }

        @ExportMessage
        boolean isMetaInstance(Object instance) {
            return instance == HostStackTraceElementObject.this;
        }
    }
}

