/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.impl;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleLogger;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleSafepoint;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.impl.DefaultRuntimeAccessor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;

public abstract class ThreadLocalHandshake {
    private static final Map<Thread, TruffleSafepointImpl> SAFEPOINTS = Collections.synchronizedMap(new WeakHashMap());

    static void resetNativeImageState() {
        for (TruffleSafepointImpl impl : SAFEPOINTS.values()) {
            impl.verifyUnused();
        }
        SAFEPOINTS.clear();
    }

    protected ThreadLocalHandshake() {
    }

    public abstract void poll(Node var1);

    public abstract TruffleSafepointImpl getCurrent();

    protected boolean isSupported() {
        return true;
    }

    public void testSupport() {
        if (!this.isSupported()) {
            throw new UnsupportedOperationException("Thread local handshakes are not supported on this platform. A possible reason may be that the underlying JVMCI version is too old.");
        }
    }

    public boolean setChangeAllowActions(TruffleSafepoint safepoint, boolean enabled) {
        return ((TruffleSafepointImpl)safepoint).setChangeAllowActions(enabled);
    }

    public boolean isAllowActions(TruffleSafepoint safepoint) {
        return ((TruffleSafepointImpl)safepoint).isAllowActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public final <T extends Consumer<Node>> Future<Void> runThreadLocal(Thread[] threads, T onThread, Consumer<T> onDone, boolean sideEffecting, boolean syncStartOfEvent, boolean syncEndOfEvent, int syncActionMaxWait, boolean syncActionPrintStackTraces, TruffleLogger engineLogger) {
        this.testSupport();
        assert (threads.length > 0);
        Handshake<T> handshake = new Handshake<T>(threads, onThread, onDone, sideEffecting, threads.length, syncStartOfEvent, syncEndOfEvent, syncActionMaxWait, syncActionPrintStackTraces, engineLogger);
        if (syncStartOfEvent || syncEndOfEvent) {
            Class<ThreadLocalHandshake> clazz = ThreadLocalHandshake.class;
            synchronized (ThreadLocalHandshake.class) {
                this.addHandshakes(threads, handshake);
                // ** MonitorExit[var11_11] (shouldn't be in output)
            }
        } else {
            this.addHandshakes(threads, handshake);
        }
        return handshake;
    }

    private <T extends Consumer<Node>> void addHandshakes(Thread[] threads, Handshake<T> handshake) {
        for (int i2 = 0; i2 < threads.length; ++i2) {
            Thread t2 = threads[i2];
            if (!t2.isAlive()) {
                throw new IllegalStateException("Thread no longer alive with pending handshake.");
            }
            this.getThreadState(t2).addHandshake(t2, handshake);
        }
    }

    public final boolean activateThread(TruffleSafepoint s2, Future<?> f2) {
        return ((TruffleSafepointImpl)s2).activateThread((Handshake)f2);
    }

    public final boolean deactivateThread(TruffleSafepoint s2, Future<?> f2) {
        return ((TruffleSafepointImpl)s2).deactivateThread((Handshake)f2);
    }

    public void ensureThreadInitialized() {
    }

    protected abstract void setFastPending(Thread var1);

    @CompilerDirectives.TruffleBoundary
    protected final void processHandshake(Node location) {
        TruffleSafepointImpl s2 = this.getCurrent();
        if (s2.fastPendingSet) {
            s2.processHandshakes(location, s2.takeHandshakes());
        }
    }

    protected abstract void clearFastPending();

    private static Throwable combineThrowable(Throwable current, Throwable t2) {
        if (current == null) {
            return t2;
        }
        if (t2 instanceof ThreadDeath) {
            t2.addSuppressed(current);
            return t2;
        }
        current.addSuppressed(t2);
        return current;
    }

    private static <T extends Throwable> RuntimeException sneakyThrow(Throwable ex) throws T {
        throw ex;
    }

    protected final TruffleSafepointImpl getThreadState(Thread thread) {
        return SAFEPOINTS.computeIfAbsent(thread, t2 -> new TruffleSafepointImpl(this));
    }

    protected static final class TruffleSafepointImpl
    extends TruffleSafepoint {
        private final ReentrantLock lock = new ReentrantLock();
        private final ThreadLocalHandshake impl;
        private volatile boolean fastPendingSet;
        private boolean sideEffectsEnabled = true;
        private boolean enabled = true;
        private volatile boolean changeAllowActionsAllowed;
        private TruffleSafepoint.Interrupter blockedAction;
        private boolean interrupted;
        private final LinkedList<HandshakeEntry> handshakes = new LinkedList();

        TruffleSafepointImpl(ThreadLocalHandshake handshake) {
            super(DefaultRuntimeAccessor.ENGINE);
            this.impl = handshake;
        }

        void verifyUnused() throws AssertionError {
            if (this.lock.isHeldByCurrentThread() || this.lock.isLocked()) {
                throw new AssertionError((Object)"Invalid locked state for safepoint.");
            }
            this.lock.lock();
            try {
                if (this.blockedAction != null) {
                    throw new AssertionError((Object)"Invalid pending blocked action.");
                }
                if (this.interrupted) {
                    throw new AssertionError((Object)"Invalid pending interrupted state.");
                }
                if (this.isPending()) {
                    throw new AssertionError((Object)"Invalid pending handshakes.");
                }
                if (!this.sideEffectsEnabled) {
                    throw new AssertionError((Object)"Invalid side-effects disabled state");
                }
                if (!this.enabled) {
                    throw new AssertionError((Object)"Invalid allow actions disabled state");
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        void processHandshakes(Node location, List<HandshakeEntry> toProcess) {
            if (toProcess == null) {
                return;
            }
            Throwable ex = null;
            for (HandshakeEntry current : toProcess) {
                if (!this.claimEntry(current)) continue;
                try {
                    current.handshake.perform(location);
                }
                catch (Throwable e2) {
                    ex = ThreadLocalHandshake.combineThrowable(ex, e2);
                }
            }
            if (this.fastPendingSet) {
                this.resetPending();
            }
            if (ex != null) {
                throw ThreadLocalHandshake.sneakyThrow(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean deactivateThread(Handshake<?> handshake) {
            this.lock.lock();
            try {
                HandshakeEntry current = this.lookupEntry(handshake);
                if (current != null) {
                    assert (!current.reactivated || current.handshake.sideEffecting) : "Reactivated handshake was not processed!";
                    handshake.deactivateThread();
                    this.claimEntry(current);
                    handshake.threads.put(Thread.currentThread(), Boolean.TRUE);
                    this.resetPending();
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.lock.unlock();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean activateThread(Handshake<?> handshake) {
            if (handshake.isDone()) {
                return false;
            }
            this.lock.lock();
            try {
                HandshakeEntry current = this.lookupEntry(handshake);
                if (current != null) {
                    boolean bl = false;
                    return bl;
                }
                boolean reactivated = false;
                if (handshake.threads.containsKey(Thread.currentThread())) {
                    if (!handshake.threads.get(Thread.currentThread()).booleanValue()) {
                        boolean bl = false;
                        return bl;
                    }
                    reactivated = true;
                }
                handshake.threads.put(Thread.currentThread(), Boolean.FALSE);
                if (handshake.activateThread()) {
                    this.addHandshakeImpl(Thread.currentThread(), handshake, reactivated);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.lock.unlock();
            }
            return false;
        }

        private HandshakeEntry lookupEntry(Handshake<?> handshake) {
            assert (this.lock.isHeldByCurrentThread());
            for (HandshakeEntry entry : this.handshakes) {
                if (entry.handshake != handshake) continue;
                return entry;
            }
            return null;
        }

        void addHandshake(Thread t2, Handshake<?> handshake) {
            this.lock.lock();
            try {
                this.addHandshakeImpl(t2, handshake, false);
            }
            finally {
                this.lock.unlock();
            }
        }

        private void addHandshakeImpl(Thread t2, Handshake<?> handshake, boolean reactivated) {
            this.handshakes.add(new HandshakeEntry(handshake, reactivated));
            if (this.isPending()) {
                this.setFastPendingAndInterrupt(t2);
            }
        }

        private void setFastPendingAndInterrupt(Thread t2) {
            TruffleSafepoint.Interrupter action;
            assert (this.lock.isHeldByCurrentThread());
            if (!this.fastPendingSet) {
                this.fastPendingSet = true;
                this.impl.setFastPending(t2);
            }
            if ((action = this.blockedAction) != null) {
                this.interrupted = true;
                action.interrupt(t2);
            }
        }

        List<HandshakeEntry> takeHandshakes() {
            this.lock.lock();
            try {
                if (this.interrupted) {
                    this.blockedAction.resetInterrupted();
                    this.interrupted = false;
                }
                if (this.isPending()) {
                    List<HandshakeEntry> taken = this.takeHandshakeImpl();
                    assert (!taken.isEmpty());
                    List<HandshakeEntry> list = taken;
                    return list;
                }
                List<HandshakeEntry> list = null;
                return list;
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean isFastPendingSet() {
            return this.fastPendingSet;
        }

        private void resetPending() {
            this.lock.lock();
            try {
                if (this.fastPendingSet && !this.isPending()) {
                    this.fastPendingSet = false;
                    this.impl.clearFastPending();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private boolean claimEntry(HandshakeEntry entry) {
            this.lock.lock();
            try {
                boolean bl = this.handshakes.removeFirstOccurrence(entry);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        private List<HandshakeEntry> takeHandshakeImpl() {
            if (!this.enabled) {
                return Collections.emptyList();
            }
            ArrayList<HandshakeEntry> toProcess = new ArrayList<HandshakeEntry>(this.handshakes.size());
            for (HandshakeEntry entry : this.handshakes) {
                if (!this.isPending(entry)) continue;
                toProcess.add(entry);
            }
            return toProcess;
        }

        private boolean isPending(HandshakeEntry entry) {
            return this.sideEffectsEnabled || !entry.handshake.sideEffecting;
        }

        @Override
        public <T> void setBlocked(Node location, TruffleSafepoint.Interrupter interrupter, TruffleSafepoint.Interruptible<T> interruptible, T object, Runnable beforeInterrupt, Consumer<Throwable> afterInterrupt) {
            assert (this.impl.getCurrent() == this) : "Cannot be used from a different thread.";
            if (CompilerDirectives.inCompiledCode() && CompilerDirectives.isPartialEvaluationConstant(interruptible) && interruptible instanceof TruffleSafepoint.CompiledInterruptible) {
                this.setBlockedCompiled(location, interrupter, (TruffleSafepoint.CompiledInterruptible)interruptible, object, beforeInterrupt, afterInterrupt);
            } else {
                this.setBlockedBoundary(location, interrupter, interruptible, object, beforeInterrupt, afterInterrupt);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> void setBlockedCompiled(Node location, TruffleSafepoint.Interrupter interrupter, TruffleSafepoint.CompiledInterruptible<T> interruptible, T object, Runnable beforeInterrupt, Consumer<Throwable> afterInterrupt) {
            TruffleSafepoint.Interrupter prev = this.blockedAction;
            try {
                while (true) {
                    try {
                        this.setBlockedImpl(location, interrupter, false);
                        interruptible.apply(object);
                    }
                    catch (InterruptedException e2) {
                        this.setBlockedAfterInterrupt(location, prev, beforeInterrupt, afterInterrupt);
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.setBlockedImpl(location, prev, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private <T> void setBlockedBoundary(Node location, TruffleSafepoint.Interrupter interrupter, TruffleSafepoint.Interruptible<T> interruptible, T object, Runnable beforeInterrupt, Consumer<Throwable> afterInterrupt) {
            TruffleSafepoint.Interrupter prev = this.blockedAction;
            try {
                while (true) {
                    try {
                        this.setBlockedImpl(location, interrupter, false);
                        interruptible.apply(object);
                    }
                    catch (InterruptedException e2) {
                        this.setBlockedAfterInterrupt(location, prev, beforeInterrupt, afterInterrupt);
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.setBlockedImpl(location, prev, false);
            }
        }

        @Override
        public <T, R> R setBlockedFunction(Node location, TruffleSafepoint.Interrupter interrupter, TruffleSafepoint.InterruptibleFunction<T, R> interruptible, T object, Runnable beforeInterrupt, Consumer<Throwable> afterInterrupt) {
            assert (this.impl.getCurrent() == this) : "Cannot be used from a different thread.";
            if (CompilerDirectives.inCompiledCode() && CompilerDirectives.isPartialEvaluationConstant(interruptible) && interruptible instanceof TruffleSafepoint.CompiledInterruptibleFunction) {
                return this.setBlockedFunctionCompiled(location, interrupter, (TruffleSafepoint.CompiledInterruptibleFunction)interruptible, object, beforeInterrupt, afterInterrupt);
            }
            return this.setBlockedFunctionBoundary(location, interrupter, interruptible, object, beforeInterrupt, afterInterrupt);
        }

        private <T, R> R setBlockedFunctionCompiled(Node location, TruffleSafepoint.Interrupter interrupter, TruffleSafepoint.CompiledInterruptibleFunction<T, R> interruptible, T object, Runnable beforeInterrupt, Consumer<Throwable> afterInterrupt) {
            TruffleSafepoint.Interrupter prev = this.blockedAction;
            while (true) {
                try {
                    this.setBlockedImpl(location, interrupter, false);
                    R r2 = interruptible.apply(object);
                    return r2;
                }
                catch (InterruptedException e2) {
                    this.setBlockedAfterInterrupt(location, prev, beforeInterrupt, afterInterrupt);
                    continue;
                }
                break;
            }
            finally {
                this.setBlockedImpl(location, prev, false);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private <T, R> R setBlockedFunctionBoundary(Node location, TruffleSafepoint.Interrupter interrupter, TruffleSafepoint.InterruptibleFunction<T, R> interruptible, T object, Runnable beforeInterrupt, Consumer<Throwable> afterInterrupt) {
            TruffleSafepoint.Interrupter prev = this.blockedAction;
            while (true) {
                try {
                    this.setBlockedImpl(location, interrupter, false);
                    R r2 = interruptible.apply(object);
                    return r2;
                }
                catch (InterruptedException e2) {
                    this.setBlockedAfterInterrupt(location, prev, beforeInterrupt, afterInterrupt);
                    continue;
                }
                break;
            }
            finally {
                this.setBlockedImpl(location, prev, false);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private void setBlockedAfterInterrupt(Node location, TruffleSafepoint.Interrupter interrupter, Runnable beforeInterrupt, Consumer<Throwable> afterInterrupt) {
            if (beforeInterrupt != null) {
                beforeInterrupt.run();
            }
            Throwable t2 = null;
            try {
                this.setBlockedImpl(location, interrupter, true);
            }
            catch (Throwable e2) {
                t2 = e2;
                throw e2;
            }
            finally {
                if (afterInterrupt != null) {
                    afterInterrupt.accept(t2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private void setBlockedImpl(Node location, TruffleSafepoint.Interrupter interrupter, boolean processSafepoints) {
            List<HandshakeEntry> toProcess = null;
            this.lock.lock();
            try {
                if (processSafepoints && this.isPending()) {
                    toProcess = this.takeHandshakeImpl();
                }
                if (this.interrupted) {
                    assert (this.blockedAction != null);
                    this.blockedAction.resetInterrupted();
                    this.interrupted = false;
                }
                this.blockedAction = interrupter;
            }
            finally {
                this.lock.unlock();
            }
            this.processHandshakes(location, toProcess);
            if (interrupter != null) {
                this.interruptIfPending(interrupter);
            }
        }

        private void interruptIfPending(TruffleSafepoint.Interrupter interrupter) {
            this.lock.lock();
            try {
                if (interrupter != null && this.isPending()) {
                    this.interrupted = true;
                    interrupter.interrupt(Thread.currentThread());
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private boolean isPending() {
            assert (this.lock.isHeldByCurrentThread());
            if (!this.enabled) {
                return false;
            }
            for (HandshakeEntry entry : this.handshakes) {
                if (!this.isPending(entry)) continue;
                return true;
            }
            return false;
        }

        boolean setChangeAllowActions(boolean changeAllowActionsAllowed) {
            boolean prevChangeAllowActionsAllowed = this.changeAllowActionsAllowed;
            this.changeAllowActionsAllowed = changeAllowActionsAllowed;
            return prevChangeAllowActionsAllowed;
        }

        boolean isAllowActions() {
            return this.enabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean setAllowActions(boolean enabled) {
            assert (this.impl.getCurrent() == this) : "Cannot be used from a different thread.";
            this.lock.lock();
            try {
                if (!this.changeAllowActionsAllowed) {
                    throw new IllegalStateException("Using setAllowActions is only permitted during finalization of a language. See TruffleLanguage.finalizeContext(Object) for further details.");
                }
                boolean prev = this.enabled;
                this.enabled = enabled;
                this.updateFastPending();
                boolean bl = prev;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean setAllowSideEffects(boolean enabled) {
            assert (this.impl.getCurrent() == this) : "Cannot be used from a different thread.";
            this.lock.lock();
            try {
                boolean prev = this.sideEffectsEnabled;
                this.sideEffectsEnabled = enabled;
                this.updateFastPending();
                boolean bl = prev;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean hasPendingSideEffectingActions() {
            assert (this.impl.getCurrent() == this) : "Cannot be used from a different thread.";
            this.lock.lock();
            try {
                boolean bl = !this.sideEffectsEnabled && this.hasSideEffecting();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        private boolean hasSideEffecting() {
            assert (this.lock.isHeldByCurrentThread());
            for (HandshakeEntry entry : this.handshakes) {
                if (!entry.handshake.sideEffecting) continue;
                return true;
            }
            return false;
        }

        private void updateFastPending() {
            if (this.isPending()) {
                this.setFastPendingAndInterrupt(Thread.currentThread());
            } else if (this.fastPendingSet) {
                this.fastPendingSet = false;
                this.impl.clearFastPending();
            }
        }
    }

    public static final class Handshake<T extends Consumer<Node>>
    implements Future<Void> {
        private final boolean sideEffecting;
        private volatile boolean cancelled;
        private final T action;
        private final boolean syncStartOfEvent;
        private final Barrier startBarrier;
        private final boolean syncEndOfEvent;
        private final Barrier endBarrier;
        private final int syncActionMaxWait;
        private final boolean syncActionPrintStackTraces;
        private final TruffleLogger engineLogger;
        private final AtomicBoolean warned = new AtomicBoolean(false);
        private final Map<Thread, Boolean> threads;
        private final Consumer<T> onDone;

        Handshake(Thread[] initialThreads, T action, Consumer<T> onDone, boolean sideEffecting, int numberOfThreads, boolean syncStartOfEvent, boolean syncEndOfEvent, int syncActionMaxWait, boolean syncActionPrintStackTraces, TruffleLogger engineLogger) {
            this.action = action;
            this.onDone = onDone;
            this.sideEffecting = sideEffecting;
            this.syncStartOfEvent = syncStartOfEvent;
            this.startBarrier = syncStartOfEvent ? new Barrier(numberOfThreads) : null;
            this.syncEndOfEvent = syncEndOfEvent;
            this.endBarrier = new Barrier(numberOfThreads);
            this.syncActionMaxWait = syncActionMaxWait;
            this.syncActionPrintStackTraces = syncActionPrintStackTraces;
            this.engineLogger = engineLogger;
            this.threads = new ConcurrentHashMap<Thread, Boolean>(Arrays.stream(initialThreads).collect(Collectors.toMap(t2 -> t2, t2 -> Boolean.FALSE)));
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        private boolean isTerminated() {
            return this.endBarrier.isTerminated();
        }

        void perform(Node node) {
            try {
                if (this.syncStartOfEvent) {
                    this.startBarrier.arrive();
                    this.await(this.startBarrier);
                }
                if (!this.cancelled) {
                    this.action.accept((Node)node);
                }
            }
            finally {
                this.endBarrier.arrive();
                if (this.syncEndOfEvent) {
                    this.await(this.endBarrier);
                    assert (this.isTerminated());
                }
                if (this.isTerminated()) {
                    this.onDone.accept(this.action);
                }
            }
        }

        private void await(Barrier barrier) {
            boolean interrupted;
            block14: {
                long remaining;
                interrupted = false;
                if (this.syncActionMaxWait == 0) {
                    while (true) {
                        try {
                            barrier.await();
                            break block14;
                        }
                        catch (InterruptedException e2) {
                            interrupted = true;
                            continue;
                        }
                        break;
                    }
                }
                long deadline = System.nanoTime() + TimeUnit.SECONDS.toNanos(this.syncActionMaxWait);
                boolean success = false;
                while ((remaining = deadline - System.nanoTime()) > 0L) {
                    try {
                        success = barrier.await(remaining, TimeUnit.NANOSECONDS);
                        break;
                    }
                    catch (InterruptedException e3) {
                        interrupted = true;
                    }
                }
                if (!success) {
                    if (this.awaitTimeout(barrier)) {
                        this.cancel(true);
                    } else {
                        while (true) {
                            try {
                                barrier.await();
                            }
                            catch (InterruptedException e4) {
                                interrupted = true;
                                continue;
                            }
                            break;
                        }
                    }
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }

        private boolean awaitTimeout(Barrier barrier) {
            if (this.warned.get() || !this.warned.compareAndSet(false, true)) {
                return false;
            }
            this.engineLogger.warning(barrier.getCount() + " threads did not reach the synchronous ThreadLocalAction " + String.valueOf(this.action) + " in " + this.syncActionMaxWait + " seconds. When using virtual threads this may be due to the issue that once more than Runtime.availableProcessors() virtual threads are pinned and waiting for each other, no virtual threads can progress (JDK-8334304). Cancelling this ThreadLocalAction to unblock. Use --engine.SynchronousThreadLocalActionPrintStackTraces=true to print thread stacktraces.");
            if (this.syncActionPrintStackTraces) {
                LinkedHashMap<StackTrace, List> grouped = new LinkedHashMap<StackTrace, List>();
                for (Map.Entry<Thread, Boolean> entry : this.threads.entrySet()) {
                    if (entry.getValue().booleanValue()) continue;
                    Thread thread = entry.getKey();
                    StackTrace stackTrace = new StackTrace(thread.getStackTrace());
                    grouped.computeIfAbsent(stackTrace, t2 -> new ArrayList()).add(thread);
                }
                for (Map.Entry<Thread, Boolean> entry : grouped.entrySet()) {
                    StringBuilder out = new StringBuilder("Stacktrace for:").append(System.lineSeparator());
                    for (Thread thread : (List)((Object)entry.getValue())) {
                        out.append(thread).append(System.lineSeparator());
                    }
                    Exception exception = new Exception();
                    exception.setStackTrace(((StackTrace)((Object)entry.getKey())).elements);
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    exception.printStackTrace(new PrintStream(stream));
                    String stackTraceString = stream.toString();
                    stackTraceString = stackTraceString.substring(stackTraceString.indexOf("\t"));
                    this.engineLogger.warning(String.valueOf(out) + stackTraceString);
                }
            }
            return true;
        }

        boolean activateThread() {
            if (this.syncStartOfEvent) {
                if (!this.startBarrier.register()) {
                    return false;
                }
                if (!this.endBarrier.register()) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
                return true;
            }
            return this.endBarrier.register();
        }

        void deactivateThread() {
            if (this.syncStartOfEvent) {
                this.startBarrier.arrive();
            }
            this.endBarrier.arrive();
            if (this.isTerminated()) {
                this.onDone.accept(this.action);
            }
        }

        @Override
        public Void get() throws InterruptedException {
            this.endBarrier.await();
            if (this.cancelled) {
                throw new CancellationException();
            }
            return null;
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
            if (!this.endBarrier.await(timeout, unit)) {
                throw new TimeoutException();
            }
            if (this.cancelled) {
                throw new CancellationException();
            }
            return null;
        }

        @Override
        public boolean isDone() {
            return this.cancelled || this.isTerminated();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (!this.isTerminated()) {
                this.cancelled = true;
                if (this.syncStartOfEvent) {
                    this.startBarrier.releaseAll();
                }
                this.endBarrier.releaseAll();
                return true;
            }
            return false;
        }

        public String toString() {
            return "Handshake[action=" + String.valueOf(this.action) + ", startBarrier=" + String.valueOf(this.startBarrier) + ", endBarrier=" + String.valueOf(this.endBarrier) + ", cancelled=" + this.cancelled + ", sideEffecting=" + this.sideEffecting + ", syncStartOfEvent=" + this.syncStartOfEvent + ", syncEndOfEvent=" + this.syncEndOfEvent + "]";
        }
    }

    static final class HandshakeEntry {
        final Handshake<?> handshake;
        final boolean reactivated;

        HandshakeEntry(Handshake<?> handshake, boolean reactivated) {
            this.handshake = handshake;
            this.reactivated = reactivated;
        }

        public String toString() {
            return "HandshakeEntry[" + String.valueOf(this.handshake) + " reactivated=" + this.reactivated + "]";
        }
    }

    private static final class Barrier
    extends AbstractQueuedSynchronizer {
        Barrier(int initialParties) {
            this.setState(initialParties);
        }

        @Override
        protected int tryAcquireShared(int acquires) {
            assert (acquires == 1);
            return this.getState() == 0 ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int releases) {
            int nextCount;
            int count;
            assert (releases == 1);
            do {
                if ((count = this.getState()) != 0) continue;
                return false;
            } while (!this.compareAndSetState(count, nextCount = count - 1));
            return nextCount == 0;
        }

        public boolean register() {
            int nextCount;
            int count;
            do {
                if ((count = this.getState()) != 0) continue;
                return false;
            } while (!this.compareAndSetState(count, nextCount = count + 1));
            return true;
        }

        public void arrive() {
            this.releaseShared(1);
        }

        public void await() throws InterruptedException {
            this.acquireSharedInterruptibly(1);
        }

        public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
            return this.tryAcquireSharedNanos(1, unit.toNanos(timeout));
        }

        public int getCount() {
            return this.getState();
        }

        public boolean isTerminated() {
            return this.getState() == 0;
        }

        public void releaseAll() {
            while (!this.isTerminated()) {
                this.arrive();
            }
        }
    }

    private static final class StackTrace {
        final StackTraceElement[] elements;

        private StackTrace(StackTraceElement[] elements) {
            this.elements = elements;
        }

        public int hashCode() {
            return Arrays.hashCode(this.elements);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (other == this) return true;
            if (!(other instanceof StackTrace)) return false;
            StackTrace stacktrace = (StackTrace)other;
            if (!Arrays.equals(this.elements, stacktrace.elements)) return false;
            return true;
        }
    }
}

