/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.NumberUtils;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportMessage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.SourceSection;

@ExportLibrary(value=InteropLibrary.class, receiverType=Float.class)
final class DefaultFloatExports {
    DefaultFloatExports() {
    }

    @ExportMessage
    static boolean fitsInByte(Float receiver) {
        float f2 = receiver.floatValue();
        byte b2 = (byte)f2;
        return (float)b2 == f2 && !NumberUtils.isNegativeZero(f2);
    }

    @ExportMessage
    static boolean fitsInShort(Float receiver) {
        float f2 = receiver.floatValue();
        short s2 = (short)f2;
        return (float)s2 == f2 && !NumberUtils.isNegativeZero(f2);
    }

    @ExportMessage
    static boolean fitsInInt(Float receiver) {
        int i2;
        float f2 = receiver.floatValue();
        return !NumberUtils.isNegativeZero(f2) && (i2 = (int)f2) != Integer.MAX_VALUE && (float)i2 == f2;
    }

    @ExportMessage
    static boolean fitsInLong(Float receiver) {
        long l2;
        float f2 = receiver.floatValue();
        return !NumberUtils.isNegativeZero(f2) && (l2 = (long)f2) != Long.MAX_VALUE && (float)l2 == f2;
    }

    @ExportMessage
    static boolean fitsInBigInteger(Float receiver) {
        return receiver.floatValue() % 1.0f == 0.0f && !NumberUtils.isNegativeZero(receiver.floatValue());
    }

    @ExportMessage
    static byte asByte(Float receiver) throws UnsupportedMessageException {
        float f2 = receiver.floatValue();
        byte b2 = (byte)f2;
        if ((float)b2 == f2 && !NumberUtils.isNegativeZero(f2)) {
            return b2;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static short asShort(Float receiver) throws UnsupportedMessageException {
        float f2 = receiver.floatValue();
        short s2 = (short)f2;
        if ((float)s2 == f2 && !NumberUtils.isNegativeZero(f2)) {
            return s2;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static int asInt(Float receiver) throws UnsupportedMessageException {
        int i2;
        float f2 = receiver.floatValue();
        if (!NumberUtils.isNegativeZero(f2) && (i2 = (int)f2) != Integer.MAX_VALUE && (float)i2 == f2) {
            return i2;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static long asLong(Float receiver) throws UnsupportedMessageException {
        long l2;
        float f2 = receiver.floatValue();
        if (!NumberUtils.isNegativeZero(f2) && (l2 = (long)f2) != Long.MAX_VALUE && (float)l2 == f2) {
            return l2;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static BigInteger asBigInteger(Float receiver) throws UnsupportedMessageException {
        if (!DefaultFloatExports.fitsInBigInteger(receiver)) {
            throw UnsupportedMessageException.create();
        }
        return DefaultFloatExports.toBigInteger(receiver.floatValue());
    }

    @CompilerDirectives.TruffleBoundary
    private static BigInteger toBigInteger(float receiver) {
        try {
            return new BigDecimal(receiver).toBigIntegerExact();
        }
        catch (ArithmeticException e2) {
            throw CompilerDirectives.shouldNotReachHere(e2);
        }
    }

    @ExportMessage
    static boolean isNumber(Float receiver) {
        return true;
    }

    @ExportMessage
    static boolean fitsInFloat(Float receiver) {
        return true;
    }

    @ExportMessage
    static float asFloat(Float receiver) {
        return receiver.floatValue();
    }

    @ExportMessage
    static boolean fitsInDouble(Float receiver) {
        return true;
    }

    @ExportMessage
    static double asDouble(Float receiver) {
        return receiver.floatValue();
    }

    @ExportMessage
    static boolean hasLanguage(Float receiver) {
        return false;
    }

    @ExportMessage
    static Class<? extends TruffleLanguage<?>> getLanguage(Float receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean hasSourceLocation(Float receiver) {
        return false;
    }

    @ExportMessage
    static SourceSection getSourceLocation(Float receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean hasMetaObject(Float receiver) {
        return false;
    }

    @ExportMessage
    static Object getMetaObject(Float receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    static Object toDisplayString(Float receiver, boolean allowSideEffects) {
        return receiver.toString();
    }
}

